<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Schools_Classes_Teachers extends Relio_Controller_Admin {
    public function action_index()
    {
        //parent::$_acl->check('schools_classes', 'list');
        
        $this->template->content = View::factory('admin/schools/classes/teachers/list.tpl')
            ->bind('message', $message)
            ->bind('item_id', $item_id)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();
        
        $item_id = $this->request->param('id');

        $builder = Jelly::select('school_class_teacher')
            ->with('user')
            ->with('class')
            ->where('school_class_teachers.class_id', '=', $item_id);
        
        //if (Auth::instance()->get_user()->has_role('moderator'))
        //{
        //    $builder->where('_school:school.user_id', '=', Auth::instance()->get_user()->id);
        //}
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'firstname' => URL::query(array('sort' => 'firstname', 'how' => $order_direction)),
            'lastname'  => URL::query(array('sort' => 'lastname', 'how' => $order_direction)),
            'email'     => URL::query(array('sort' => 'email', 'how' => $order_direction)),
        );
        
        switch (input::get('sort')) {
            case 'firstname':
                $builder->order_by('_user:user.firstname', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'lastname':
                $builder->order_by('_user:user.lastname', $order_how);
                $current_sort = array('type' => 'lastname', 'how' => $order_how);
            break;
            case 'email':
                $builder->order_by('_user:user.email', $order_how);
                $current_sort = array('type' => 'email', 'how' => $order_how);
            break;           
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        //parent::$_acl->check('schools_classes', 'add');
        
        $this->template->content = View::factory('admin/schools/classes/teachers/add.tpl')
            ->bind('errors', $errors);
        
        $class = Jelly::select('school_class', $this->request->param('id'));
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('students', 'not_empty');
            
            if ($post->check())
            {
                foreach(input::post('students') as $students) {
                    //$class->add('teacher', $students['id']);
                    list($insert_id, $total_rows) = DB::insert('school_class_teachers', array('class_id', 'user_id'))
                        ->values(array(
                            $class->id,
                            $students['id']
                        ))
                        ->execute();
                    
                    Tracker::track('Przypisano nauczyciela ID: '.$students['id'].' do klasy ID: '.$class->id);
                }

                message::good('Dodanie przebiegło pomyślnie', 'admin/schools_classes_teachers/index/'.$class->id);
            }
            else
            {
                $errors = $post->errors('backend/schools/classes/teachers/form');
            }
        }
    }

    public function action_delete()
    {
        //parent::$_acl->check('schools_classes', 'delete');
        
        $item = Jelly::select('school_class_teacher', $this->request->param('id'));
        if ($item->loaded())
        {
            Tracker::track('Usunięto nauczyciela ID: '.$item->user->id.' z klasy ID: '.$item->class->id);
            
            $item_id = $item->class->id;
            
            $item->delete();
            
            message::good('Zlecenie zostało usunięte pomyślnie', 'admin/schools_classes_teachers/index/'.$item_id);
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania zlecenia', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
            
            message::good('Operacja przeprowadzona pomyślnie', 'admin/schools_classes_teachers/index/'.$this->request->param('id').URL::query());
        }
    }
    
    /**
     * Checkbox - Usuń
     */
    private function _checkbox_delete()
    {
        //parent::$_acl->check('schools_classes', 'delete');
        
        if (is_array(input::post('list')))
        {
            $ids = array();
            foreach(input::post('list') as $key => $value) {
                $ids[] = $value;
            }
            
            if (empty($ids))
            {
                $ids[] = 0;
            }
            
            $items = Jelly::select('school_class_teacher')
                ->where('id', 'IN', $ids)
                ->execute();
        
            foreach($items as $it) {
                Tracker::track('Usunięto nauczyciela ID: '.$it->user->id.' z klasy ID: '.$it->class->id);
                
                $it->delete();
            }
        }
    }
}