<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Students_Groups extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('students_groups', 'list');

        $this->template->content = View::factory('smarty:admin/students/groups/list')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $builder = Jelly::select('user_group');
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name'    => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'default' => URL::query(array('sort' => 'default', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'default':
                $builder->order_by('default', $order_how);
                $current_sort = array('type' => 'default', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        if (input::get('limit')) {
            $limit = input::get('limit');
        }
        else {
            $limit = 10;
        }
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add() {
        parent::$_acl->check('students_groups', 'add');

        $this->template->content = View::factory('smarty:admin/students/groups/add')
            ->bind('errors', $errors)
            ->bind('users', $users);

        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check()) {
                $item = Jelly::factory('user_group');
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track(__('Dodano grupe studentów ID: ').$item->id);

                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/students_groups'.URL::query());
            }
            else {
                $errors = $post->errors('backend/users/groups/form');
            }
        }
    }

    public function action_edit() {
        parent::$_acl->check('students_groups', 'edit');

        $this->template->content = View::factory('smarty:admin/students/groups/edit')
            ->bind('errors', $errors)
            ->bind('item', $item);

        $item = Jelly::select('user_group', $this->request->param('id'));

        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check()) {
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track(__('Edycja grupy studentów ID: ').$item->id);

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/students_groups'.URL::query());
            }
            else {
                $errors = $post->errors('backend/users/groups/form');
            }
        }
    }

    public function action_default() {
        parent::$_acl->check('students', 'edit');

        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status)) {
            $ug = Jelly::select('user_group')
                ->where('default', '=', '1')
                ->limit(1)
                ->execute();

            if ($ug->loaded()) {
                $ug->default = 0;
                $ug->save();
            }

            $item = Jelly::select('user_group', $this->request->param('id'));
            if ($item->loaded()) {
                $item->default = $this->request->param('stuff');
                $item->save();

                Tracker::track(__('Zmiana domyślnej grupy studenta ID: ').$item->id);

                message::good(__('Status został zmieniony pomyślnie'), 'admin/students_groups'.URL::query());
            }
            else {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
            }
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
        }
    }

    public function action_delete() {
        parent::$_acl->check('students_groups', 'delete');

        $item = Jelly::select('user_group', $this->request->param('id'));

        if ($item->loaded()) {
            Tracker::track(__('Usunięto grupe studentów ID: ').$item->id);
            
            $item->delete();            

            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/students_groups'.URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }

    public function action_checkbox() {
        if ($_POST) {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('students_groups', 'delete');

                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('user_group', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Usunięto grupe studentów ID: ').$item->id);
                                
                                $item->delete();
                            }
                        }
                    }
                break;
            }

            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/students_groups'.URL::query());
        }
    }
}
