<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor/', 'PHPExcel');
require_once Kohana::find_file('vendor/PHPExcel/', 'IOFactory');
require_once Kohana::find_file('vendor/PHPExcel/Writer/', 'Excel5');

class Controller_Admin_Users extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('users', 'list');

        $this->template->content = View::factory('smarty:admin/users/list')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        if (input::get('group'))
        {
            $builder = Jelly::select('user')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', 'roles_users.user_id')
                ->on('roles_users.role_id', '=', DB::expr(input::get('group')))
                ->where('roles_users.role_id', '=', DB::expr(input::get('group')));
        }
        else
        {
            $builder = Jelly::select('user')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', 'roles_users.user_id')
                ->on('roles_users.role_id', '>', DB::expr(1))
                ->where('roles_users.role_id', '>', DB::expr(1));
        }
        
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'firstname'=> URL::query(array('sort' => 'firstname', 'how' => $order_direction)),
            'lastname' => URL::query(array('sort' => 'lastname', 'how' => $order_direction)),
            'phone'    => URL::query(array('sort' => 'phone', 'how' => $order_direction)),
            'role'     => URL::query(array('sort' => 'role', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'firstname':
                $builder->order_by('firstname', $order_how);
                $current_sort = array('type' => 'firstname', 'how' => $order_how);
            break;
            case 'lastname':
                $builder->order_by('lastname', $order_how);
                $current_sort = array('type' => 'course', 'how' => $order_how);
            break;
            case 'phone':
                $builder->order_by('phone1', $order_how);
                $current_sort = array('type' => 'phone', 'how' => $order_how);
            break;
            case 'role':
                $builder->join('roles', 'LEFT')
                    ->on('roles.id','=','roles_users.role_id')
                    ->order_by('roles.description', $order_how);
                $current_sort = array('type' => 'role', 'how' => $order_how);
            break;
            default:
                $builder->order_by('firstname', 'ASC');
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;

        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }
    
    public function action_ajax_select()
    {   
        $this->template = View::factory('admin/layout_iframe.tpl');
        $this->template->content = View::factory('admin/users/select.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        if (input::get('group'))
        {
            $builder = Jelly::select('user')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', 'roles_users.user_id')
                ->on('roles_users.role_id', '=', DB::expr(input::get('group')))
                ->where('roles_users.role_id', '=', DB::expr(input::get('group')));
        }
        else
        {
            $builder = Jelly::select('user')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', 'roles_users.user_id')
                ->on('roles_users.role_id', '>', DB::expr(1))
                ->where('roles_users.role_id', '>', DB::expr(1));
        }
        
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'firstname'=> URL::query(array('sort' => 'firstname', 'how' => $order_direction)),
            'lastname' => URL::query(array('sort' => 'lastname', 'how' => $order_direction)),
            'phone'    => URL::query(array('sort' => 'phone', 'how' => $order_direction)),
            'role'     => URL::query(array('sort' => 'role', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'firstname':
                $builder->order_by('firstname', $order_how);
                $current_sort = array('type' => 'firstname', 'how' => $order_how);
            break;
            case 'lastname':
                $builder->order_by('lastname', $order_how);
                $current_sort = array('type' => 'course', 'how' => $order_how);
            break;
            case 'phone':
                $builder->order_by('phone1', $order_how);
                $current_sort = array('type' => 'phone', 'how' => $order_how);
            break;
            case 'role':
                $builder->join('roles', 'LEFT')
                    ->on('roles.id','=','roles_users.role_id')
                    ->order_by('roles.description', $order_how);
                $current_sort = array('type' => 'role', 'how' => $order_how);
            break;
            default:
                $builder->order_by('firstname', 'ASC');
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;

        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        parent::$_acl->check('users', 'add');

        $this->template->content = View::factory('smarty:admin/users/add')
            ->bind('roles', $roles)
            ->bind('errors', $errors)
            ->bind('provinces', $provinces)
			->bind('subjects', $subjects);

        $provinces = Kohana::config('devilcms.provinces');
		
		$subjects = Jelly::select('subject')->execute();

        $roles = Jelly::select('role')->execute();

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('role', 'not_empty')
                ->rule('email', 'not_empty', array('email'))
                ->rule('firstname', 'not_empty')
                ->rule('lastname', 'not_empty')
                ->rule('city', 'not_empty')
                ->callback('email', 'Model_Auth_User::is_email_uniq');
            
            if ($post->check())
            {
                $validate = Validate::factory($_FILES);
                $validate->rules('icon', array('Upload::valid' => array(), 'Upload::not_empty' => array(), 'Upload::size' => array('400M')));
                
                if ($validate->check())
                {
                    $filename = Upload::save($_FILES['icon'], null, DOCROOT . 'upload/avatars');
                }
                else
                {
                    $filename = '';
                }

                if (input::post('password_own')) {
                    $temp_password = input::post('password_own');
                }
                else {
                    $temp_password = Text::random();
                }
                
                $_POST['password'] = $temp_password;
                $_POST['password_confirm'] = $temp_password;
				
				$subject = '';
				foreach ((array)input::post('subject') as $it) {
					$subject .= ','.$it;
				}
				$subject = trim($subject);
                
                $item = Jelly::factory('user');
                $item->password = Security::xss_clean(input::post('password'));
                $item->password_confirm = Security::xss_clean(input::post('password_confirm'));
                $item->email = Security::xss_clean(input::post('email'));
                $item->username = Security::xss_clean(input::post('email'));
                $item->firstname = Security::xss_clean(input::post('firstname'));
                $item->lastname = Security::xss_clean(input::post('lastname'));
                $item->city = Security::xss_clean(input::post('city'));
                $item->address = Security::xss_clean(input::post('address'));
                $item->home = Security::xss_clean(input::post('home'));
                $item->flat = Security::xss_clean(input::post('flat'));
                $item->postcode = Security::xss_clean(input::post('postcode'));
                $item->province = Security::xss_clean(input::post('province'));
                $item->phone1 = Security::xss_clean(input::post('phone1'));
                $item->phone2 = Security::xss_clean(input::post('phone2'));
                $item->position = Security::xss_clean(input::post('position'));
				$item->subject = $subject;
                $item->active = 1;
                $item->icon = (($filename) ? basename($filename) : '');
                $item->roles = array(1, input::post('role'));
                $item->save();
                
                if (input::post('notify') == '1')
                {
                    $replaceData = array();
                    $replaceData['%firstname%'] = Security::xss_clean(input::post('firstname'));
                    $replaceData['%lastname%'] = Security::xss_clean(input::post('lastname'));
                    $replaceData['%login%'] = Security::xss_clean(input::post('email'));
                    $replaceData['%password%'] = Security::xss_clean(input::post('password'));
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
					$replaceData['%platform_link%'] = URL::site('/', 'http');
                    xwContentTemplateWrapper::parameter_email(2, $replaceData, Security::xss_clean(input::post('email')), CFG_WEBMASTER_EMAIL);
                }
                    
                Tracker::track(__('Dodano nowego administratora ID: ').$item->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/users');
            }
            else
            {
                $errors = $post->errors('backend/users/form');
            }
        }
    }

    public function action_edit()
    {
        parent::$_acl->check('users', 'edit');

        $this->template->content = View::factory('smarty:admin/users/edit')
            ->bind('errors', $errors)
            ->bind('roles', $roles)
            ->bind('provinces', $provinces)
			->bind('subjects', $subjects)
            ->bind('item', $item)
			->bind('selected_subject', $selected_subject);

        $provinces = Kohana::config('devilcms.provinces');
		
		$subjects = Jelly::select('subject')->execute();
        
        $item = Jelly::select('user', $this->request->param('id'));
        
        $roles = Jelly::select('role')->execute();
		
		$selected_subject = explode(',', $item->subject);

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->filter('id', 'trim')
                ->rule('role', 'not_empty')
                ->rule('email', 'not_empty')
                ->rule('firstname', 'not_empty')
                ->rule('lastname', 'not_empty')
                ->rule('city', 'not_empty')
                ->callback('email', 'Model_Auth_User::email_change');
            
            if ($post->check())
            {
				$subject = '';
				foreach ((array)input::post('subject') as $it) {
					$subject .= ','.$it;
				}
				$subject = trim($subject);
				
                if (input::post('image_action') == '3')
                {
                    $validate = Validate::factory($_FILES);
                    $validate->rules('icon', array('Upload::valid' => array(), 'Upload::not_empty' => array(), 'Upload::size' => array('400M')));
                    
                    if ($validate->check())
                    {
                        $filename = Upload::save($_FILES['icon'], null, DOCROOT . 'upload/avatars');
                    }
                    else
                    {
                        $filename = '';
                    }
                }
                elseif (input::post('image_action') == '1')
                {
                    $filename = input::post('tmpIcon');
                }
                elseif (input::post('image_action') == '2')
                {
                    @unlink('upload/avatars/'.input::post('tmpIcon'));
                    
                    $filename = '';
                }
                else
                {
                    $filename = '';
                }

                $item->email = Security::xss_clean(input::post('email'));
                $item->username = Security::xss_clean(input::post('email'));
                $item->firstname = Security::xss_clean(input::post('firstname'));
                $item->lastname = Security::xss_clean(input::post('lastname'));
                $item->city = Security::xss_clean(input::post('city'));
                $item->address = Security::xss_clean(input::post('address'));
                $item->home = Security::xss_clean(input::post('home'));
                $item->flat = Security::xss_clean(input::post('flat'));
                $item->postcode = Security::xss_clean(input::post('postcode'));
                $item->province = Security::xss_clean(input::post('province'));
                $item->phone1 = Security::xss_clean(input::post('phone1'));
                $item->phone2 = Security::xss_clean(input::post('phone2'));
                $item->position = Security::xss_clean(input::post('position'));
				$item->subject = $subject;
                $item->icon = (($filename) ? basename($filename) : '');
                $item->roles = array(1, input::post('role'));
                $item->save();
                
                Tracker::track(__('Edycja użytkownika ID: ').$item->id);
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/users'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/users/form');
            }
        }
    }
	
	public function action_import()
    {
        parent::$_acl->check('users', 'edit');

        $this->template->content = View::factory('admin/users/import.tpl')
            ->bind('errors', $errors)
            ->bind('message', $message)
			->bind('groups', $groups);
            
        $message = message::get_once();
        
		$groups = Jelly::select('role')
			->where('id', '!=', 1)
			->where('id', '!=', 2)
			->execute();
		
        $return = array(
            'error' => array()
        );
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('hidFileID', 'not_empty');

            $errors = array();

            if ($post->check())
            {
                $return = $this->checkXLS(Security::xss_clean(input::post('hidFileID')));
            }
            else
            {
                $errors = array_merge($return['error'], $post->errors());
            }
        }
    }
    
    public function action_import2()
    {
        $this->importXLS(base64_decode($this->request->param('id')));
        
        message::good('Import przebiegł pomyślnie', 'admin/users/import');
    }
    
    public function action_notify()
    {
        parent::$_acl->check('users', 'notify');
        
        $item = Jelly::select('user', $this->request->param('id'));
        
        if ($item->loaded())
        {
            Tracker::track(__('Wysłano powiadomienie dla konta ID: ').$item->id);
            
            $temp_password = Text::random();
            
            $item->password = $temp_password;
            $item->password_confirm = $temp_password;
            $item->save();
            
            $replaceData = array();
            $replaceData['%firstname%'] = $item->firstname;
            $replaceData['%lastname%'] = $item->lastname;
            $replaceData['%login%'] = $item->email;
            $replaceData['%password%'] = $temp_password;
            $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
            $replaceData['%platform_link%'] = URL::site('/', 'http');
            xwContentTemplateWrapper::parameter_email(2, $replaceData, $item->email, CFG_WEBMASTER_EMAIL);
        
            message::good(__('Powiadomienie zostało wysłane pomyślnie'), 'admin/users'.URL::query());
        }
        else
        {
            message::error(__('Wystąpił błąd podczas wysyłania powiadomienia'), 'admin/users'.URL::query());
        }
    }

    public function action_delete()
    {
        parent::$_acl->check('users', 'delete');

        $item = Jelly::select('user', $this->request->param('id'));

        if ($item->loaded())
        {
            if (in_array($this->request->param('id'), array('1')))
            {
                message::error(__('Nie możesz usunąć tej osoby'), 'admin/users'.URL::query());
            }
            else
            {
                Tracker::track(__('Usunięto użytkownika ID: ').$item->id);
                
                $item->delete();

                message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/users'.URL::query());
            }
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania', 'admin'.URL::query());
        }
    }

    public function action_profile()
    {
        $this->template->content = View::factory('smarty:admin/users/profile')
            ->bind('message', $message)
            ->bind('errors', $errors)
            ->bind('provinces', $provinces)
            ->bind('item', $item);

        $provinces = Kohana::config('devilcms.provinces');

        $message = message::get_once();

        $item = Jelly::select('user', Auth::instance()->get_user()->id);

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->filter('id', 'trim')
                ->rule('email', 'not_empty')
                ->rule('firstname', 'not_empty')
                ->rule('lastname', 'not_empty')
                ->rule('city', 'not_empty')
                ->callback('email', 'Model_Auth_User::email_change');
            
            if ($post->check())
            {
                if (input::post('image_action') == '3')
                {
                    $validate = Validate::factory($_FILES);
                    $validate->rules('icon', array('Upload::valid' => array(), 'Upload::not_empty' => array(), 'Upload::size' => array('400M')));
                    
                    if ($validate->check())
                    {
                        $filename = Upload::save($_FILES['icon'], null, DOCROOT . 'upload/avatars');
                    }
                    else
                    {
                        $filename = '';
                    }
                }
                elseif (input::post('image_action') == '1')
                {
                    $filename = input::post('tmpIcon');
                }
                elseif (input::post('image_action') == '2')
                {
                    @unlink('upload/avatars/'.input::post('tmpIcon'));
                    
                    $filename = '';
                }
                else
                {
                    $filename = '';
                }
                    
                $item->email = Security::xss_clean(input::post('email'));
                $item->username = Security::xss_clean(input::post('email'));
                $item->firstname = Security::xss_clean(input::post('firstname'));
                $item->lastname = Security::xss_clean(input::post('lastname'));
                $item->city = Security::xss_clean(input::post('city'));
                $item->address = Security::xss_clean(input::post('address'));
                $item->home = Security::xss_clean(input::post('home'));
                $item->flat = Security::xss_clean(input::post('flat'));
                $item->postcode = Security::xss_clean(input::post('postcode'));
                $item->province = Security::xss_clean(input::post('province'));
                $item->phone1 = Security::xss_clean(input::post('phone1'));
                $item->phone2 = Security::xss_clean(input::post('phone2'));
                $item->icon = (($filename) ? basename($filename) : '');
                $item->save();

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/users/profile');
            }
            else
            {
                $errors = $post->errors('backend/users/form');
            }
        }
    }

    public function action_password()
    {
        $this->template->content = View::factory('smarty:admin/users/pass')
            ->bind('message', $message)
            ->bind('errors', $errors)
            ->bind('item', $item);

        $message = message::get_once();

        $item = Jelly::select('user', Auth::instance()->get_user()->id);

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('password', 'not_empty')
                ->rule('password_confirm', 'not_empty')
                ->rule('password_confirm', 'matches', array('password'));
            
            if ($post->check())
            {
                $item->password = Security::xss_clean(input::post('password'));
                $item->password_confirm = Security::xss_clean(input::post('password_confirm'));
                $item->save();

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/users/password');

            }
            else
            {
                $errors = $post->errors('backend/users/form');
            }
        }
    }

    public function action_checkbox()
    {
        if ($_POST)
        {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('users', 'delete');

                    if (is_array(input::post('list')))
                    {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('user', $value);
                            if ($item->loaded())
                            {
                                if (!in_array($this->request->param('id'), array('1')))
                                {
                                    Tracker::track(__('Usunięto użytkownika ID: ').$item->id);
                                    
                                    $item->delete();
                                }
                            }
                        }
                    }
                break;
                case 'notify':
                    parent::$_acl->check('users', 'notify');
                     
                    if (is_array(input::post('list'))) {
                        foreach(input::post('list') as $key => $value) {
                            $item = Jelly::select('user', $value);
                            if ($item->loaded())
                            {
                                Tracker::track(__('Wysłano powiadomienie dla konta ID: ').$item->id);
                                
                                $temp_password = Text::random();
            
                                $item->password = $temp_password;
                                $item->password_confirm = $temp_password;
                                $item->save();
                                
                                $replaceData = array();
                                $replaceData['%firstname%'] = $item->firstname;
                                $replaceData['%lastname%'] = $item->lastname;
                                $replaceData['%login%'] = $item->email;
                                $replaceData['%password%'] = $temp_password;
                                $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                                $replaceData['%platform_link%'] = URL::site('/', 'http');
                                xwContentTemplateWrapper::parameter_email(2, $replaceData, $item->email, CFG_WEBMASTER_EMAIL);
                            }
                        }
                    }
                break;
                default:
                break;
            }

            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/users'.URL::query());
        }
    }
	
	public function checkXLS($file)
    {
        $inputFileType = PHPExcel_IOFactory::identify($file);
        
        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
        
        $objPHPExcel = $objReader->load($file);
        
        $sheetData = $objPHPExcel->getActiveSheet()->toArray(null, false, false, true);
        
        $errors = array(
            'error' => array()
        );
        
        $i = 1;
        
        $first = true;
        foreach($sheetData as $row) {
            if ($first) {
                $first = false;
                
                continue;
            }
            
            if (! Validate::not_empty(trim($row['A'])))
            {
                $errors['error']['firstname'] = 'Brak imienia w wierszu '.$i;
            }
            
            if (! Validate::not_empty(trim($row['B'])))
            {
                $errors['error']['firstname'] = 'Brak nazwiska w wierszu '.$i;
            }          
						
            if (! empty($row['C']) AND ! Validate::email(trim($row['C'])))
            {
                $errors['error']['email'] = 'Błędny e-mail w wierszu '.$i;
            }              

			if (! Validate::not_empty(trim($row['D'])))
            {
                $errors['error']['password'] = 'Brak hasla w wierszu '.$i;
            }

			if (! Validate::not_empty(trim($row['E'])))
            {
                $errors['error']['password'] = 'Brak grupy w wierszu '.$i;
            }			
			
            $i++;
        }
        
        return $errors;
    }
    
    public function importXLS($file)
    {
        $inputFileType = PHPExcel_IOFactory::identify($file);
        
        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
        
        $objPHPExcel = $objReader->load($file);
        
        $sheetData = $objPHPExcel->getActiveSheet()->toArray(null, false, false, true);
        
        $first = true;
        foreach($sheetData as $row) {
            if ($first) 
            {
                $first = false;
                continue;
            }
            
            $item = Jelly::select('user')
                ->where('email', '=', trim($row['C']))
                ->limit(1)
                ->execute();
            
            if (! $item->loaded())
            {   
                $item = Jelly::factory('user');
                $item->password = trim($row['D']);
                $item->password_confirm = trim($row['D']);
                $item->email = trim($row['C']);
                $item->username = $item->email;
                $item->firstname = trim($row['A']);
                $item->lastname = trim($row['B']);
                $item->active = 1;
                $item->roles = array(1, $row['E']);
                $item->save();
            }
        }
    }
}
