<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Welcome extends Relio_Controller_Admin {
    public function action_index()
    {
        $this->template->content = View::factory('smarty:admin/dashboard')
            ->bind('message', $message)
            ->bind('total_courses', $total_courses)
            ->bind('total_students', $total_students)
            ->bind('accepted', $accepted)
            ->bind('pending', $pending)
            ->bind('rejected', $rejected);
   
        $message = message::get_once();
            
        $total_courses = Jelly::select('course')
        	->count();

        $total_students = DB::select(DB::expr('COUNT(DISTINCT user_id) AS mycount'))
            ->from('roles_users')
            ->where('role_id', '=', '2')                                
            ->execute()
            ->get('mycount'); 

        $accepted = Jelly::select('course_user')
        	->where('active', '=', '1')
        	->limit(10)
        	->order_by('id', 'DESC')
        	->execute();


        $pending = Jelly::select('course_user')
        	->where('active', '=', '2')
        	->limit(10)
        	->order_by('id', 'DESC')
        	->execute();

        $rejected = Jelly::select('course_user')
        	->where('active', '=', '0')
        	->limit(10)
        	->order_by('id', 'DESC')
        	->execute();
	}
}