<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Forum extends Relio_Controller_Website {
    public function before()
    {
        parent::before();        
        
        DB::delete('forum_topic_views')
            ->where('expire', '<', time())
            ->execute(); 
           
        View::set_global('in_page', 'forum');      
    }
    
    public function action_index()
    {
        if (! Auth::instance()->logged_in())
        {
			message::error('Musisz być zalogowany aby uzyskać dostęp do tego miejsca', 'user/login', 'frontend');
		}
        
        $this->template->content = View::factory('site/forum/showforums.tpl')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('message', $message)
            ->bind('items', $items);
        
        $message = message::get_once('frontend');        
        
        if (input::get('cid'))
        {
            $items = Jelly::select('forum_category')
                ->where('id', '=', input::get('cid'))
                ->where('active', '=', 1)
                ->execute();
        }
        else
        {
            $items = Jelly::select('forum_category')
                ->where('active','=', 1)
                ->execute();
        }
        
        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Forum'), URL::site('forum'), true)
            ->render();        
    }
    
    public function action_showtopics()
    {
        if (! Auth::instance()->logged_in())
        {
			message::error('Musisz być zalogowany aby uzyskać dostęp do tego miejsca', 'user/login', 'frontend');
		}
        
        $item = Jelly::select('forum_forum', $this->request->param('id'));
        if ($item->loaded())
        {
            if ($item->course->id AND ! Auth::instance()->get_user()->is_subscribed($item->course->id))
            {
                message::error('Aby uzyskać dostęp do tego formu musisz być zapisany na szkolenie', 'forum', 'frontend');
            }
            
            $pass = false;
            
            if ($item->password <> '')
            {                
                $p1 = Cookie::get('f_pass_id_'.$item->id);
                $p2 = $item->password;
                
                if( $p1 == $p2 )
                {
                    $pass = true;
                }
                else
                {
                    $this->template->content = View::factory('site/forum/password.tpl')
                        ->bind('errors', $errors)
                        ->bind('forum', $item);
                
                    if ($_POST)
                    {
                        if (md5(input::post('pass')) == $item->password)
                        {
                            Cookie::set('f_pass_id_'.$item->id, md5(input::post('pass')));
                            
                            Request::instance()->redirect('forum/showtopics/'.$item->id);
                        }
                        else
                        {
                            $errors = array('password' => 'Podane hasło jest błędne');
                        }
                    }
                }
            }
            else
            {
                $pass = true;
            }
            
            if ($pass)
            {
                $this->template->content = View::factory('site/forum/showforum.tpl')
                    ->bind('message', $message)
                    ->bind('forum', $item)
                    ->bind('mods', $mods)
                    ->bind('categories_dropdown', $categories_dropdown)
                    ->bind('topics', $topic_array);
                
                $message = message::get_once('frontend');
                
                //moderatorzy
                $mods = Jelly::select('forum_mod')->where('forum_id','=',$item->id)->execute();
                
                //jumpbox
                $categories = array();
                Forum::get_categories(0, $categories, '');
                
                $categories_dropdown = $categories;
                                
                $allowed_sort = array('post_on', 'name', 'replies', 'firstname', 'views', 'rating');
                
                $order_direction = (input::get('sort')) ? input::get('sort') : 'DESC';
                $orderby = (input::get('order') && input::get('order') != '' && (in_array(input::get('order'), $allowed_sort))) ? input::get('order') : 'post_on';
                
                $builder = Jelly::select('forum_topic')
                    ->with('post')
                    ->with('user')
                    ->where('forum_id', '=', $item->id);
                    
                if (! Forum::is_mod($this->request->param('id')))
                {
                    $builder->where('forum_topics.active', '=', '1');
                }
                
                if (input::get('period') <> 'all') {
                    switch (input::get('unit')) {
                        case 'h':
                            $divisor = 60 * 60;
                            $builder->where(DB::expr('((UNIX_TIMESTAMP(NOW()) / '.$divisor.') - (UNIX_TIMESTAMP(`_forum_post:post`.`created_on`) / '.$divisor.'))'), '<=', input::get('period'));
                        break;
                        case 'd':
                            $divisor = 60 * 60 * 24;
                            $builder->where(DB::expr('((UNIX_TIMESTAMP(NOW()) / '.$divisor.') - (UNIX_TIMESTAMP(`_forum_post:post`.`created_on`) / '.$divisor.'))'), '<=', input::get('period'));
                        break;
                        case 'm':
                            $divisor = 60 * 60 * 24 * 30;
                            $builder->where(DB::expr('((UNIX_TIMESTAMP(NOW()) / '.$divisor.') - (UNIX_TIMESTAMP(`_forum_post:post`.`created_on`) / '.$divisor.'))'), '<=', input::get('period'));
                        break;
                        default:
                        break;
                    }
                }
                
                $builder->order_by('type', 'DESC')->order_by($orderby, $order_direction);
                
                $order_direction = ($order_direction == 'DESC') ? 'ASC' : 'DESC';
                
                $limit = 30;
                
                $pagination = Pagination::factory();
                $pagination->setup(array(
                    'total_items' => $count,
                    'items_per_page' => $limit
                ));
                $items = $builder->offset($pagination->offset)->limit($limit)->execute();
                
                $topic_array = array();                
                foreach($items as $it) {                    
                    $view_count = DB::select(DB::expr('COUNT(ip) AS view_count'))
                        ->from('forum_topic_views')
                        ->where('topic_id', '=', $it->id)
                        ->execute()
                        ->get('view_count');
                        
                    $topic['id'] = $it->id;
                    $topic['name'] = $it->name;
                    $topic['type'] = $it->type;
                    $topic['opened'] = $it->opened;
                    $topic['viewing'] = $view_count;
                    $topic['posticon'] = $it->icon->icon;                    
                    $topic['author'] = $it->user->firstname.' '.$it->user->lastname;
                    $topic['author_id'] = $it->user->id;
                    $topic['lastposter'] = $it->post;
                    
                    /**
                     * ilosc odpowiedzi i pare linkow do podstron przy tytule watka
                     */                          
                    $post_count = DB::select(DB::expr('COUNT(*) AS post_count'))
                        ->from('forum_posts')
                        ->where('topic_id', '=', $it->id)
                        ->execute()
                        ->get('post_count');
                    
                    $numPages = Forum::get_page_num($post_count, 30);
                    $topic['navigation_page'] = ($numPages == 1) ? 0 : $numPages;
                    $topic['next_page'] = $numPages;
                    $topic['replies'] = $post_count;
                    
                    if ($it->active == 2)
                    {
                        $topic["statusicon"] = Forum::get_icon("thread_moved.png", "moved");
                    }
                    else
                    {
                        if (! Auth::instance()->logged_in() || $item->active == 0)
                        {
                            $topic["statusicon"] = Forum::get_icon("thread_lock.png", 'Wątek jest zamkięty');
                        }
                        else
                        {
                            $topic['statusicon'] = Forum::set_topic_icon($it, $item, $topic['replies']);
                        }
                    }
                    
                    array_push($topic_array, $topic);
                }
            }
            
            $this->title = $item->name.' - Forum';
            
            $breadcrumbs = Breadcrumbs::getInstance()
                ->addItem(__('Strona główna'), URL::site('/'))
                ->addItem(__('Forum'), URL::site('forum'))
                ->addItem($item->name, URL::site('forum/showtopics/'.$item->id), true)
                ->render();
        }
        else
        {
            message::error('Takie forum nie istnieje', 'forum', 'frontend');
        }
    }
    
    /**
     * Wyświetlanie tresci danego tematu
     */
    public function action_showtopic()
    {
        if (! Auth::instance()->logged_in())
        {
			message::error('Musisz być zalogowany aby uzyskać dostęp do tego miejsca', 'user/login', 'frontend');
		}
        
        $topic = Jelly::select('forum_topic', $this->request->param('id'));
        
        if ($topic->loaded())
        {
            if ($topic->forum->course->id AND ! Auth::instance()->get_user()->is_subscribed($topic->forum->course->id))
            {
                message::error('Aby uzyskać dostęp do tego formu musisz być zapisany na szkolenie', 'forum', 'frontend');
            }
            
            $pass = false;
            
            if ($topic->forum->password <> '')
            {
                $p1 = Cookie::get('f_pass_id_'.$topic->forum->id);
                $p2 = $topic->forum->password;
                
                if( $p1 == $p2 )
                {
                    $pass = true;
                }
                else {
                    $this->template->content = View::factory('site/forum/password.tpl')
                        ->bind('errors', $errors)
                        ->bind('topic', $topic);
                
                    if ($_POST)
                    {
                        if (md5(input::post('pass')) == $topic->forum->password)
                        {
                            Cookie::set('f_pass_id_'.$topic->forum->id, md5(input::post('pass')));
                            
                            Request::instance()->redirect('forum/showtopic/'.$topic->id);
                        }
                        else
                        {
                            $errors = array('password' => 'Podane hasło jest błędne');
                        }
                    }
                }
            }
            else
            {
                $pass = true;
            }
            
            if ($pass)
            {
                if (input::get('print') == '1')
                {
                    $print_template = View::factory('smarty:site/forum/showtopic_print')
                        ->bind('breadcrumbs', $breadcrumbs)
                        ->bind('message', $message)
                        ->bind('topic', $topic)
                        ->bind('canabo', $canabo)
                        ->bind('next_topic', $next_topic)
                        ->bind('prev_topic', $prev_topic)
                        ->bind('postings', $post_array);
                }
                else
                {
                    $this->template->content = View::factory('smarty:site/forum/showtopic')
                        ->bind('breadcrumbs', $breadcrumbs)
                        ->bind('message', $message)
                        ->bind('categories_dropdown', $categories_dropdown)
                        ->bind('topic', $topic)
                        ->bind('canabo', $canabo)
                        ->bind('next_topic', $next_topic)
                        ->bind('prev_topic', $prev_topic)
                        ->bind('ismod', $ismod)
                        ->bind('ismodtopic', $ismodtopic)
                        ->bind('pagination', $pagination)
                        ->bind('postings', $post_array)
                        ->bind('lastposts', $lastposts)
                        ->bind('mods', $mods);
                }
                
                $message = message::get_once('frontend');
                
                $ismod = Forum::is_mod($topic->forum->id);
                
                $ismodnotadmin = Forum::is_mod_exclude_admin($topic->forum->id);
                
                $this->title = $topic->title;
                
                
                    $mods = Jelly::select('forum_mod')->where('forum_id','=',$topic->forum->id)->execute();
                
                /**
                 * Pobieranie listy postow
                 */
                $builder = Jelly::select('forum_post')
                    ->where('topic_id', '=', $topic->id);
                
                if (! Forum::is_mod($this->request->param('id')))
                {
                    $builder->where('opened', '=', '1');
                }
                
                $builder->order_by('created_on', 'ASC');
                
                $limit = 30;
                
                $pagination = Pagination::factory();
                $pagination->setup(array(
                    'total_items' => $builder->count(),
                    'items_per_page' => $limit
                ));
                
                $items = $builder->offset($pagination->offset)->limit($limit)->execute();
                
                $post_array = array();
                foreach($items as $it) {
                    $postings = DB::select(DB::expr('COUNT(*) AS count'))
                        ->from('forum_posts')
                        ->where('user_id', '=', $it->user->id)
                        ->execute()
                        ->get('count');
                    
                    $rank = Jelly::select('forum_rank')
                        ->where('count', '<=', $postings)
                        ->where('active', '=', '1')
                        ->order_by('count', 'DESC')
                        ->limit(1)
                        ->execute();
                    
                    $post['id'] = $it->id;
                    $post['name'] = $it->name;
                    $post['content'] = Forum::initial_message_parse($it->content);
                    $post['user'] = $it->user;
                    $post['rank'] = $rank->title;
                    $post['user_posts'] = $postings;
                    $post['created_on'] = $it->created_on;
                    
                    if ($ismodnotadmin || $ismodtopic)
                    {
                        $post['is_moderator'] = true;
                    }
                    else
                    {
                        $post['is_moderator'] = false;
                    }
                    
                    
                    /**
                     * Wylacz formatowanie
                     */
                    if ($post->use_bbcode)
                    {
                        $post['content'] = strip_tags($post['content']);
                    }
                    
                    /**
                     * Wlacz usmieszki
                     */
                    if ($post->use_smilies)
                    {
                        $post['content'] = Forum::emoticons($post['content']);
                    }
                    
                    /**
                     * Automatyczne rozpoznawanie linkow
                     */
                    if ($post->use_links)
                    {
                        $post['content'] = Text::auto_link($post['content']);
                    }
                    
                    $post['content'] = Forum::badword($post['content']);
                    
                    $post['attachments'] = Jelly::select('attachment')
                        ->filter($it->id, 'forum_post')
                        ->execute();
                    
                    array_push($post_array, $post);
                }
                
                /**
                 * Ile osob czyta teraz ten temat
                 */
                $expire = time() + (300);
                
                $count_viewers = DB::select(DB::expr('COUNT(*) AS count_viewers'))
                    ->from('forum_topic_views')
                    ->where('ip','=',$_SERVER['REMOTE_ADDR'])
                    ->where('topic_id','=',$topic->id)
                    ->execute()->get('count_viewers');
                        
                if ($count_viewers < 1)
                {
                    DB::insert('forum_topic_views', array('ip','topic_id','expire'))->values(array($_SERVER['REMOTE_ADDR'], $topic->id, $expire))->execute();
                }
                else
                {
                    DB::update('forum_topic_views')->set(array('expire'=>$expire))->where('topic_id','=',$topic->id)->where('ip','=',$_SERVER['REMOTE_ADDR'])->execute();
                }
                
                /**
                 * Licznik wyswietlen
                 */
                DB::update('forum_topics')->set(array('views'=>DB::expr('views+1')))->where('id','=',$topic->id)->execute();
            
                /**
                 * Czy uzytkownik moze subskrybowac watek
                 */
                $user_id = explode(";", $topic->notification);
                if (Auth::instance()->logged_in()) {
                    $canabo = ((@in_array(Session::instance()->get('auth_user')->id, $user_id)) ? 0 : 1);
                }
                else {
                    $canabo = 0;
                }
                
                /**
                 * Nastepny watek
                 */
                $next_topic = Jelly::select('forum_topic')->where('id','<',$topic->id)->where('forum_id','=',$topic->forum->id)->order_by('id', 'DESC')->limit(1)->execute();
                
                /**
                 * Poprzedni watek
                 */
                $prev_topic = Jelly::select('forum_topic')->where('id','>',$topic->id)->where('forum_id','=',$topic->forum->id)->order_by('id', 'ASC')->limit(1)->execute();
                
                
                /**
                 * Oznacz jako przeczytane
                 */
                if (Auth::instance()->logged_in()) {
                    Forum::set_topic_read($topic->id, Session::instance()->get('auth_user')->id);
                }
                
                /**
                 * Drop down
                 */
                $categories = array();
                Forum::get_categories(0, $categories, '');
                
                $categories_dropdown = $categories;
                
                if (input::get('print')) {
                    echo $print_template->render();
                    exit;
                }
            }
            
            $this->title = $topic->name.' - Wątek';
            
            $breadcrumbs = Breadcrumbs::getInstance()
                ->addItem(__('Strona główna'), URL::site('/'))
                ->addItem(__('Forum'), URL::site('forum'))
                ->addItem($topic->forum->name, URL::site('forum/showtopics/'.$topic->forum->id))
                ->addItem($topic->name, URL::site('forum/showtopic/'.$topic->id), true)
                ->render();
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum', 'frontend');
        }
    }
    
    public function action_addtopic()
    {
        if (! Auth::instance()->logged_in())
        {
			message::error('Musisz być zalogowany aby uzyskać dostęp do tego miejsca', 'user/login', 'frontend');
		}
        
        $forum = Jelly::select('forum_forum', $this->request->param('id'));
        
        if ($forum->loaded())
        {
            if ($forum->course->id AND ! Auth::instance()->get_user()->is_subscribed($forum->course->id))
            {
                message::error('Aby uzyskać dostęp do tego formu musisz być zapisany na szkolenie', 'forum', 'frontend');
            }
            
            $this->template->content = View::factory('site/forum/addtopic.tpl')
                ->bind('breadcrumbs', $breadcrumbs)
                ->bind('errors', $errors)
                ->bind('forum', $forum)
                ->bind('posticons', $posticons)
                ->bind('emoticons', $emoticons)
                ->bind('is_mod', $is_mod);
            
            $posticons = Jelly::select('forum_posticon')
                ->filter(array(
                    'active' => 1
                ))
                ->execute();
                
            $emoticons = Jelly::select('forum_emoticon')
                ->filter(array(
                    'active' => 1
                ))
                ->execute()
                ->as_array();
            
            $is_mod = Forum::is_mod($forum->id);
            
            if ($forum->locked == 1  && !$is_mod)
            {
                message::error('Nie możesz dodawać wątków w tym forum gdyż jest ono zamknięte', 'forum/showtopics/'.$forum->id, 'frontend');
            }
            
            if ($_POST)
            {
                $post = Validate::factory($_POST)
                    ->rule('name', 'not_empty')
                    ->rule('content', 'not_empty');
                
                if ($post->check())
                {
                    $notification = (input::post('notification')) ? ';' . Auth::instance()->get_user()->id : '';
                    
                    $active = ($forum->moderated == 1) ? 0 : 1;
                    
                    if ($is_mod)
                    {
                        $active = 1;
                    }
                    
                    //zapisz temat do bazy
                    $topic = Jelly::factory('forum_topic');
                    $topic->forum = $forum->id;
                    $topic->user = Auth::instance()->get_user()->id;
                    $topic->icon = input::post('icon');
                    $topic->name = Security::xss_clean(input::post('name'));
                    $topic->slug = URL::prepare_url(Security::xss_clean(input::post('name')));                    
                    $topic->notification = $notification;
                    $topic->views = 1;
                    $topic->replies = 1;
                    
                    if (input::post('subaction') == 'announce')
                    {
                        $topic->type = 100;
                    }
                    else if (input::post('subaction') == 'attention')
                    {
                        $topic->type = 1;
                    }
                    
                    $topic->active = $active;
                    
                    if (input::post('subaction') == 'close')
                    {
                        $topic->opened = 0;
                    }
                    
                    $topic->save();
                    
                    //zapisz post do bazy
                    $disable_bbcode = (input::post('disablebb') == 1 ) ? 1 : 0;
                    $disable_smilies = (input::post('disablesmileys') == 1 ) ? 1 : 0;
                    $use_links = (input::post('parseurl') == 1) ? 1 : 0;
                    
                    $posting = Jelly::factory('forum_post');
                    $posting->user = Auth::instance()->get_user()->id;
                    $posting->topic = $topic->id;
                    $posting->name = Security::xss_clean(input::post('name'));
                    $posting->content = Security::xss_clean(input::post('content'));
                    $posting->use_bbcode = $use_bbcode;
                    $posting->use_smilies = $use_smilies;
                    $posting->use_links = $use_links;
                    $posting->opened = $active;
                    $posting->save();
                    
                    //dodaj zalaczniki do posta
                    foreach(input::post('attachments') as $a) {
                        $attachment = Jelly::select('attachment', $a);
                        $attachment->obj_id = $posting->id;
                        $attachment->save();
                    }
                    
                    //zaktualizuj temat
                    $topic->post = $posting->id;
                    $topic->post_on = date('Y-m-d H:i:s');
                    $topic->save();
                    
                    //zaktualizuj forum
                    $forum->post = $posting->id;
                    $forum->post_on = date('Y-m-d H:i:s');
                    $forum->save();
                
                    //oznacz jako przeczytane
                    Forum::set_topic_read($topic->id, Auth::instance()->get_user()->id);
                    
                    //forum jest moderowane (konieczna akceptacja tematu) powiadom o nowym temacie
                    if ($forum->moderated == 1)
                    {
                        $moderators = Jelly::select('forum_mod')
                            ->where('forum_id', '=', $forum->id)
                            ->execute();
                            
                        foreach($moderators as $m) {
                            /*
                            $message = View::factory('smarty:site/emails/forum/new_topic_moderate')
                                ->set('created_on', date('Y-m-d H:i:s', time()))
                                ->set('title', $topic->title)
                                ->set('topic_id', $topic->id)
                                ->set('username', Session::instance()->get('auth_user')->firstname.' '.Session::instance()->get('auth_user')->lastname)
                                ->set()
                                ->render();
                        
                            $swift = Email::connect();
                            Email::send($m->user->email, CFG_WEBMASTER_EMAIL, 'Nowy wątek do moderacji na forum', $message, true);
                            */
                        }
                   }
        
        
                    message::good('Wątek został dodany pomyślnie', 'forum/showtopics/'.$this->request->param('id'), 'frontend');
                
                }
                else
                {
                    $errors = $post->errors('frontend/forum/topic/add/form');
                }
            }
            
            $breadcrumbs = Breadcrumbs::getInstance()
                ->addItem(__('Strona główna'), URL::site('/'))
                ->addItem(__('Forum'), URL::site('forum'))
                ->addItem($forum->name, URL::site('forum/showtopics/'.$forum->id))
                ->addItem('Dodaj temat', URL::site('forum/addtopic/'.$forum->id), true)
                ->render();
        }
        else
        {
            message::error('Takie forum nie istnieje', 'forum/showtopics/'.$this->request->param('id'), 'frontend');
        }
    }
    
    public function action_addreply()
    {
        if (! Auth::instance()->logged_in())
        {
			message::error('Musisz być zalogowany aby uzyskać dostęp do tego miejsca', 'profil/zaloguj', 'frontend');
		}
            
        $topic = Jelly::select('forum_topic', $this->request->param('id'));
        if ($topic->loaded())
        {
            if ($topic->forum->course->id AND ! Auth::instance()->get_user()->is_subscribed($topic->forum->course->id))
            {
                message::error('Aby uzyskać dostęp do tego formu musisz być zapisany na szkolenie', 'forum', 'frontend');
            }
            
            $this->template->content = View::factory('site/forum/addreply.tpl')
                ->bind('errors', $errors)
                ->bind('posticons', $posticons)
                ->bind('emoticons', $emoticons)
                ->bind('is_mod', $is_mod)
                ->bind('topic', $topic)
                ->bind('post', $post);
            
            $posticons = Jelly::select('forum_posticon')
                ->filter(array(
                    'active' => 1
                ))
                ->execute();
                
            $emoticons = Jelly::select('forum_emoticon')
                ->filter(array(
                    'active' => 1
                ))
                ->execute()
                ->as_array();
            
            $is_mod = Forum::is_mod($topic->forum->id);
            
            
            if ($topic->forum->locked && !$is_mod)
            {
                message::error('Nie możesz dodawać postów w tym forum gdyż jest ono zamknięte', 'forum/showtopics/'.$topic->forum->id, 'frontend');
            }
            
            if ($topic->opened == 0 && !$is_mod)
            {
                message::error('Nie możesz dodawać postów w tym wątku gdyż jest on zamknięty', 'forum/showtopic/'.$topic->id, 'frontend');
            }
            
            if ($this->request->param('stuff'))
            {
                $post = Jelly::select('forum_post', $this->request->param('stuff'));
            }
            else
            {
                $post = null;
            }
            
            if ($_POST)
            {
                $post = Validate::factory($_POST)
                    ->rule('content', 'not_empty');
                
                if ($post->check())
                {
                    $notification_users = explode(';', $topic->notification);
                    if (!in_array(Session::instance()->get('auth_user')->id, $notification_users))
                    {
                        $notification = (input::post('notification')) ? $topic->notification.';'.Session::instance()->get('auth_user')->id : '';
                    }
                    else
                    {
                        $notification = $topic->notification;
                    }
                    
                    $active = ($forum->moderated == 1) ? 0 : 1;
                    
                    if ($is_mod)
                    {
                        $active = 1;
                    }
                    
                    //zapisz post do bazy
                    $disable_bbcode = (input::post('disablebb') == 1 ) ? 1 : 0;
                    $disable_smilies = (input::post('disablesmileys') == 1 ) ? 1 : 0;
                    $use_links = (input::post('parseurl') == 1) ? 1 : 0;
                    
                    $posting = Jelly::factory('forum_post');
                    $posting->user = Auth::instance()->get_user()->id;
                    $posting->topic = $topic->id;
                    $posting->name = Security::xss_clean(input::post('name'));
                    $posting->content = Security::xss_clean(input::post('content'));
                    $posting->use_bbcode = $use_bbcode;
                    $posting->use_smilies = $use_smilies;
                    $posting->use_links = $use_links;
                    $posting->opened = $active;
                    $posting->save();
                    
                    //dodaj zalaczniki do posta
                    foreach(input::post('attachments') as $a) {
                        $attachment = Jelly::select('attachment', $a);
                        $attachment->obj_id = $posting->id;
                        $attachment->save();
                    }
                    
                    //zaktualizuj temat
                    if (input::post('subaction') == 'announce')
                    {
                        $topic->type = 100;
                    }
                    else if (input::post('subaction') == 'attention')
                    {
                        $topic->type = 1;
                    }
                    
                    if (input::post('subaction') == 'close')
                    {
                        $topic->active = 0;
                    }
                    $topic->post = $posting->id;
                    $topic->post_on = date('Y-m-d H:i:s');
                    $topic->replies = ($topic->replies+1);
                    $topic->notification = $notification;
                    $topic->save();
                    
                    //zaktualizuj forum
                    $topic->forum->post = $posting->id;
                    $topic->forum->post_on = date('Y-m-d H:i:s');
                    $topic->forum->save();
                    
                    //oznacz jako przeczytane
                    Forum::set_topic_read($topic->id, Auth::instance()->get_user()->id);
                    
                    foreach($notification_users as $nu) {
                        $user = Jelly::select('user', $nu);
                        if ($user->loaded())
                        {
                            $replaceData = array();
                            $replaceData['%firstname%'] = $nu->firstname;
                            $replaceData['%lastname%'] = $nu->lastname;
                            $replaceData['%poster_firstname%'] = Auth::instance()->get_user()->firstname;
                            $replaceData['%poster_lastname%'] = Auth::instance()->get_user()->lastname;
                            $replaceData['%topic_name%'] = $topic->name;
                            $replaceData['%topic_url'] = URL::site('forum/showtopic/'.$topic->id, 'http');
                            $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                            xwContentTemplateWrapper::parameter_email(19, $replaceData, $nu->email, CFG_WEBMASTER_EMAIL);
                        }
                    }
                    
                    message::good('Odpowiedź została dodana pomyślnie', 'forum/showtopic/'.$topic->id, 'frontend');
                }
                else
                {
                    $errors = $post->errors('frontend/forum/topic/add/form');
                }
            }
            
            $breadcrumbs = Breadcrumbs::getInstance()
                ->addItem(__('Strona główna'), URL::site('/'))
                ->addItem(__('Forum'), URL::site('forum'))
                ->addItem($topic->forum->name, URL::site('forum/showtopics/'.$topic->forum->id))
                ->addItem('Dodaj odpowiedź', URL::site('forum/addreply/'.$topic->id), true)
                ->render();
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum/showtopics/'.$topic->forum->id, 'frontend');
        }
    }
    
    public function action_info() {
        switch (input::get('what')) {
            case 'posting':
                $this->template->content = View::factory('smarty:site/forum/myposts')
                    ->bind('items', $items)
                    ->bind('pagination', $pagination);
                    
                
                $builder = Jelly::select('forum_post')
                    ->join('forum_topics','LEFT')
                    ->on('forum_topics.id','=','forum_posts.topic_id')
                    ->join('forum_forums', 'LEFT')
                    ->on('forum_forums.id','=',DB::expr('forum_topics.forum_id'))
                    ->where('forum_posts.user_id','=',Session::instance()->get('auth_user')->id)
                    ->where('forum_forums.active','=',DB::expr(1));
                
                $limit = Kohana::config('forum.limit.topics');
                
                $pagination = Pagination::factory();
                $pagination->setup(array(
                    'total_items' => $builder->count(),
                    'items_per_page' => $limit
                ));
                $items = $builder->offset($pagination->offset)->limit($limit)->execute();
            break;
            case 'topicsempty':
                $this->template->content = View::factory('smarty:site/forum/topicsempty')
                    ->bind('items', $items)
                    ->bind('pagination', $pagination);
                    
                
                $builder = Jelly::select('forum_topic')
                    ->join('forum_forums', 'LEFT')
                    ->on('forum_forums.id','=',DB::expr('forum_topics.forum_id'))
                    ->where('replies','<','2')
                    ->where('forum_forums.active','=',DB::expr(1));
                
                $limit = Kohana::config('forum.limit.topics');
                
                $pagination = Pagination::factory();
                $pagination->setup(array(
                    'total_items' => $builder->count(),
                    'items_per_page' => $limit
                ));
                $items = $builder->offset($pagination->offset)->limit($limit)->execute(); 
            break;
            case 'lastposts':
                $this->template->content = View::factory('smarty:site/forum/lastposts')
                    ->bind('posts', $posts);
                
    			$posts = DB::select('forum_posts.*', 'users.firstname', 'users.lastname', array('forum_topics.title', 'topic_title'), array('forum_forums.title', 'forum_title'), array('forum_forums.id', 'forum_id'))->from('forum_posts', 'forum_topics', 'forum_forums', 'users')
                    ->where('forum_topics.id','=',DB::expr('forum_posts.topic_id'))
                    ->where('forum_topics.forum_id','=',DB::expr('forum_forums.id'))
                    ->where('forum_forums.active','=',DB::expr(1))
                    ->where('forum_topics.user_id','=',DB::expr('users.id'))
                    ->order_by('forum_posts.created_on', 'DESC')
                    ->limit(25)
                    ->as_object()
                    ->execute();
            break;
        }
    }
}