<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Forummisc extends Relio_Controller_Website {
    public function before()
    {
        parent::before();
        
        DB::delete('forum_topic_views')
            ->where('expire', '<', time())
            ->execute(); 
           
        View::set_global('in_page', 'forum');     
    }
    
    public function action_changetype()
    {
        $item = Jelly::select('forum_topic', $this->request->param('id'));
        if ($topic->loaded())
        {
            if (Auth::instance()->logged_in())
            {
                $is_mod = Forum::is_mod($item->forum->id);
                
                if ($is_mod)
                {
                    $item->type = $this->request->param('stuff');
                    $item->save();
                    
                    message::good('Typ wątku został zmieniony pomyślnie', 'forum/showtopic/'.$item->id, 'frontend');
                }
                else
                {
                    message::error('Nie możesz zmienić typu wątka', 'forum/showtopic/'.$item->id, 'frontend');
                }
            }
            else
            {
                message::error('Nie możesz zmienić typu wątka', 'forum/showtopic/'.$item->id, 'frontend');
            }
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum', 'frontend');
        }
    }
    
    public function action_deletetopic()
    {
        $topic = Jelly::select('forum_topic', $this->request->param('id'));
        if ($topic->loaded())
        {
            if (Auth::instance()->logged_in())
            {
                $is_mod = Forum::is_mod($topic->forum->id);
                
                if (Auth::instance()->get_user()->id == $topic->user->id || $is_mod)
                {
                    $forum_id = $topic->forum->id;
                    
                    $topic->delete();
                    
                    
                    //ustawienie nowego postu jako ostatnio dodany 
                    $post = Jelly::select('forum_topic')
                        ->where('forum_id', '=', $forum_id)
                        ->order_by('post_on', 'DESC')
                        ->limit(1)
                        ->execute();
                    
                    if ($post->loaded())
                    {
                        DB::update('forum_forums')
                            ->set(array(
                                'post_on' => $post->created_on,
                                'post_id' => $post->id
                            ))
                            ->where('id', '=', $forum_id)
                            ->execute(); 
                    }
                    else
                    {
                        DB::update('forum_forums')
                            ->set(array(
                                'post_on' => NULL,
                                'post_id' => NULL
                            ))
                            ->where('id', '=', $forum_id)
                            ->execute(); 
                       
                    }
                    
                    message::good('Wątek został usunięty pomyślnie', 'forum/showtopics/'.$forum_id, 'frontend');
                }
                else
                {
                    message::error('Musisz być moderatorem tego forum bądź autorem wątka aby go usunąć', 'forum/showtopic/'.$topic->id, 'frontend');
                }
            }
            else {
                message::good('Musisz być zalogowany aby usunąć wątek', 'forum/showtopic/'.$topic->id, 'frontend');
            }
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum', 'frontend');
        }
    }
    
    public function action_deletepost()
    {
        $post = Jelly::select('forum_post', $this->request->param('id'));
        if ($post->loaded())
        {
            if (Auth::instance()->logged_in())
            {
                $is_mod = Forum::is_mod($post->topic->forum->id);
                
                if ($is_mod)
                {
                    $forum_id = $post->topic->forum->id;
                    $topic_id = $post->topic->id;
                    
                    $post->delete();
                    
                    $count = Jelly::select('forum_post')
                        ->where('topic_id', '=', $topic_id)
                        ->count();
                    
                    if($count <= 0)
                    {
                        DB::delete('forum_topics')
                            ->where('id', '=', $topic_id)
                            ->execute();
                    }
                    
                    DB::update('forum_topics')
                        ->set(array(
                            'replies' => 'replies-1'
                        ))
                        ->where('id', '=', $topic_id)
                        ->execute();
                    
                    //ustawienie nowego postu jako ostatnio dodany 
                    $post = Jelly::select('forum_topic')
                        ->where('id', '=', $topic_id)
                        ->order_by('post_on', 'DESC')
                        ->limit(1)
                        ->execute();
                    
                    if ($post->loaded())
                    {
                        DB::update('forum_forums')
                            ->set(array(
                                'post_on' => $post->created_on,
                                'post_id' => $post->id
                            ))
                            ->where('id', '=', $forum_id)
                            ->execute(); 
                    }
                    else
                    {
                        DB::update('forum_forums')
                            ->set(array(
                                'post_on' => NULL,
                                'post_id' => NULL
                            ))
                            ->where('id', '=', $forum_id)
                            ->execute(); 
                       
                    }
                    
                    if ($count <= 0)
                    {
                        message::good('Usuwając tego posta usunięty został także wątek', 'forum/showtopics/'.$forum_id, 'frontend');
                    }
                    else
                    {
                        message::good('Post został usunięty pomyślnie', 'forum/showtopic/'.$topic_id, 'frontend');
                    }
                }
                else
                {
                    message::error('Musisz być moderatorem tego forum aby móc usunąć post', 'forum/showtopic/'.$post->topic->id, 'frontend');
                }
            }
            else
            {
                message::error('Musisz być zalogowany aby usunąć post', 'forum/showtopic/'.$post->topic->id, 'frontend');
            }
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum', 'frontend');
        }
    }
    
    public function action_movetopic()
    {
        $topic = Jelly::select('forum_topic', $this->request->param('id'));
        if ($topic->loaded())
        {
            if (Auth::instance()->logged_in())
            {
                $is_mod = Forum::is_mod($topic->forum->id);
                
                if ($is_mod)
                {
                    $this->template->content = View::factory('site/forum/movetopic.tpl')
                        ->bind('breadcrumbs', $breadcrumbs)
                        ->bind('topic', $topic)
                        ->bind('categories_dropdown', $categories_dropdown);
                    
                    $categories = array();
                    Forum::get_categories(0, $categories, '');
                
                    $categories_dropdown = $categories;
                    
                    if ($_POST)
                    {
                        $forum_id_before = $topic->forum->id;
                        
                        DB::update('forum_topics')
                            ->set(array(
                                'forum_id' => input::post('destination')
                            ))
                            ->where('id', '=', $topic->id)
                            ->execute();
                        
                        //ustawienie nowego postu jako ostatnio dodany 
                        $post = Jelly::select('forum_topic')
                            ->where('forum_id', '=', input::post('destination'))
                            ->order_by('post_on', 'DESC')
                            ->limit(1)
                            ->execute();
                        
                        if ($post->loaded())
                        {
                            DB::update('forum_forums')
                                ->set(array(
                                    'post_on' => $post->created_on,
                                    'post_id' => $post->id
                                ))
                                ->where('id', '=', input::post('destination'))
                                ->execute(); 
                        }
                        
                        //ustawienie nowego postu jako ostatnio dodany 
                        $post = Jelly::select('forum_topic')
                            ->where('forum_id', '=', $forum_id_before)
                            ->order_by('post_on', 'DESC')
                            ->limit(1)
                            ->execute();
                        
                        if ($post->loaded())
                        {
                            DB::update('forum_forums')
                                ->set(array(
                                    'post_on' => $post->created_on,
                                    'post_id' => $post->id
                                ))
                                ->where('id', '=', $forum_id_before)
                                ->execute(); 
                        }
                        
                        message::good('Wątek został przeniesiony pomyślnie', 'forum/showtopic/'.$topic->id, 'frontend');
                    }
                    
                    $breadcrumbs = Breadcrumbs::getInstance()
                        ->addItem(__('Strona główna'), URL::site('/'))
                        ->addItem(__('Forum'), URL::site('forum'))
                        ->addItem($topic->forum->name, URL::site('forum/showtopics/'.$topic->forum->id))
                        ->addItem($topic->name, URL::site('forum/showtopic/'.$topic->id))
                        ->addItem('Przenieś temat', URL::site('forummisc/movetopic/'.$topic->id), true)
                        ->render();
                }
                else
                {
                    message::error('Musisz być moderatorem tego forum aby móc przenieść wątek', 'forum/showtopic/'.$topic->id, 'frontend');
                }
            }
            else
            {
                message::error('Musisz być zalogowany aby przenieść wątek', 'forum/showtopic/'.$topic->id, 'frontend');
            }
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum', 'frontend');
        }
    }
    
    public function action_closetopic()
    {
        $item = Jelly::select('forum_topic', $this->request->param('id'));
        if ($item->loaded())
        {
            if (Auth::instance()->logged_in())
            {
                $is_mod = Forum::is_mod($item->forum->id);
                
                if ($is_mod)
                {
                    $item->opened = 0;
                    $item->save();
                    
                    message::good('Wątek został zamknięty pomyślnie', 'forum/showtopic/'.$item->id, 'frontend');
                }
                else
                {
                    message::error('Musisz być moderatorem tego forum aby móc zamknąć wątek', 'forum/showtopic/'.$item->id, 'frontend');
                }
            }
            else
            {
                message::error('Musisz być zalogowany aby zamknąć wątek', 'forum/showtopic/'.$item->id, 'frontend');
            }
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum', 'frontend');
        }
    }
    
    public function action_opentopic()
    {
        $item = Jelly::select('forum_topic', $this->request->param('id'));
        if ($item->loaded())
        {
            if (Auth::instance()->logged_in())
            {
                $is_mod = Forum::is_mod($item->forum->id);
                
                if ($is_mod)
                {
                    $item->opened = 1;
                    $item->save();
                    
                    message::good('Wątek został otwarty pomyślnie', 'forum/showtopic/'.$item->id, 'frontend');
                }
                else
                {
                    message::error('Musisz być moderatorem tego forum aby móc otworzyć wątek', 'forum/showtopic/'.$item->id, 'frontend');
                }
            }
            else
            {
                message::error('Musisz być zalogowany aby otworzyć wątek', 'forum/showtopic/'.$item->id, 'frontend');
            }
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum', 'frontend');
        }
    }
    
    public function action_addsubscription()
    {
        $item = Jelly::select('forum_topic', $this->request->param('id'));
        if ($item->loaded())
        {
            if (Auth::instance()->logged_in())
            {
                $user_id = explode(';', $item->notification);
                
                if (!in_array(Session::instance()->get('auth_user')->id, $user_id))
                {
                    $notification = $item->notification.';'.Session::instance()->get('auth_user')->id;
                    
                    $item->notification = $notification;
                    $item->save();
                    
                    message::good('Zostałeś pomyślnie dodany od sybskrybcji wątku', 'forum/showtopic/'.$item->id, 'frontend');
                }
                else
                {
                    message::error('Ten wątek jest już subskrybowany przez Ciebie', 'forum/showtopic/'.$item->id, 'frontend');
                }
            }
            else
            {
                message::error('Musisz być zalogowany aby subskrybować wątek', 'forum/showtopic/'.$item->id, 'frontend');
            }
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum', 'frontend');
        }
    }
    
    public function action_unsubscription()
    {
        $item = Jelly::select('forum_topic', $this->request->param('id'));
        if ($item->loaded())
        {
            if (Auth::instance()->logged_in())
            {
                $user_id = explode(';', $item->notification);
                
                if (in_array(Session::instance()->get('auth_user')->id, $user_id))
                {
                    $notification = str_replace(';'.Session::instance()->get('auth_user')->id, '', $item->notification);
                    
                    $item->notification = $notification;
                    $item->save();
                    
                    message::good('Zostałeś usunięty z subskrybcji wątku', 'forum/showtopic/'.$item->id, 'frontend');
                }
                else
                {
                    message::error('Nie subskrybujesz tego wątku', 'forum/showtopic/'.$item->id, 'frontend');
                }
            }
            else
            {
                message::error('Musisz być zalogowany aby usunąć usbskrybcje wątek', 'forum/showtopic/'.$item->id, 'frontend');
            }
        }
        else
        {
            message::error('Taki wątek nie istnieje', 'forum', 'frontend');
        }
    }
    
    public function action_poster()
    {
        $topic = Jelly::select('forum_topic', $this->request->param('id'));
        if ($topic->loaded())
        {
            $template = View::factory('smarty:site/forum/poster')
                ->bind('posters', $posters);
                        
            $posters = DB::select('users.firstname', 'users.lastname', DB::expr('COUNT(forum_posts.user_id) AS count'))->from('users', 'forum_posts')
            ->where('forum_posts.topic_id','=',$topic->id)
            ->where('forum_posts.user_id','=',DB::expr('users.id'))
            ->group_by('users.id')
            ->as_object()
            ->execute();
            
            echo $template->render();
            
            exit;
        }
    }
    
    public function action_markreadboard()
    {
        if (! Auth::instance()->logged_in())
        {
            message::error('Musisz być zalogowany aby oznaczyć forum jako przeczytane', 'forum', 'frontend');
        }
        else
        {
            if (input::get('readall') == '1')
            {
                $items = Jelly::select('forum_topic')
                    ->where('post_on','>', date('Y-m-d', strtotime('-2 weeks')))
                    ->execute();
            }
            else
            {
                $items = Jelly::select('forum_topic')
                    ->where('forum_id', '=', $this->request->param('id'))
                    ->where('post_on', '>', date('Y-m-d', strtotime('-2 weeks')))
                    ->execute();
            }
            
            foreach($items as $it) {
                $read = Jelly::factory('forum_topic_read');
                $read->set(array(
                    'user' => $it->user->id,
                    'topic' => $it->id
                ));
                $read->save();
            }
            
            if (input::get('readall') == '1')
            {
                message::good('Wątki zostały oznaczone jako przeczytane', 'forum', 'frontend');
            }
            else
            {
                message::good('Wątki zostały oznaczone jako przeczytane', 'forum/showtopics/'.$this->request->param('id'), 'frontend');
            }
        }
    }
}