<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Library extends Relio_Controller_Website {
    public function action_index()
    {
        if (! Auth::instance()->logged_in())
        {
			message::error('Musisz być zalogowany aby uzyskać dostęp do tego miejsca', 'user/login', 'frontend');
		}
        
        if (! Auth::instance()->get_user()->is_subscribed($this->request->param('id')))
        {
            message::error('Aby uzyskać dostęp do biblioteki szkolenia musisz być zapisany na szkolenie', 'mycourses', 'frontend');
        }
        
        $course = Jelly::select('course', $this->request->param('id'));
        if (! $course->loaded())
        {
            message::error('Nie znaleziono takiego szkolenia', 'mycourses', 'frontend');
        }    
            
        $item = Jelly::select('course_page', $this->request->param('stuff'));        
        if ($item->loaded())
        {
            $this->template->content = View::factory('site/modules/course/library/read.tpl')
                ->bind('breadcrumbs', $breadcrumbs)
                ->bind('library_submenu', $library_menu)
                ->bind('item', $item)
                ->bind('attachments', $attachments);
            
            $library_menu = Menu::library_menu($this->request->param('id'));
                
            $attachments = Jelly::select('attachment')
                ->filter($item->id, 'course_pages')
                ->order_by('posy','ASC')
                ->execute();
            
            $paths = array();
            foreach ($item->path() as $path) {
                $paths[] = $path->id;
            }
            
            View::bind_global('paths', $paths);
            
            $breadcrumbs = Breadcrumbs::getInstance()
                ->addItem(__('Strona główna'), URL::site('/'))
                ->addItem(__('Szkolenia'), URL::site('mycourses'))
                ->addItem($course->name, URL::site('course/continue/'.$course->id))
                ->addItem(__('Biblioteka szkolenia'), URL::site('library/index/'.$item->scope))
                ->addItem($item->name, URL::site('library/index/'.$item->scope.'/'.$item->id), true)
                ->render();
            
            $this->title = $item->name;
            
        }
        else
        {
            $this->template->content = View::factory('site/modules/course/library/index.tpl')
                ->bind('breadcrumbs', $breadcrumbs)
                ->bind('library_submenu', $library_menu);
            
            $library_menu = Menu::library_menu($this->request->param('id'));
            
            $breadcrumbs = Breadcrumbs::getInstance()
                ->addItem(__('Strona główna'), URL::site('/'))
                ->addItem(__('Szkolenia'), URL::site('mycourses'))
                ->addItem($course->name, URL::site('course/continue/'.$course->id))
                ->addItem(__('Biblioteka szkolenia'), URL::site('library/index/'.$item->scope))
                ->render();
        }
    }
}
