<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Mymessages extends Relio_Controller_Website {
    public function before()
    {
        parent::before();
        
        $count_send_messages = Jelly::select('privatemessage')
            ->where('folderid', '=', 2)
            ->where('userid', '=', Auth::instance()->get_user()->id)
            ->count();
        
        $count_trash_messages = Jelly::select('privatemessage')
            ->where('folderid', '=', 3)
            ->where('userid', '=', Auth::instance()->get_user()->id)
            ->count();
            
        $count_total_messages = Jelly::select('privatemessage')
            ->where('folderid', '=', 1)
            ->where('userid', '=', Auth::instance()->get_user()->id)
            ->count();
    
        View::set_global('count_send_messages', $count_send_messages);
        View::set_global('count_trash_messages', $count_trash_messages);
        View::set_global('count_total_messages', $count_total_messages);
        View::set_global('in_page', 'mymessages');
    }
    
    public function action_index()
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Musisz być zalogowany aby przeglądać wiadomości'), 'user/login', 'frontend');
        }
        
        $this->template->content = View::factory('site/messages/list.tpl')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('folderid', $folderid);
        
        $this->template->title = __('Prywatne wiadomości');
        
        $message = message::get_once('frontend');
            
        switch(input::get('folder')) {
            case '1':
                //wiadomosci odebrane
                $folderid = 1;
            break;
            case '2':
                //wiadomosci wyslane
                $folderid = 2;
            break;
            case '3':
                //wiadomosci w koszu
                $folderid = 3;
            break;
            default:
                //domyslnie wiadomosci odebrane
                $folderid = 1;
            break;
        }
        
        $builder = Jelly::select('privatemessage')
            ->where('folderid', '=', $folderid)
            ->where('userid', '=', Auth::instance()->get_user()->id);
        
        $limit = 10;
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute(); 

        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Moje wiadomości'), URL::site('mymessages'), true)
            ->render();        
    }
    
    public function action_new()
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Musisz być zalogowany aby przeglądać wiadomości'), 'user/login', 'frontend');
        }
        
        $this->template->content = View::factory('smarty:site/messages/new')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('message', $message)
            ->bind('errors', $errors)
            ->bind('items', $items)
            ->bind('user', $user);
        
        $this->template->title = __('Nowa prywatna wiadomość');
        
        if ($this->request->param('id'))
        {
            $user = Jelly::select('user', $this->request->param('id'));
        }
        else
        {
            $user = null;
        }

        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Moje wiadomości'), URL::site('mymessages'))
            ->addItem(__('Nowa wiadomość'), URL::site('mymessages/new'), true)
            ->render(); 
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('title', 'not_empty')
                ->rule('touser_id', 'not_empty')
                ->rule('message', 'not_empty')
                ->rule('message', 'min_length', array(10));;
            
            if ($post->check())
            {
                //najpierw trzeba pobrac ID usera po jego loginie ...
                $touser = Jelly::select('user',input::post('touser_id'));
                if ($touser->loaded())
                {                    
                    Jelly::factory('privatemessage')->send(array(
                        'userid' => $touser->id,
                        'touserid' => $touser->id,
                        'fromuserid' => Auth::instance()->get_user()->id,
                        'title' => Security::xss_clean(input::post('title')),
                        'message' => Security::xss_clean(input::post('message'))
                    ), array(
                        'userid' => Auth::instance()->get_user()->id,
                        'touserid' => $touser->id,
                        'fromuserid' => Auth::instance()->get_user()->id,
                        'title' => Security::xss_clean(input::post('title')),
                        'message' => Security::xss_clean(input::post('message'))
                    ));
					
					//wyslij powiadomienie na maila do odbiorcy ze jest nowa wiadomosc
                    $replaceData = array();
                    $replaceData['%sender_firstname%'] = Auth::instance()->get_user()->firstname;
                    $replaceData['%sender_lastname%'] = Auth::instance()->get_user()->lastname;
                    $replaceData['%recive_firstname%'] = $touser->firstname;
                    $replaceData['%recive_lastname%'] = $touser->lastname;
                    $replaceData['%title%'] = Security::xss_clean(input::post('title'));
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                    
                    xwContentTemplateWrapper::parameter_email(7, $replaceData, $touser->email, CFG_WEBMASTER_EMAIL);
			
                    message::good(__('Wiadomość została wysłana pomyślnie'), 'mymessages', 'frontend');
                }
                else
                {
                    Validate::factory(array('touser'))->error('touser', __('Taki użytkownik nie istnieje'));
                }
            }
            else
            {
                $errors = $post->errors('frontend/mymessages/form');
            }
        }
    }
    
    public function action_boxy()
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Musisz być zalogowany aby przeglądać wiadomości'), 'user/login', 'frontend');
        }
        
        $content = View::factory('site/messages/boxy.tpl')
            ->bind('message', $message)
            ->bind('errors', $errors)
            ->bind('items', $items)
            ->bind('user', $user);
       
        $message = message::get_once('frontend');
        
        if ($this->request->param('id'))
        {
            $user = Jelly::select('user', $this->request->param('id'));
        }
        else
        {
            $user = null;
        }
        
        if ($_POST)
        {
            $post = Validate::factory($_POST);
            $post->rule('title', 'not_empty');
            $post->rule('touser_id', 'not_empty');
            $post->rule('message', 'not_empty');
            $post->rule('message', 'min_length', array(10));;
            
            if ($post->check())
            {
                //najpierw trzeba pobrac ID usera po jego loginie ...
                $touser = Jelly::select('user',input::post('touser_id'));
                if ($touser->loaded())
                {
                    Jelly::factory('privatemessage')->send(array(
                        'userid' => $touser->id,
                        'touserid' => $touser->id,
                        'fromuserid' => Auth::instance()->get_user()->id,
                        'title' => Security::xss_clean(input::post('title')),
                        'message' => Security::xss_clean(input::post('message'))
                    ), array(
                        'userid' => Auth::instance()->get_user()->id,
                        'touserid' => $touser->id,
                        'fromuserid' => Auth::instance()->get_user()->id,
                        'title' => Security::xss_clean(input::post('title')),
                        'message' => Security::xss_clean(input::post('message'))
                    ));
                    
					//wyslij powiadomienie na maila do odbiorcy ze jest nowa wiadomosc
                    $replaceData = array();
                    $replaceData['%sender_firstname%'] = Auth::instance()->get_user()->firstname;
                    $replaceData['%sender_lastname%'] = Auth::instance()->get_user()->lastname;
                    $replaceData['%recive_firstname%'] = $touser->firstname;
                    $replaceData['%recive_lastname%'] = $touser->lastname;
                    $replaceData['%title%'] = Security::xss_clean(input::post('title'));
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                    
                    xwContentTemplateWrapper::parameter_email(7, $replaceData, $touser->email, CFG_WEBMASTER_EMAIL);
			
                    message::good(__('Wiadomość została wysłana pomyślnie'), 'mymessages/boxy/'.$this->request->param('id'), 'frontend', true);
                }
                else
                {
                    Validate::factory(array('touser'))->error('touser', __('Taki użytkownik nie istnieje'));
                }
            }
            else
            {
                $errors = $post->errors('frontend/mymessages/form');
            }
        }
        
        echo $content->render();
        exit;
    }
    
    public function action_read()
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Musisz być zalogowany aby przeglądać wiadomości'), 'user/login', 'frontend');
        }
        
        $this->template->content = View::factory('smarty:site/messages/read')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('errors', $errors)
            ->bind('message', $message);
        
        $this->template->title = __('Prywatne wiadomości');

        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Moje wiadomości'), URL::site('mymessages'))
            ->addItem(__('Przeczytaj wiadomość'), URL::site('mymessages/read/'.$this->request->param('id')), true)
            ->render(); 
        
        $message = Jelly::select('privatemessage')
            ->where('id', '=', $this->request->param('id'))
            ->where('userid', '=', Auth::instance()->get_user()->id)
            ->limit(1)
            ->execute();
            
        if ($message->loaded())
        {
            if ($message->read == 0)
            {
                $message->read = 1;
                $message->read_on = date('Y-m-d H:i:s', time());
                $message->save();
            }
            
            if ($_POST)
            {
                $post = Validate::factory($_POST)
                    ->rule('message', 'not_empty')
                    ->rule('message', 'min_length', array(10));
            
                if ($post->check())
                {
                    if ($message->touserid->id == Auth::instance()->get_user()->id)
                    {
                        $touser = $message->fromuserid->id;
                    }
                    else
                    {
                        $touser = $message->touserid->id;
                    }
                    
                    Jelly::factory('privatemessage')->send(array(
                        'userid' => $touser,
                        'touserid' => $touser,
                        'fromuserid' => Auth::instance()->get_user()->id,
                        'title' => 'Re: '.$message->title,
                        'message' => Security::xss_clean(input::post('message'))
                    ), array(
                        'userid' => Auth::instance()->get_user()->id,
                        'touserid' => $touser,
                        'fromuserid' => Auth::instance()->get_user()->id,
                        'title' => 'Re: '.$message->title,
                        'message' => Security::xss_clean(input::post('message'))
                    ));
					
					//wyslij powiadomienie na maila do odbiorcy ze jest nowa wiadomosc
					$touserobj = Jelly::select('user', $touser);
                    
                    $replaceData = array();
                    $replaceData['%sender_firstname%'] = Auth::instance()->get_user()->firstname;
                    $replaceData['%sender_lastname%'] = Auth::instance()->get_user()->lastname;
                    $replaceData['%recive_firstname%'] = $touserobj->firstname;
                    $replaceData['%recive_lastname%'] = $touserobj->lastname;
                    $replaceData['%title%'] = Security::xss_clean(input::post('title'));
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                    
                    xwContentTemplateWrapper::parameter_email(7, $replaceData, $touserobj->email, CFG_WEBMASTER_EMAIL);
                                        
                    message::good(__('Wiadomość została wysłana pomyślnie'), 'mymessages', 'frontend');
                }
                else
                {
                    $errors = $post->errors('frontend/mymessages/form');
                }
            }
        }
        else
        {
            message::error(__('Nie możesz przeczytać tej wiadomości'), 'mymessages', 'frontend');
        }
    }
    
    public function action_trash()
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Musisz być zalogowany aby przeglądać wiadomości'), 'user/login', 'frontend');
        }
        
        $item = Jelly::select('privatemessage')
            ->where('id', '=', $this->request->param('id'))
            ->where('userid', '=', Auth::instance()->get_user()->id)
            ->limit(1)
            ->execute();
            
        if ($item->loaded())
        {
            $item->folderid = 3;
            $item->save();
            
            message::good(__('Wiadomość została pomyślnie przeniesiona do kosza'), 'mymessages'.URL::query(), 'frontend');
        }
        else
        {
            message::error(__('Nie można przenieść wiadomości do kosza'), 'mymessages'.URL::query(), 'frontend');
        }
    }
    
    public function action_delete()
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Musisz być zalogowany aby przeglądać wiadomości'), 'user/login', 'frontend');
        }
        
        $item = Jelly::select('privatemessage')
            ->where('id', '=', $this->request->param('id'))
            ->where('userid', '=', Auth::instance()->get_user()->id)
            ->limit(1)
            ->execute();
            
        if ($item->loaded())
        {
            $item->delete();
            
            message::good(__('Wiadomość została usunięta pomyślnie'), 'mymessages'.URL::query(), 'frontend');
        }
        else
        {
            message::error(__('Nie można usunąć wiadomości'), 'mymessages'.URL::query(), 'frontend');
        }
    }
}
