<?php defined('SYSPATH') or die('No direct script access.');

/**
 * Raporty wysyłane do użytkowników
 *
 * @author Michal Mlodzinski <mm@etendard.pl>
 */
class Minion_Task_Report_Notstart extends Minion_Task {
    /**
     * An array of config options that this task can accept
     */
    protected $_config = array(
		'limit',
		'offset',
        'test'
	);
    
    /**
     * Execute
     */
    public function execute(array $config)
    {
        $is_test = (isset($config['test'])) ? TRUE : FALSE;
		
        if (isset($config['limit']) && isset($config['offset']))
		{
			$this->send_message($config['limit'], $config['offset'], $is_test);
		}
		else
		{
            $size = 500;
            $total_limit = Jelly::select('course_user')
    			->with('course')
                ->where('active', '=', '1')
                ->where_open()
                ->where('last_on', '=', NULL)
                ->or_where('last_on', '=', '')
                ->or_where('last_on', '=', '0000-00-00 00:00:00')
                ->where_close()
                ->where('_course:course.publish_on', '<', date('Y-m-d'))
    			->where('_course:course.archive_on', '>=', date('Y-m-d'))
                ->where('_course:course.notify_notstart', '=', '1')
                ->count();
            
            echo Minion_CLI::write('Znaleziono '.$total_limit.' uzytkownikow', 'yellow');
    
            for ($i = 0;$i < $total_limit; $i += $size) {
                $pid = pcntl_fork();
                if ($pid)
                {
                    pcntl_waitpid($pid, $status);
                }
                else
                {
                    echo Minion_CLI::write('Rozpoczynam przetwarzanie '.$i.', '.$size, 'yellow');
                    
                    $this->send_message($size, $i, $is_test);
                    
                    posix_kill(getmypid(), 9);
                }
            }
        }
    }
    
    private function send_message($limit, $offset, $is_test)
    {
        $items = Jelly::select('course_user')
            ->where('active', '=', '1')
			->with('course')
            ->where_open()
            ->where('last_on', '=', NULL)
            ->or_where('last_on', '=', '')
            ->or_where('last_on', '=', '0000-00-00 00:00:00')
            ->where_close()
            ->where('_course:course.publish_on', '<', date('Y-m-d'))
			->where('_course:course.archive_on', '>=', date('Y-m-d'))
            ->where('_course:course.notify_notstart', '=', '1')
            ->limit($limit)
            ->offset($offset)
            ->execute();
   
        foreach($items as $it) {            
            $datediff = Date::datediff(time(), date('Y-m-d', strtotime($it->course->archive_on)));
					
            $replaceData = array();
            $replaceData['%firstname%'] = $it->user->firstname;
            $replaceData['%lastname%'] = $it->user->lastname;
            $replaceData['%course%'] = $it->course->name;
            $replaceData['%publish_on%'] = date('Y-m-d', strtotime($it->course->publish_on));
            $replaceData['%archive_on%'] = date('Y-m-d', strtotime($it->course->archive_on));
            $replaceData['%days_to_end%'] = $datediff['days'].' dni '.$datediff['hours'].' godzin '.$datediff['minutes'].' minut';
            $replaceData['%day%'] = date('d', strtotime($it->signed_on));
            $replaceData['%month%'] = date('m', strtotime($it->signed_on));
            $replaceData['%year%'] = date('Y', strtotime($it->signed_on));
            $replaceData['%hour%'] = date('H', strtotime($it->signed_on));
            $replaceData['%minute%'] = date('i', strtotime($it->signed_on));
            $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
            
			echo Minion_CLI::write('Wysylam do: '.$it->user->email, 'yellow');
			
            if ( ! $is_test)
            {	
                if (Validate::email(trim($it->user->email)))
                {
                    xwContentTemplateWrapper::parameter_email(17, $replaceData, trim($it->user->email), CFG_WEBMASTER_EMAIL);                    
                    xwContentTemplateWrapper::parameter_privatemessage(17, $replaceData, $it->user->id);
                }
                else {			
                    echo Minion_CLI::write('Bledny e-mail: '.trim($it->user->email), 'yellow');
                }
            }
        }
    }
}