<?php defined('SYSPATH') or die('No direct script access.');

class Model_Circle extends Jelly_Model {
	public static function initialize(Jelly_Meta $meta)
    {
	   $meta->fields(array(
			'id' => Jelly::field('primary'),
            'name' => Jelly::field('string'),
            'symbol' => Jelly::field('string'),
            'updated_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => TRUE,
                'auto_now_update' => TRUE
            )),
            'created_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => TRUE,
                'auto_now_update' => FALSE
            )),
            'student' => Jelly::field('manytomany', array(
                'foreign' => 'user',
                'through' => array(
                    'model'   => 'circle_user',
                    'columns' => array('circle_id', 'user_id'),
                )
            )),
            'teacher' => Jelly::field('manytomany', array(
                'foreign' => 'user',
                'through' => array(
                    'model'   => 'circle_teacher',
                    'columns' => array('circle_id', 'user_id'),
                )
            )),
            'lesson' => Jelly::field('hasmany', array(
                'foreign' => 'circle_lesson'
            ))
		));
	}
}