<?php

class Model_Course_Page extends Jelly_Model_MPTT {
	public $arguments = array();
    public $breadcrumbs = array();
    
    public static function initialize(Jelly_Meta $meta)
    {
		$meta->sorting(array('lft' => 'ASC'))
            ->fields = array(
			'id' => Jelly::field('primary'),
			'parent_id' => Jelly::field('integer'),
            'name' => Jelly::field('string'),
            'content' => Jelly::field('text'),
            'slug' => Jelly::field('string')
		);
        
        parent::initialize($meta);
	}
    
    public function mod_url($slug)
    {
        $original_slug = $slug;
        
        $iCounter = 0;
        
        while (true) {
            $check_page = Jelly::select('course_page')
                ->where('slug', '=', $slug)
                ->execute();
                
            if ($check_page->count())
            {
                $iCounter++ ;
                
                $slug = $original_slug.'-'.$iCounter;
            }
            else
            {
                break;
            }
        }
        
        return $slug;
    }
    
    public function move_up()
    {
        $above = Jelly::select('course_page')
            ->where('scope', '=', $this->scope)
            ->where('lvl', '=', $this->lvl)
            ->where('rgt', '=' ,$this->lft - 1)
            ->limit(1)
            ->execute();
                
        $this->move_to_prev_sibling($above->id);
    }
    
    public function move_down()
    {
        $below = Jelly::select('course_page')
            ->where('scope', '=', $this->scope)
            ->where('lvl', '=', $this->lvl)
            ->where('lft', '=', $this->rgt + 1)
            ->limit(1)
            ->execute();
        
        $this->move_to_next_sibling($below->id);
    }
    
    public function permalink($permalink, $root)
    {
        $current_page = Jelly::factory('course_page');
        
        if (empty($permalink))
        {
            $current_page = $current_page->root($root);
        }
        else
        {
            $segments = explode('/', $permalink);
            $children = Jelly::factory('page')->root($root)->children();
            
            for ($i = 0; $i < count($segments); $i++) {
                foreach ($children as $child) {
                    if ($child->content->slug === $segments[$i]) {
                        $current_page = $child;
                        
                        if ($child->has_children()) {
                            $children = $child->children();
                            
                            continue 2;
                        }
                        else {
                            break 2;
                        }
                    }
                }
            }
            
            // if we've found a page, how many arguments are left?
            if (count($segments) > $current_page->lvl)
            {
                $current_page->arguments = array_slice($segments, -(count($segments)-$current_page->lvl));
            }
        }
        
        return $current_page;
    }
        
    public function uri()
    {
        $uri = array();
    
        foreach ($this->parents() as $parent) {
            if ($parent->lvl > 0)
            {
                $uri[] = urlencode($parent->content->slug);
            }
        }
        
        if ($this->lvl > 0)
        {
            $uri[] = urlencode($this->content->slug);
        }
        
        return empty($uri) ? '/' : implode('/', $uri);
    }
}