<?php

class Model_Modules_Article extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->sorting(array('posy' => 'ASC'))
        ->fields(array(
    		'id' => Jelly::field('primary'),
            'name' => Jelly::field('string'),
            'content_short' => Jelly::field('text'),
            'content' => Jelly::field('text'),
            'slug' => Jelly::field('string'),
            'icon' => Jelly::field('string'),
            'created_on' => Jelly::field('string', array(
                'default' => date('Y-m-d H:i:s', time())
            )),
            'posy' => Jelly::field('integer', array(
                'default' => 1
            )),
            'home' => Jelly::field('integer', array(
                'default' => 0 
            )),
            'active' => Jelly::field('integer', array(
                'default' => 1
            )),
            'page' => Jelly::field('belongsto'),
        ));
    }
    
    public function uri() {
        if (($uri = Cache::instance()->get('articles_uri_'.$this->id)) === NULL) {
            $page = Jelly::select('page', $this->page->id);
            
            $uri = URL::site('pages/'.$page->uri().'/'.$this->slug);
            
            Cache::instance()->set('articles_uri_'.$this->id, $uri, 3600, array('articles_uris'));
        }
        
        return $uri;
    }
    
    public function mod_url($slug) {
        $original_slug = $slug;
        
        $iCounter = 0;
        
        while ( true ) {
            $check_page = Jelly::select('modules_article')->where('slug','=',$slug);
            if ($check_page->count()) {
                $iCounter++ ;
                
                $slug = $original_slug.'-'.$iCounter;
            }
            else {
                break;
            }
        }
        
        return $slug;
    }
    
    public function preparePosy($category) {
        DB::update('modules_articles')->set(array('posy'=>DB::expr('posy+1')))->where('page_id','=',$category)->where('id','>',0)->execute();
    }
    
    public function positionUp($column, $op, $value) {
        $row2 = DB::select()->from('modules_articles')
            ->where('posy', '<', $this->posy)
            ->where($column, $op, $value)
            ->order_by('posy', 'DESC')
            ->limit(1)
            ->offset(0)
            ->execute()->as_array();
               
        if ($row2[0]['id']) {
            DB::update('modules_articles')->set(array('posy'=>$row2[0]['posy']))->where('id','=',$this->id)->execute();
            DB::update('modules_articles')->set(array('posy'=>$this->posy))->where('id','=',$row2[0]['id'])->execute();
        }
    }
    
    public function positionDown($column, $op, $value) {
        $row2 = DB::select()->from('modules_articles')
            ->where('posy', '>', $this->posy)
            ->where($column, $op, $value)
            ->order_by('posy', 'ASC')
            ->limit(1)
            ->offset(0)
            ->execute()->as_array();
                
        if ($row2[0]['id']) {
            DB::update('modules_articles')->set(array('posy'=>$row2[0]['posy']))->where('id','=',$this->id)->execute();
            DB::update('modules_articles')->set(array('posy'=>$this->posy))->where('id','=',$row2[0]['id'])->execute();
        }
    }
}