<?php defined('SYSPATH') or die('No direct script access.');

class Model_Privatemessage extends Jelly_Model {
    
	public static function initialize(Jelly_Meta $meta) {
	   $meta->sorting(array('created_on' => 'DESC'))
       ->fields(array(
			'id' => Jelly::field('primary'),
			'folderid' => Jelly::field('integer'),
            'title' => Jelly::field('string'),
            'message' => Jelly::field('text'),
            'created_on' => Jelly::field('string', array(
                'default' => date('Y-m-d H:i:s', time())
            )),
            'read' => Jelly::field('integer', array(
                'default' => 0
            )),
            'read_on' => Jelly::field('string'),
            'userid' => Jelly::field('belongsto', array(
                'foreign' => 'user',
                'column' => 'userid'
            )),
            'touserid' => Jelly::field('belongsto', array(
                'foreign' => 'user',
                'column' => 'touserid'
            )),
            'fromuserid' => Jelly::field('belongsto', array(
                'foreign' => 'user',
                'column' => 'fromuserid'
            ))
		));
	}
    
    public function send($recive, $sender) {
        //wstaw nowa wiadomosc
        $inbox = Jelly::factory('privatemessage');
        $inbox->set(array(
            'folderid'   => 1,
            'userid'     => $recive['userid'],
            'touserid'   => $recive['touserid'],
            'fromuserid' => $recive['fromuserid'],
            'title'      => $recive['title'],
            'message'    => $recive['message']
        ));
        $inbox->save();

        //wstaw wiadomosc w wyslanych
        $outbox = Jelly::factory('privatemessage');
        $outbox->set(array(
            'folderid'   => 2,
            'userid'     => $sender['userid'],
            'touserid'   => $sender['touserid'],
            'fromuserid' => $sender['fromuserid'],
            'title'      => $sender['title'],
            'message'    => $sender['message']
        ));
        $outbox->save();
    }
}