<?php defined('SYSPATH') or die('No direct access allowed.');

abstract class Relio_Controller_Website extends Controller_Template {
    
    /**
     * @var  string  page template
     */
    public $template = 'smarty:site/layout_default';
    
    /**
	 * @var  string  page content
	 */
	public $title = CFG_META_TITLE;
    
    public $keywords = CFG_META_KEYS;
    
    public $description = CFG_META_DESC;
    
    /**
     * @var  string  page content
     */
    public $content;
    
    /**
     * @var  boolean  auto render template
     **/
    public $auto_render = TRUE;
    
    public $auth;
    
    public function before() {
        i18n::$lang = 'pl-pl';
        
        if (Request::$is_ajax OR $this->request !== Request::instance()) {
            $this->auto_render = FALSE;
		}
        
        if ($this->auto_render === TRUE) {
			$this->template = View::factory($this->template);
		}

        $this->auth = Auth::instance();
        if ($this->auth->logged_in())
        {
            $is_logged = true;
            if (Session::instance()->get('auth_user')->id)
            {
                $total_user_courses = Jelly::select('user', Auth::instance()->get_user()->id)->count_subscribes();
                
                $unread_messages = Jelly::select('privatemessage')->where('folderid', '=', 1 )->where('userid',' =', Auth::instance()->get_user()->id)->where('read', '=', 0)->count();
            }
        }

        $slides = Jelly::select('slider')
            ->where('active', '=', '1')
            ->execute();
		        
        View::bind_global('total_user_courses', $total_user_courses);
        View::bind_global('controller', $this->request->controller);
        View::bind_global('title', $this->title);
        View::bind_global('keywords', $this->keywords);
        View::bind_global('description', $this->description);
        View::bind_global('content', $this->content);
        View::bind_global('is_logged', $is_logged);
        View::bind_global('unread_messages', $unread_messages);
        View::bind_global('slides', $slides);

        View::set_global('session_impersonator', Session::instance()->get('impersonator'));
        View::set_global('session', Session::instance()->get('auth_user'));
        View::set_global('auth', Auth::instance());
        View::set_global('submenu', Menu::main());
        View::set_global('top_menu', Menu::top_menu());
        View::set_global('languages', Kohana::config('devilcms.defaults.languages'));
        View::set_global('current_lang', Request::instance()->param('lang'));
    }
    
    /**
     * Assigns the template as the request response.
     * 
     * @param   string   request method
     * @return  void
     */
    public function after()
    {
        if ($this->auto_render === TRUE)
        {
			$this->request->response = $this->template;
            
            //echo DebugToolbar::render(true);
		}
		else
        {
			$this->request->response = $this->content;
		}

        /*
        $groups = Profiler::groups();
        echo count($groups['database ('.Database::instance().')']);
        echo View::factory('profiler/stats');
        */
    }
}
