<?php defined('SYSPATH') or die('No direct script access.');

class Relio_Forum {
    public static function is_mod($forum_id) {
        $mods = array();
        $items = Jelly::select('forum_mod')->where('forum_id','=',$forum_id);
        foreach ($items as $it) {
            $mods[] = $it->user->id;
        }
        
        if (Auth::instance()->logged_in()) {
            $user_id = Session::instance()->get('auth_user')->id;
        }
        else {
            $user_id = 0;
        } 
        
        $user_is_mod = (@in_array($user_id, $mods)) ? 1 : 0;
        
        $is_admin = Auth::instance()->logged_in('admin');
        
        if (($is_admin) || ($user_is_mod == 1)) {
            return true;
        }
        else {
            return false;
        }
    }
    
    public static function is_mod_exclude_admin($forum_id) {
        $mods = array();
        $items = Jelly::select('forum_mod')->where('forum_id','=',$forum_id);
        foreach ($items as $it) {
            $mods[] = $it->user->id;
        }
        
        if (Auth::instance()->logged_in()) {
            $user_id = Session::instance()->get('auth_user')->id;
        }
        else {
            $user_id = 0;
        } 
        
        $user_is_mod = (@in_array($user_id, $mods)) ? 1 : 0;
        
        if ($user_is_mod == 1) {
            return true;
        }
        else {
            return false;
        }
    }
    
    public static function set_topic_icon($topic, $forum, $replies = 0) {
        $HOT_VIEW_COUNT = 250;
        $HOT_REPLY_COUNT = 20; 
        
        if (Auth::instance()->logged_in()) {
            $user_id = Session::instance()->get('auth_user')->id;
        }
        else {
            $user_id = 0;
        }
        
        $posted_in_thread = DB::select(DB::expr('COUNT(*) AS PostedInThread'))
            ->from('forum_posts')
            ->where('topic_id', '=', $topic->id)
            ->where('user_id', '=', $user_id)
            ->execute()
            ->get('PostedInThread');
              
        $count = DB::select(DB::expr('COUNT(*) AS NewPostCount'))
            ->from('forum_topics')
            ->join('forum_topic_reads', 'LEFT')
            ->on('forum_topics.id','=','forum_topic_reads.topic_id')
            ->on('forum_topic_reads.user_id','=',DB::expr($user_id))
            ->where('forum_topics.id','=',$topic->id)
            ->where_open()
            ->where('forum_topic_reads.read_on','<',DB::expr('forum_topics.post_on'))
            //->or_where('forum_topic_reads.read_on','is_null')
            ->where_close()
            ->where('forum_topics.post_on','>',date('Y-m-d', strtotime('-2 weeks')))
            ->execute()
            ->get('NewPostCount');
        
        // nowe posty czy nie
        $new = false; 
        $file = "thread"; 
        
        // user pisal odpowiedz w tym temacie ?
        if ($posted_in_thread > 0) {
            $file .= "_dot"; 
        }
        
        // goracy temat ?
        if (@$replies > $HOT_REPLY_COUNT || $topic->views > $HOT_VIEW_COUNT) {
            $file .= "_hot"; 
        }
        
        // zamkniete ?
        if (@$topic->opened == 0 || @$forum->locked)
        {
            $file .= "_lock"; 
        }
        
        // nowy temat
        if ($count > 0)
        {
            $file .= "_new";
            $new = true;
        } 
        
        $file .= ".png";
        
        switch ($topic->type) {
            case 100:
                $statusicon = ($new) ? Forum::get_icon('announcement_new.png', 'Ogłoszenie - nowe posty') : Forum::get_icon('announcement_old.png', 'Ogłoszenie - brak nowych postów');
            break;
            case 1:
                $statusicon = ($new) ? Forum::get_icon('important_new.png', 'Ważna wiadomość - nowe posty') : Forum::get_icon('important_old.png', 'Ważna wiadomość - brak nowych postów');
            break;
            default:
                $statusicon = Forum::get_icon($file, '-');
            break;
        }
        
        return $statusicon; 
    }
    
    public static function get_categories($id, &$categories, $prefix)
    {
        $items = Jelly::select('forum_category')
            ->where('active', '=', 1)
            ->execute();
        
        $dropdown = array();
        
        foreach ($items as $it) {
            $forums = $it->get('forums')->where('active', '=', 1)->execute();
            
            $forum_dropdown = array();
            foreach($forums as $f) {
                $forum_dropdown[$f->category->id][] = array(
                    'id' => $f->id,
                    'name' => $f->name
                );
            }
            
            $dropdown[] = array(
                'id'     => $it->id,
                'name'   => $it->name,
                'forums' => isset($forum_dropdown[$it->id]) ? $forum_dropdown[$it->id] : array()
            );
        }
        
        
        $categories = $dropdown;
    } 
    
    public static function set_topic_read($topic_id, $user_id) {
        $item = Jelly::factory('forum_topic_read');
        $item->set(array(
            'user' => $user_id,
            'topic' => $topic_id
        ));
        $item->save();
    }
    
    public static function get_page_num($repliesCount, $limit) {
        $limit = (!$limit) ? 15 : $limit;
        if (($repliesCount % $limit) == 0) {
            return $repliesCount / $limit;
        }
        
        return ($repliesCount + ($limit - ($repliesCount % $limit))) / $limit;
    }
    
    public static function initial_message_parse($content) {
        $content = preg_replace('/<img(.*?)>/', '<span class="content_colorbox"><img class="bbc_img" $1></span>', $content);
        
        return $content;
    }
    
    public static function emoticons($text) {
        $items = Jelly::select('forum_emoticon')->where('active','=',DB::expr('1'))->execute();
		foreach($items as $it) {
			$text = @str_replace($it->code,'<img src="'.$it->icon.'" border="0" alt="" style="display: inline;" class="absmiddle" />',$text);
		}
        
        return $text;
    }
    
    public static function badword($text) {  
        $bad_words = @file('application/vendor/cenzura.txt');
        $rop = '*';  
        foreach ($bad_words as $badWord) {
            $replace = '';
            
            $badWord = trim($badWord);
            for ($j=1;$j<strlen($badWord);$j++) {
                $replace .= $rop;
            }
            
            $niceWord = substr_replace($badWord, $replace, 1);	
            $text = str_replace($badWord, $niceWord, $text);
        }
        return $text;  
    }
    
    public static function get_icon($file, $alt) {
        return "<img src=\"public/design/frontend/images/forum/$file\" alt=\"$alt\" title=\"$alt\"/>";
    }
}