<?php defined('SYSPATH') or die('No direct script access.');

class URL extends Kohana_URL
{
    /**
     * Fetches an absolute site URL based on a URI segment.
     *
     * @param   string  site URI to convert
     * @param   string  non-default protocol
     * @return  string
     */
    public static function site($uri = '', $protocol = false)
    {
        // Get the path from the URI
        $path = trim(parse_url($uri, PHP_URL_PATH), '/');

        //check if lang is already there
        $lang = '';
        //if (!preg_match('~^[a-z]{2,3}(?=/|$)~i', $path)) {
        //    $lang = Request::instance()->param('lang') . '/';
        //}

        if ($query = parse_url($uri, PHP_URL_QUERY)) {
            // ?query=string
            $query = '?' . $query;
        }

        if ($fragment = parse_url($uri, PHP_URL_FRAGMENT)) {
            // #fragment
            $fragment = '#' . $fragment;
        }

        // Concat the URL
        return URL::base(true, $protocol) . $lang . $path . $query . $fragment;
    }

    /**
     * Fetches an absolute site URL based on a URI segment and supplied language.
     *
     * @param   string  language code to use. eg en/fr/es etc
     * @param   string  site URI to convert
     * @param   string  non-default protocol
     * @return  string
     */
    public static function site_lang($lang, $uri = '', $protocol = false)
    {
        if ($path = trim(parse_url($uri, PHP_URL_PATH), '/')) {
            // Add path suffix
            $path .= Kohana::config('core.url_suffix');
        }

        if ($query = parse_url($uri, PHP_URL_QUERY)) {
            // ?query=string
            $query = '?' . $query;
        }

        if ($fragment = parse_url($uri, PHP_URL_FRAGMENT)) {
            // #fragment
            $fragment = '#' . $fragment;
        }

        // Concat the URL
        return URL::base(true, $protocol) . $path . $query . $fragment;
    }

    public static function current_site($uri = '')
    {
        $current = Request::instance()->uri();
        
        $path = trim(parse_url($current, PHP_URL_PATH), '/');

        if (preg_match('~^[a-z]{2,3}(?=/|$)~i', $path)) {
            $current = preg_replace('~^[a-z]{2,3}(?=/|$)~i', '', $current);
            
        }
        
        
        return empty($uri) ? $current : $current . '/' . $uri;
    }
    
    public static function current_site_lang($uri = '')
    {
        $current = Request::instance()->uri();
        
        return empty($uri) ? $current : $current . '/' . $uri;
    }

    /**
     * Formats a URL to contain a protocol at the beginning.
     *
     * @param   string  possibly incomplete URL
     * @return  string
     */
    public static function format($str = '')
    {
        // Clear protocol-only strings like "http://"
        if ($str === '' or substr($str, -3) === '://')
        {
            return '';
        }

        // If no protocol given, prepend "http://" by default
        if (strpos($str, '://') === false)
        {
            return 'http://' . $str;
        }
        
        // Return the original URL
        return $str;
    }


    /**
     * Convert a phrase to a URL-safe title.
     *
     * @param   string   phrase to convert
     * @param   string   word separator (any single character)
     * @param   boolean  transliterate to ASCII
     * @return  string
     */
    public static function prepare_url($title, $separator = '-', $ascii_only = false)
    {        
        if ($ascii_only === true)
        {
            // Transliterate non-ASCII characters
            $title = UTF8::transliterate_to_ascii($title);

            // Remove all characters that are not the separator, a-z, 0-9, or whitespace
            $title = preg_replace('![^' . preg_quote($separator) . 'a-z0-9\s]+!', '', strtolower($title));
        }
        else
        {
            // Remove all characters that are not the separator, letters, numbers, or whitespace
            $title = preg_replace('![^' . preg_quote($separator) . '\pL\pN\s]+!u', '', UTF8::strtolower($title));
        }

        // Replace all separator characters and whitespace by a single separator
        $title = preg_replace('![' . preg_quote($separator) . '\s]+!u', $separator, $title);

        $search = array(' ', '/', '\'', '&', '%', 'ć', 'ś', 'ą', 'ż', 'ó', 'ł', 'ś', 'ź', 'ń', 'ę');
        $replace = array('_', '-', '-', 'and', 'procent', 'c', 's', 'a', 'z', 'o', 'l', 's', 'z', 'n', 'e');

        $title = str_replace($search, $replace, $title);

        // Trim separators from the beginning and end
        return trim($title, $separator);
    }
    
    public static function convert_fck($text)
    {
        $server = URL::base(false, 'http');
        $attributes = array('src');
        
        foreach ($attributes as $attr) {
            $pattern[] = '/'.$attr.'=["'."'".']??(.*)["'."'".']??([ >])/Uis';
            $replacement[] = $attr.'="'.$server.'\1"\2';
        }
        
        $text = preg_replace('<--.*-->', '', $text); 
        $text = str_replace('', '"', $text);
        $text = str_replace('\"', '"', $text);
        $text = str_replace('="http', 'httpChuCiWDup', $text);
        $text = str_replace('="mailto', 'httpChuCiWOko', $text); 
        
        $text = preg_replace($pattern, $replacement, $text);
        $text = str_replace( 'httpChuCiWDup', '="http', $text);
        $text = str_replace( 'httpChuCiWOko','="mailto', $text);
        
        return $text;
    }
}
