<?php
/*
 * @package AJAX_Chat
 * @author Sebastian Tschan
 * @copyright (c) Sebastian Tschan
 * @license GNU Affero General Public License
 * @link https://blueimp.net/ajax/
 */

class CustomAJAXChat extends AJAXChat {
    // Initialize custom request variables:
	function initCustomRequestVars()
    {
        if (!$this->getRequestVar('logout') && Auth::instance()->logged_in())
        {
            $this->setRequestVar('userName', $_SESSION["auth_user"]->firstname.' '.$_SESSION["auth_user"]->lastname);
            $this->setRequestVar('userID', $_SESSION["auth_user"]->id);
            
            if (Auth::instance()->get_user()->has_role('admin'))
            {
                $this->setRequestVar('userRole', AJAX_CHAT_ADMIN);
            }
            else if (Auth::instance()->get_user()->has_role('moderator'))
            {
                $this->setRequestVar('userRole', AJAX_CHAT_MODERATOR);
            }
            else
            {
                $this->setRequestVar('userRole', AJAX_CHAT_USER);
            }
            
            $this->setRequestVar('login', true);
        }  
	}
    
    // Returns an associative array containing userName, userID and userRole
	// Returns null if login is invalid
    function getValidLoginUserData() {
        $customUsers = $this->getCustomUsers();
        
        if($this->getRequestVar('userName')) {
            // Check if we have a valid registered user:
            $userName = $this->getRequestVar('userName');
            $userName = $this->convertEncoding($userName, $this->getConfig('contentEncoding'), $this->getConfig('sourceEncoding'));
            
            $userData = array();
            $userData['userID'] = $this->getRequestVar('userID');
            $userData['userName'] = $userName;
            $userData['userRole'] = $this->getRequestVar('userRole');
            
            return $userData;
        }
        
        return null;
    }
    
	// Store the channels the current user has access to
	// Make sure channel names don't contain any whitespace
	function &getChannels() {
	    $channels = array();   	   
		foreach($this->getAllChannels() as $key => $value) {
            $channels[$key] = $value;
		}
        
        $items = Jelly::select('chat')
            ->where('active', '=', '1')
            ->execute();
        
        foreach($items as $it) {
            if ($it->course->id AND Auth::instance()->get_user()->is_subscribed($it->course->id))
            {
                $channels[$it->id] = $it->name;
            }
        }
        
        return $channels;
	}

	// Store all existing channels
	// Make sure channel names don't contain any whitespace
	function &getAllChannels() {
		if($this->_allChannels === null) {
			// Get all existing channels:
			$customChannels = $this->getCustomChannels();
			
			$defaultChannelFound = false;
			
			foreach($customChannels as $key=>$value) {
				$forumName = $this->trimChannelName($value);
				
				$this->_allChannels[$forumName] = $key;
				
				if($key == $this->getConfig('defaultChannelID')) {
					$defaultChannelFound = true;
				}
			}
			
			if(!$defaultChannelFound) {
				// Add the default channel as first array element to the channel list:
				$this->_allChannels = array_merge(
					array(
						$this->trimChannelName($this->getConfig('defaultChannelName'))=>$this->getConfig('defaultChannelID')
					),
					$this->_allChannels
				);
			}
		}
		return $this->_allChannels;
	}

	function &getCustomUsers() {
		// List containing the registered chat users:
		$users = null;
		require(AJAX_CHAT_PATH.'lib/data/users.php');
		return $users;
	}
	
	function &getCustomChannels() {
		$items = Jelly::select('chat')
            ->where('active', '=', '1')
            ->execute();
        
        $channels = array();
        foreach($items as $it) {
            $channels[$it->id] = $it->name;
        }
        
		return $channels;
	}

}
?>