# Понимание алиасов и мета-алиасов

Jelly повсеместно использует алиасы моделей и полей. В основном, при именовании полей в модели,
столбцы таблицы базы данных совпадает с именем поля, однако Jelly поволяет полям модели ссылаться на
столбец таблицы и с иным именем.Это означает, что можно с лёгкостью отделить схемы базы данных и
модели.

Jelly также имеет систему мета-алиасов,позволяющую ссылааться на специфические поля, которые
имеют общее для всех моделей назначение. Например, первичный ключ модели.

### Алиасы

При определении полей, можно указать столбец таблицы базы данных, который это поле будет представлять:

    class Model_Post extends Jelly_Model
    {
        public static function initialize($meta)
        {
            $meta->fields(array(
                'id' => new Field_Primary(array(
                    'column' => 'PostId')),
            ));
        }
    }

Теперь, при ссылке на поле 'id', при построении запроса будет использоваться столбец 'PostId'.
Например:

    $post->where('id', 'IN', array(1, 2, 3));
    
    // Следующий код будет работать, но логика запроса будет 
    // основываться на схеме базы данных, что не желательно
    $post->where('PostId', 'IN', array(1, 2, 3));

При ссылке на модель или поле, следует использовать имя модели или поля, на *не* имя таблицы или
столбца.

### Мета-алиасы

Мета-аслиасы - это синтаксические ярлыки для ссылки на конкретную область модели. В настоящее время
в Jelly определены четыре мета-алиаса:

  * **:primary_key** - ссылается на первичный ключ модели
  * **:name_key** - ссылается на именной ключ модели
  * **:unique_key** - ссылается на уникальный ключ модели
  * **:foreign_key** - ссылается на внешний ключ модели
  
##### Пример: использование мета-алиасов

    $post->where(':primary_key', '=', $value);
    $post->where(':name_key', '=', $value);
    
    // В этом случае, значение передаётся методу unique_key()
    // класса query builder'а, который возвращает соответствующее
    // поле на основе этого значения
    $post->where(':unique_key', '=', $value);
    
##### Пример: использование `:foreign_key` мета-алиаса

В основном, при работе необходимо ссылаться на внешний ключ другой модели. Для этого существует
специальный синтаксис.

    // Поиск постов, принадлежащих (belongs_to) автору
    $post->where('post.author:foreign_key', '=', $value);

    // Такой вариант тоже допустим, но не особо  удобен и практичен
    $post->where('author:primary_key', '=', $value);

В этом случае перед определением мета-алиаса определяется модель, из которой он извлекается.

[!!] **Заметка**: Мета-алиасы могут быть использованы только в query builder'е или с методом
as_array() в Jelly\_Collection.

## Изменение мета-алиаса

Первичный ключ (primary\_key), именной ключ (name\_key) и внешний ключ (foreign\_key) модели
определяются в initialize() методе. Более подробную информацию можно найти в
[API документации класса Jelly_Meta](api/Jelly_Meta).

С уникальным ключом (unique\_key) дело другое. Ввиду того, что ему передаётся значение, он может 
использовать собственное поле. Чтобы изменить его поведение, необходимо 
[создать специфический для модели экземпляр Jelly\_Builder класса](jelly.extending-builder).