/*
 * Decompiled with CFR 0.152.
 */
package com.matura.forms.dialogs;

import com.matura.api.form.model.IFormModel;
import com.matura.api.form.model.IQuestion;
import com.matura.api.form.model.ISpecialComponent;
import com.matura.api.xml.model.QuestionXml;
import com.matura.forms.actions.WindowEvents;
import com.matura.forms.timer.Timer;
import com.matura.forms.utils.FormulaGenerator;
import com.matura.forms.utils.SpecialButton;
import com.matura.forms.utils.SpecialLabel;
import com.matura.forms.utils.SpecialToggleButton;
import com.matura.impl.data.QuestionGet;
import com.matura.impl.utils.BundleUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.synth.SynthLookAndFeel;

public class MainFrame
extends WindowEvents {
    private static List<QuestionXml> staticQuestionsList = new ArrayList<QuestionXml>();
    private SynthLookAndFeel laf = new SynthLookAndFeel();
    private static JPanel mainPanel = null;
    private static final boolean IS_BORDER = true;
    private static Dimension centerPanelSize = null;
    private static JPanel headerPanel = null;
    private static JPanel headerShadowPanel = null;
    private static JPanel contentPanel = null;
    private static JPanel footerShadowPanel = null;
    private static JPanel footerPanel = null;
    private static JPanel headerIntroPanel = null;
    private static JPanel headerShadowIntroPanel = null;
    private static JPanel footerShadowIntroPanel = null;
    private static JPanel footerIntroPanel = null;
    private static JPanel contentHeaderPanel = null;
    private static JPanel contentCenterPanel = null;
    private static JPanel contentCenterLeftPanel = null;
    private static JPanel contentCenterCenterPanel = null;
    private static JPanel contentCenterCenterExerciseContentPanel = null;
    private static JPanel contentCenterRightPanel = null;
    private static JPanel contentFooterPanel = null;
    private static JPanel exerciseButtonsPanel = null;
    private static JPanel exerciseButtonsPanelTop = null;
    private static JPanel exerciseButtonsPanelBottom = null;
    private static JPanel leftBottomButtonsPanel = null;
    private SpecialLabel timerLabel = null;
    private static int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
    private static int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
    private static final long serialVersionUID = 1L;
    private Timer timer = null;
    private boolean random = false;
    private boolean startScreen = true;

    public MainFrame(boolean random) {
        this.random = random;
        QuestionGet qg = new QuestionGet();
        staticQuestionsList = qg.getQuestionsListFromResource();
        Map questions = qg.getQuestionsList(staticQuestionsList, random);
        this.formModel.setAllQuestionsMap(questions);
        this.formModel.setAllQuestions(qg.getSortedQuestionsList(questions));
        this.loadLayout();
        FormulaGenerator.prepareFormulaEnvironment();
        this.prepareCommonLayout();
        this.prepareIntroLayout();
        this.prepareMainWindow();
    }

    public void startNewExam() {
        this.startScreen = false;
        this.formModel.setSummary(null);
        QuestionGet qg = new QuestionGet();
        List oldQuestions = this.formModel.getAllQuestions();
        ArrayList<ISpecialComponent> components = new ArrayList<ISpecialComponent>();
        for (IQuestion question : oldQuestions) {
            components.add(question.getComponent());
        }
        Map questions = qg.getQuestionsList(staticQuestionsList, this.random);
        this.formModel.setAllQuestionsMap(questions);
        this.formModel.setAllQuestions(qg.getSortedQuestionsList(questions));
        int index = 0;
        for (IQuestion question : this.formModel.getAllQuestions()) {
            ISpecialComponent c = (ISpecialComponent)components.get(index++);
            ((SpecialToggleButton)c).getModel().setPressed(false);
            ((SpecialToggleButton)c).getModel().setSelected(false);
            ((SpecialToggleButton)c).getModel().setRollover(false);
            ((SpecialToggleButton)c).getModel().setEnabled(true);
            question.setComponent(c);
        }
        this.formModel.setCurrentQuestion((IQuestion)this.formModel.getAllQuestionsMap().get("1"));
        ((SpecialToggleButton)this.formModel.getCurrentQuestion().getComponent()).doClick();
        this.timer.stopTimer();
        this.timer = new Timer(this, 10200000L);
        this.timer.start();
    }

    private void loadLayout() {
        try {
            this.laf.load(MainFrame.class.getClassLoader().getResourceAsStream("com/matura/layouts/layout_1.xml"), this.getClass());
            UIManager.setLookAndFeel(this.laf);
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(e);
        }
        catch (ParseException e) {
            System.err.println(e);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
        }
    }

    private void prepareCommonLayout() {
        this.mainFrame = this;
        boolean isBorderSet = true;
        GridBagLayout layout = new GridBagLayout();
        mainPanel = new JPanel();
        mainPanel.setSize(new Dimension(screenWidth, screenHeight));
        mainPanel.setName("mainPanel");
        mainPanel.setLayout(layout);
        centerPanel = new JPanel();
        centerPanel.setName("centerPanel");
        centerPanelSize = new Dimension(1000 + (isBorderSet ? 2 : 0), 744);
        centerPanel.setPreferredSize(centerPanelSize);
        centerPanel.setLayout(new BoxLayout(centerPanel, 3));
        if (isBorderSet) {
            Border border = BorderFactory.createLineBorder(Color.decode("#323232"), 1);
            centerPanel.setBorder(border);
        }
        mainPanel.add((Component)centerPanel, new GridBagConstraints());
        this.getContentPane().add(mainPanel);
    }

    private void prepareIntroLayout() {
        headerIntroPanel = new JPanel();
        headerIntroPanel.setName("headerIntroPanel");
        Dimension headerPanelSize = new Dimension(MainFrame.centerPanelSize.width, 130);
        headerIntroPanel.setPreferredSize(headerPanelSize);
        headerIntroPanel.setMaximumSize(headerPanelSize);
        headerShadowIntroPanel = new JPanel();
        headerShadowIntroPanel.setName("headerShadowIntroPanel");
        Dimension headerShadowPanelSize = new Dimension(MainFrame.centerPanelSize.width, 20);
        headerShadowIntroPanel.setPreferredSize(headerShadowPanelSize);
        headerShadowIntroPanel.setMaximumSize(headerShadowPanelSize);
        footerShadowIntroPanel = new JPanel();
        footerShadowIntroPanel.setName("footerShadowIntroPanel");
        Dimension footerShadowPanelSize = new Dimension(MainFrame.centerPanelSize.width, 20);
        footerShadowIntroPanel.setPreferredSize(footerShadowPanelSize);
        footerShadowIntroPanel.setMaximumSize(footerShadowPanelSize);
        footerIntroPanel = new JPanel();
        footerIntroPanel.setName("footerPanel");
        Dimension footerPanelSize = new Dimension(MainFrame.centerPanelSize.width, 50);
        footerIntroPanel.setPreferredSize(footerPanelSize);
        footerIntroPanel.setMaximumSize(footerPanelSize);
        footerIntroPanel.setLayout(new BoxLayout(footerIntroPanel, 2));
        footerIntroPanel.add(Box.createRigidArea(new Dimension(10, 8)));
        JPanel distribution = new JPanel();
        distribution.setName("distribution");
        distribution.setPreferredSize(new Dimension(384, 31));
        distribution.setMaximumSize(new Dimension(384, 31));
        distribution.setAlignmentY(0.0f);
        footerIntroPanel.add(distribution);
        centerPanel.add(headerIntroPanel);
        centerPanel.add(headerShadowIntroPanel);
        JPanel logosPanel = new JPanel();
        logosPanel.setLayout(new BoxLayout(logosPanel, 2));
        logosPanel.setMaximumSize(new Dimension(headerPanelSize.width, 70));
        JPanel logoKapital = new JPanel();
        logoKapital.setName("logoKapital");
        logoKapital.setPreferredSize(new Dimension(195, 65));
        logoKapital.setMaximumSize(new Dimension(195, 65));
        JPanel logoPL = new JPanel();
        logoPL.setName("logoPL");
        logoPL.setPreferredSize(new Dimension(159, 70));
        logoPL.setMaximumSize(new Dimension(159, 70));
        JPanel logoMEN = new JPanel();
        logoMEN.setName("logoMEN");
        logoMEN.setPreferredSize(new Dimension(150, 68));
        logoMEN.setMaximumSize(new Dimension(150, 68));
        JPanel logoUE = new JPanel();
        logoUE.setName("logoUE");
        logoUE.setPreferredSize(new Dimension(197, 53));
        logoUE.setMaximumSize(new Dimension(197, 53));
        logosPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        logosPanel.add(logoKapital);
        logosPanel.add(Box.createHorizontalGlue());
        logosPanel.add(logoPL);
        logosPanel.add(Box.createHorizontalGlue());
        logosPanel.add(logoMEN);
        logosPanel.add(Box.createHorizontalGlue());
        logosPanel.add(logoUE);
        logosPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        centerPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        centerPanel.add(logosPanel);
        JPanel best = new JPanel();
        best.setName("titleBest");
        best.setPreferredSize(new Dimension(221, 13));
        best.setMaximumSize(new Dimension(221, 13));
        centerPanel.add(Box.createRigidArea(new Dimension(0, 30)));
        centerPanel.add(best);
        SpecialLabel ueLabel = new SpecialLabel(BundleUtil.getBundle((String)"intro.panel.ue"));
        ueLabel.setName("euLabel");
        JPanel euPanel = new JPanel();
        euPanel.add(ueLabel);
        centerPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        centerPanel.add(euPanel);
        JPanel examTitle = new JPanel();
        examTitle.setMaximumSize(new Dimension(headerPanelSize.width - 2, 50));
        SpecialLabel examTitleLabel = new SpecialLabel(BundleUtil.getBundle((String)"intro.window.exam.title"));
        examTitleLabel.setName("introExamTitle");
        examTitle.add(examTitleLabel);
        centerPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        centerPanel.add(examTitle);
        JPanel examDescription = new JPanel();
        examDescription.setMaximumSize(new Dimension(headerPanelSize.width - 2, 150));
        SpecialLabel examDescriptionLabel = new SpecialLabel(BundleUtil.getBundle((String)"intro.window.exam.description"));
        examDescriptionLabel.setName("introExamDescription");
        examDescription.add(examDescriptionLabel);
        centerPanel.add(examDescription);
        JPanel goodLuckPanel = new JPanel();
        goodLuckPanel.setMaximumSize(new Dimension(headerPanelSize.width - 2, 50));
        SpecialLabel goodLuckLabel = new SpecialLabel(BundleUtil.getBundle((String)"intro.window.exam.good.luck"));
        goodLuckLabel.setName("introExamGoodLuck");
        goodLuckPanel.add(goodLuckLabel);
        centerPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        centerPanel.add(goodLuckPanel);
        JPanel startExamPanel = new JPanel();
        startExamPanel.setMaximumSize(new Dimension(headerPanelSize.width - 2, 40));
        SpecialButton startExamButton = new SpecialButton(BundleUtil.getBundle((String)"intro.window.start.exam"));
        startExamButton.setName("introStartExamButton");
        startExamButton.addMouseListener(this);
        startExamButton.setToolTipText(BundleUtil.getBundle((String)"intro.window.start.exam.tooltip"));
        startExamButton.setPreferredSize(new Dimension(196, 37));
        startExamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.prepareExerciseLayout();
            }
        });
        startExamPanel.add(startExamButton);
        centerPanel.add(startExamPanel);
        centerPanel.add(footerShadowIntroPanel);
        centerPanel.add(footerIntroPanel);
    }

    private void prepareExerciseLayout() {
        SpecialToggleButton exerciseButton;
        int i;
        this.startScreen = false;
        centerPanel.setVisible(false);
        centerPanel.removeAll();
        headerPanel = new JPanel();
        headerPanel.setName("headerPanel");
        Dimension headerPanelSize = new Dimension(MainFrame.centerPanelSize.width, 100);
        headerPanel.setPreferredSize(headerPanelSize);
        headerShadowPanel = new JPanel();
        headerShadowPanel.setName("headerShadowPanel");
        Dimension headerShadowPanelSize = new Dimension(MainFrame.centerPanelSize.width, 20);
        headerShadowPanel.setPreferredSize(headerShadowPanelSize);
        contentPanel = new JPanel();
        contentPanel.setName("contentPanel");
        Dimension contentPanelSize = new Dimension(MainFrame.centerPanelSize.width, 522);
        contentPanel.setPreferredSize(contentPanelSize);
        contentPanel.setLayout(new BoxLayout(contentPanel, 3));
        contentHeaderPanel = new JPanel();
        contentHeaderPanel.setName("contentHeaderPanel");
        contentHeaderPanel.setLayout(new BoxLayout(contentHeaderPanel, 2));
        contentHeaderPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        this.exerciseTitleLabel = new SpecialLabel();
        this.exerciseTitleLabel.setName("exerciseTitleName");
        this.exerciseTitleLabel.setPreferredSize(new Dimension(250, 30));
        contentHeaderPanel.add(this.exerciseTitleLabel);
        contentHeaderPanel.add(Box.createRigidArea(new Dimension(100, 0)));
        this.exercisePointsLabel = new SpecialLabel();
        this.exercisePointsLabel.setName("exercisePointsName");
        contentHeaderPanel.add(this.exercisePointsLabel);
        contentHeaderPanel.add(Box.createHorizontalGlue());
        this.timerLabel = new SpecialLabel();
        this.timerLabel.setName("timerName");
        contentHeaderPanel.add(this.timerLabel);
        contentHeaderPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        contentCenterPanel = new JPanel();
        contentCenterPanel.setName("contentCenterPanel");
        Dimension contentCenterPanelSize = new Dimension(998, 418);
        contentCenterPanel.setPreferredSize(contentCenterPanelSize);
        contentCenterPanel.setMaximumSize(contentCenterPanelSize);
        contentCenterPanel.setLayout(new BoxLayout(contentCenterPanel, 2));
        contentCenterLeftPanel = new JPanel();
        contentCenterLeftPanel.setName("contentCenterLeft");
        contentCenterLeftPanel.setPreferredSize(new Dimension(50, 418));
        contentCenterLeftPanel.setMaximumSize(new Dimension(50, 418));
        contentCenterLeftPanel.setLayout(new GridBagLayout());
        contentCenterRightPanel = new JPanel();
        contentCenterRightPanel.setName("contentCenterRight");
        contentCenterRightPanel.setPreferredSize(new Dimension(50, 418));
        contentCenterRightPanel.setMaximumSize(new Dimension(50, 418));
        contentCenterRightPanel.setLayout(new GridBagLayout());
        this.previousButton = new SpecialButton();
        this.previousButton.setToolTipText(BundleUtil.getBundle((String)"previous.exercise"));
        this.previousButton.setPreferredSize(new Dimension(35, 62));
        this.previousButton.addActionListener(this);
        this.previousButton.addMouseListener(this);
        this.previousButton.setName("previousButton");
        this.previousButton.setActionCommand("previousButtonAction");
        contentCenterLeftPanel.add((Component)this.previousButton, new GridBagConstraints());
        contentCenterCenterPanel = new JPanel();
        contentCenterCenterPanel.setName("contentCenterCenter");
        contentCenterCenterPanel.setPreferredSize(new Dimension(contentCenterPanelSize.getSize().width - MainFrame.contentCenterLeftPanel.getSize().width - MainFrame.contentCenterRightPanel.getSize().width, contentCenterPanelSize.height));
        contentCenterCenterPanel.setLayout(new BoxLayout(contentCenterCenterPanel, 3));
        contentCenterCenterExerciseContentPanel = new JPanel();
        contentCenterCenterExerciseContentPanel.setLayout(new BorderLayout());
        this.exerciseContentLabel = new SpecialLabel();
        contentCenterCenterExerciseContentPanel.add((Component)this.exerciseContentLabel, "First");
        contentCenterCenterPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        contentCenterCenterPanel.add(contentCenterCenterExerciseContentPanel);
        this.contentCenterCenterExerciseAnswersPanel = new JPanel();
        this.contentCenterCenterExerciseAnswersPanel.setPreferredSize(new Dimension(contentCenterCenterPanel.getWidth(), contentCenterPanelSize.height));
        contentCenterCenterPanel.add(this.contentCenterCenterExerciseAnswersPanel);
        this.nextButton = new SpecialButton();
        this.nextButton.setToolTipText(BundleUtil.getBundle((String)"next.exercise"));
        this.nextButton.setPreferredSize(new Dimension(35, 62));
        this.nextButton.setName("nextButton");
        this.nextButton.addActionListener(this);
        this.nextButton.addMouseListener(this);
        this.nextButton.setActionCommand("nextButtonAction");
        contentCenterRightPanel.add((Component)this.nextButton, new GridBagConstraints());
        contentCenterPanel.add(contentCenterLeftPanel);
        contentCenterPanel.add(contentCenterCenterPanel);
        contentCenterPanel.add(contentCenterRightPanel);
        contentFooterPanel = new JPanel();
        contentFooterPanel.setName("contentFooterPanel");
        Dimension contentFooterPanelSize = new Dimension(970, 60);
        contentFooterPanel.setPreferredSize(contentFooterPanelSize);
        contentFooterPanel.setMaximumSize(contentFooterPanelSize);
        contentFooterPanel.setLayout(new BoxLayout(contentFooterPanel, 2));
        this.instructionLabel = new SpecialLabel();
        this.instructionLabel.setName("manualLabel");
        contentPanel.add(contentHeaderPanel);
        contentPanel.add(contentCenterPanel);
        contentPanel.add(contentFooterPanel);
        footerShadowPanel = new JPanel();
        footerShadowPanel.setName("footerShadowPanel");
        Dimension footerShadowPanelSize = new Dimension(MainFrame.centerPanelSize.width, 20);
        footerShadowPanel.setPreferredSize(footerShadowPanelSize);
        footerPanel = new JPanel();
        footerPanel.setName("footerPanel");
        Dimension footerPanelSize = new Dimension(MainFrame.centerPanelSize.width, 80);
        footerPanel.setPreferredSize(footerPanelSize);
        footerPanel.setLayout(new BoxLayout(footerPanel, 2));
        exerciseButtonsPanel = new JPanel();
        exerciseButtonsPanel.setLayout(new BoxLayout(exerciseButtonsPanel, 3));
        exerciseButtonsPanel.setPreferredSize(new Dimension(500, 80));
        exerciseButtonsPanelTop = new JPanel();
        exerciseButtonsPanelTop.setPreferredSize(new Dimension(500, 40));
        exerciseButtonsPanelTop.setLayout(new BoxLayout(exerciseButtonsPanelTop, 2));
        exerciseButtonsPanelTop.add(Box.createHorizontalGlue());
        for (i = 0; i < 17; ++i) {
            exerciseButton = new SpecialToggleButton(String.valueOf(i + 1));
            exerciseButton.setPreferredSize(new Dimension(36, 36));
            exerciseButton.addMouseListener(this);
            exerciseButton.addActionListener(this);
            exerciseButton.setName("exerciseButtonNumber" + String.valueOf(i + 1));
            exerciseButtonsPanelTop.add(Box.createRigidArea(new Dimension(5, 0)));
            exerciseButtonsPanelTop.add(exerciseButton);
            ((IQuestion)this.formModel.getAllQuestionsMap().get(String.valueOf(i + 1))).setComponent((ISpecialComponent)exerciseButton);
        }
        exerciseButtonsPanelTop.add(Box.createRigidArea(new Dimension(20, 0)));
        exerciseButtonsPanelBottom = new JPanel();
        exerciseButtonsPanelBottom.setPreferredSize(new Dimension(500, 40));
        exerciseButtonsPanelBottom.setLayout(new BoxLayout(exerciseButtonsPanelBottom, 2));
        exerciseButtonsPanelBottom.add(Box.createHorizontalGlue());
        for (i = 17; i < 34; ++i) {
            exerciseButton = new SpecialToggleButton(String.valueOf(i + 1));
            exerciseButton.setPreferredSize(new Dimension(36, 36));
            exerciseButton.addMouseListener(this);
            exerciseButton.addActionListener(this);
            exerciseButton.setName("exerciseButtonNumber" + String.valueOf(i + 1));
            exerciseButtonsPanelBottom.add(Box.createRigidArea(new Dimension(5, 0)));
            exerciseButtonsPanelBottom.add(exerciseButton);
            ((IQuestion)this.formModel.getAllQuestionsMap().get(String.valueOf(i + 1))).setComponent((ISpecialComponent)exerciseButton);
        }
        this.formModel.setCurrentQuestion((IQuestion)this.formModel.getAllQuestionsMap().get("1"));
        ((SpecialToggleButton)this.formModel.getCurrentQuestion().getComponent()).doClick();
        exerciseButtonsPanelBottom.add(Box.createRigidArea(new Dimension(20, 0)));
        exerciseButtonsPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        exerciseButtonsPanel.add(exerciseButtonsPanelTop);
        exerciseButtonsPanel.add(Box.createVerticalGlue());
        exerciseButtonsPanel.add(exerciseButtonsPanelBottom);
        this.correctAnswerButton = new SpecialButton();
        this.correctAnswerButton.setName("correctAnswerButton");
        this.correctAnswerButton.setToolTipText(BundleUtil.getBundle((String)"show.correct.answer"));
        this.correctAnswerButton.setActionCommand("correctAnswerButtonAction");
        this.correctAnswerButton.setPreferredSize(new Dimension(40, 40));
        this.correctAnswerButton.setMaximumSize(new Dimension(40, 40));
        this.correctAnswerButton.addMouseListener(this);
        this.correctAnswerButton.addActionListener(this);
        contentFooterPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        contentFooterPanel.add(this.instructionLabel);
        contentFooterPanel.add(Box.createHorizontalGlue());
        contentFooterPanel.add(this.correctAnswerButton);
        contentFooterPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        this.correctAnswerButton.setVisible(false);
        leftBottomButtonsPanel = new JPanel();
        leftBottomButtonsPanel.setPreferredSize(new Dimension(168, 80));
        leftBottomButtonsPanel.setLayout(new BoxLayout(leftBottomButtonsPanel, 3));
        this.finishExamButton = new SpecialButton(BundleUtil.getBundle((String)"finish.exam.button.label"));
        this.finishExamButton.setToolTipText(BundleUtil.getBundle((String)"finish.exam.button.tooltip"));
        this.finishExamButton.addMouseListener(this);
        this.finishExamButton.setName("finishExamButton");
        this.finishExamButton.setActionCommand("finishExamButtonAction");
        this.finishExamButton.setPreferredSize(new Dimension(168, 38));
        this.finishExamButton.setMinimumSize(new Dimension(168, 38));
        this.finishExamButton.addActionListener(this);
        this.summaryButton = new SpecialButton(BundleUtil.getBundle((String)"summary.button.label"));
        this.summaryButton.setToolTipText(BundleUtil.getBundle((String)"summary.button.tooltip"));
        this.summaryButton.addMouseListener(this);
        this.summaryButton.setName("summaryButton");
        this.summaryButton.setActionCommand("summaryButtonAction");
        this.summaryButton.setPreferredSize(new Dimension(168, 38));
        this.summaryButton.setMinimumSize(new Dimension(168, 38));
        this.summaryButton.addActionListener(this);
        this.summaryButton.setVisible(false);
        this.finishProgramButton = new SpecialButton(BundleUtil.getBundle((String)"finish.program.button.label"));
        this.finishProgramButton.setToolTipText(BundleUtil.getBundle((String)"finish.program.button.tooltip"));
        this.finishProgramButton.addMouseListener(this);
        this.finishProgramButton.setName("finishProgramButton");
        this.finishProgramButton.setActionCommand("finishProgramButtonAction");
        this.finishProgramButton.setPreferredSize(new Dimension(168, 38));
        this.finishProgramButton.setMinimumSize(new Dimension(168, 38));
        this.finishProgramButton.addActionListener(this);
        leftBottomButtonsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        leftBottomButtonsPanel.add(this.finishExamButton);
        leftBottomButtonsPanel.add(this.summaryButton);
        leftBottomButtonsPanel.add(Box.createVerticalGlue());
        leftBottomButtonsPanel.add(this.finishProgramButton);
        footerPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        footerPanel.add(leftBottomButtonsPanel);
        footerPanel.add(exerciseButtonsPanel);
        centerPanel.add(headerPanel);
        centerPanel.add(headerShadowPanel);
        centerPanel.add(contentPanel);
        centerPanel.add(footerShadowPanel);
        centerPanel.add(footerPanel);
        centerPanel.setVisible(true);
        this.timer = new Timer(this, 10200000L);
        this.timer.start();
    }

    private void prepareMainWindow() {
        try {
            this.setIconImage(ImageIO.read(this.getClass().getClassLoader().getResourceAsStream("com/matura/images/icon.png")));
        }
        catch (IOException e) {
            System.out.println(e);
        }
        this.addWindowListener(this);
        this.setTitle(BundleUtil.getBundle((String)"main.window.title"));
        this.setName("mainFrame");
        this.setSize(screenWidth, screenHeight);
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.setUndecorated(true);
        this.setVisible(true);
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public IFormModel getFormModel() {
        return this.formModel;
    }

    public SpecialLabel getTimerLabel() {
        return this.timerLabel;
    }

    public void setTimerLabel(SpecialLabel timerLabel) {
        this.timerLabel = timerLabel;
    }

    public boolean isStartScreen() {
        return this.startScreen;
    }
}

