/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.NoSuchAlgorithmException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.DefaultSSLServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    private static SSLServerSocketFactory theFactory;
    private static boolean propertyChecked;

    private static void log(String string) {
        if (SSLSocketFactory.DEBUG) {
            System.out.println(string);
        }
    }

    protected SSLServerSocketFactory() {
    }

    public static synchronized ServerSocketFactory getDefault() {
        if (theFactory != null) {
            return theFactory;
        }
        if (!propertyChecked) {
            propertyChecked = true;
            String string = SSLSocketFactory.getSecurityProperty("ssl.ServerSocketFactory.provider");
            if (string != null) {
                SSLServerSocketFactory.log("setting up default SSLServerSocketFactory");
                try {
                    Class<?> clazz;
                    block9: {
                        clazz = null;
                        try {
                            clazz = Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                            if (classLoader == null) break block9;
                            clazz = classLoader.loadClass(string);
                        }
                    }
                    SSLServerSocketFactory.log("class " + string + " is loaded");
                    SSLServerSocketFactory sSLServerSocketFactory = (SSLServerSocketFactory)clazz.newInstance();
                    SSLServerSocketFactory.log("instantiated an instance of class " + string);
                    theFactory = sSLServerSocketFactory;
                    return sSLServerSocketFactory;
                }
                catch (Exception exception) {
                    SSLServerSocketFactory.log("SSLServerSocketFactory instantiation failed: " + exception);
                    theFactory = new DefaultSSLServerSocketFactory(exception);
                    return theFactory;
                }
            }
        }
        try {
            return SSLContext.getDefault().getServerSocketFactory();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new DefaultSSLServerSocketFactory(noSuchAlgorithmException);
        }
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();
}

