/*
 * Decompiled with CFR 0.152.
 */
package com.matura.impl.data;

import com.matura.api.data.ISummaryPreparation;
import com.matura.api.form.model.IAnswer;
import com.matura.api.form.model.IData;
import com.matura.api.form.model.IElement;
import com.matura.api.form.model.IQuestion;
import com.matura.api.form.model.ISummary;
import com.matura.impl.form.model.Summary;
import com.matura.impl.utils.QuestionUtils;
import java.util.ArrayList;
import java.util.List;

public class SummaryPreparation
implements ISummaryPreparation {
    public ISummary prepareSummary(List<IQuestion> questions, long time) {
        int yourScore = 0;
        int maxScore = 0;
        if (questions != null) {
            for (IQuestion question : questions) {
                if (!question.isOpen()) {
                    IAnswer correctAnswer = question.getCorrectAnswer();
                    if (question != null && correctAnswer != null && correctAnswer.isSelected()) {
                        question.setYourScore(question.getScore());
                        yourScore += question.getScore();
                    }
                } else {
                    int questionScore = 0;
                    for (IData data : question.getDataList()) {
                        if (data.isAlternate()) {
                            ArrayList<String> correctValues = new ArrayList<String>();
                            for (IElement element : data.getDataElements()) {
                                if (!"select".equals(element.getType())) continue;
                                correctValues.add(String.valueOf(element.getCorrectValueIndex()));
                            }
                            for (IElement element : data.getDataElements()) {
                                if (!QuestionUtils.isAnswerCorrect(element, correctValues)) continue;
                                questionScore += element.getScore();
                            }
                            continue;
                        }
                        for (IElement element : data.getDataElements()) {
                            if (!"select".equals(element.getType()) || element.getCorrectValueIndex() != element.getSelectedValueIndex()) continue;
                            questionScore += element.getScore();
                        }
                    }
                    question.setYourScore(questionScore);
                    yourScore += questionScore;
                }
                maxScore += question.getScore();
            }
        }
        Summary summary = new Summary();
        summary.setYourScore(yourScore);
        summary.setMaxScore(maxScore);
        summary.setTimeLeft(time);
        return summary;
    }
}

