/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    protected Vector<TableColumn> tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;

    public DefaultTableColumnModel() {
        this.tableColumns = new Vector();
        this.setSelectionModel(this.createSelectionModel());
        this.setColumnMargin(1);
        this.invalidateWidthCache();
        this.setColumnSelectionAllowed(false);
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.tableColumns.addElement(tableColumn);
        tableColumn.addPropertyChangeListener(this);
        this.invalidateWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        int n = this.tableColumns.indexOf(tableColumn);
        if (n != -1) {
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(n, n);
            }
            tableColumn.removePropertyChangeListener(this);
            this.tableColumns.removeElementAt(n);
            this.invalidateWidthCache();
            this.fireColumnRemoved(new TableColumnModelEvent(this, n, 0));
        }
    }

    @Override
    public void moveColumn(int n, int n2) {
        if (n < 0 || n >= this.getColumnCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        if (n == n2) {
            this.fireColumnMoved(new TableColumnModelEvent(this, n, n2));
            return;
        }
        TableColumn tableColumn = this.tableColumns.elementAt(n);
        this.tableColumns.removeElementAt(n);
        boolean bl = this.selectionModel.isSelectedIndex(n);
        this.selectionModel.removeIndexInterval(n, n);
        this.tableColumns.insertElementAt(tableColumn, n2);
        this.selectionModel.insertIndexInterval(n2, 1, true);
        if (bl) {
            this.selectionModel.addSelectionInterval(n2, n2);
        } else {
            this.selectionModel.removeSelectionInterval(n2, n2);
        }
        this.fireColumnMoved(new TableColumnModelEvent(this, n, n2));
    }

    @Override
    public void setColumnMargin(int n) {
        if (n != this.columnMargin) {
            this.columnMargin = n;
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return this.tableColumns.elements();
    }

    @Override
    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Enumeration<TableColumn> enumeration = this.getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (object.equals(tableColumn.getIdentifier())) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    @Override
    public TableColumn getColumn(int n) {
        return this.tableColumns.elementAt(n);
    }

    @Override
    public int getColumnMargin() {
        return this.columnMargin;
    }

    @Override
    public int getColumnIndexAtX(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if ((n -= this.getColumn(i).getWidth()) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            listSelectionModel.addListSelectionListener(this);
        }
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
        this.columnSelectionAllowed = bl;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    @Override
    public int[] getSelectedColumns() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            if (n == -1 || n2 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n2 - n)];
            int n3 = 0;
            for (int i = n; i <= n2; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                nArray[n3++] = i;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        return new int[0];
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            int n3 = 0;
            for (int i = n; i <= n2; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ++n3;
            }
            return n3;
        }
        return 0;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.add(TableColumnModelListener.class, tableColumnModelListener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.remove(TableColumnModelListener.class, tableColumnModelListener);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        return (TableColumnModelListener[])this.listenerList.getListeners(TableColumnModelListener.class);
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnAdded(tableColumnModelEvent);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnRemoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnMoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnSelectionChanged(listSelectionEvent);
        }
    }

    protected void fireColumnMarginChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((TableColumnModelListener)objectArray[i + 1]).columnMarginChanged(this.changeEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "width" || string == "preferredWidth") {
            this.invalidateWidthCache();
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireColumnSelectionChanged(listSelectionEvent);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void recalcWidthCache() {
        Enumeration<TableColumn> enumeration = this.getColumns();
        this.totalColumnWidth = 0;
        while (enumeration.hasMoreElements()) {
            this.totalColumnWidth += enumeration.nextElement().getWidth();
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }
}

