/*
 * Decompiled with CFR 0.152.
 */
package com.matura.forms.dialogs;

import com.matura.api.form.model.IData;
import com.matura.api.form.model.IQuestion;
import com.matura.forms.actions.CorrectAnswerDialogEvents;
import com.matura.forms.dialogs.MainFrame;
import com.matura.forms.utils.FormulaGenerator;
import com.matura.forms.utils.SpecialButton;
import com.matura.forms.utils.SpecialLabel;
import com.matura.impl.utils.BundleUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class CorrectAnswerDialog
extends CorrectAnswerDialogEvents {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel;

    public CorrectAnswerDialog(MainFrame mainFrame) {
        super(mainFrame);
        boolean isBorderSet = true;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(screenSize.width / 2 - 250, screenSize.height / 2 - 150, 500 - (isBorderSet ? 2 : 0), 300 - (isBorderSet ? 2 : 0));
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.mainPanel.setSize(this.getSize());
        this.mainPanel.setName("correctAnswerMainPanel");
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        if (isBorderSet) {
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        IQuestion currentQuestion = mainFrame.getFormModel().getCurrentQuestion();
        SpecialLabel exerciseLabel = new SpecialLabel(BundleUtil.getBundle((String)"correct.answer.window.title"));
        exerciseLabel.setName("correctAnswerExerciseTitleName");
        JPanel exerciseTitlePanel = new JPanel();
        exerciseTitlePanel.setLayout(new BoxLayout(exerciseTitlePanel, 2));
        exerciseTitlePanel.setPreferredSize(new Dimension(this.getSize().width, 30));
        exerciseTitlePanel.add(Box.createRigidArea(new Dimension(20, 0)));
        exerciseTitlePanel.add(exerciseLabel);
        exerciseTitlePanel.add(Box.createHorizontalGlue());
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        this.mainPanel.add(exerciseTitlePanel);
        if (currentQuestion.isOpen()) {
            for (IData data : currentQuestion.getDataList()) {
                if (data.getAnswer() == null) continue;
                JPanel rowPanel = new JPanel();
                rowPanel.setLayout(new BoxLayout(rowPanel, 2));
                SpecialLabel answerLabel = new SpecialLabel();
                answerLabel.setIconTextGap(0);
                answerLabel.setIcon(FormulaGenerator.getImageIcon(data.getAnswer()));
                rowPanel.add(Box.createRigidArea(new Dimension(40, 0)));
                rowPanel.add(answerLabel);
                rowPanel.add(Box.createHorizontalGlue());
                this.mainPanel.add(Box.createRigidArea(new Dimension(0, 20)));
                this.mainPanel.add(rowPanel);
            }
        } else {
            JPanel rowPanel = new JPanel();
            rowPanel.setLayout(new BoxLayout(rowPanel, 2));
            SpecialLabel answerLabel = new SpecialLabel();
            answerLabel.setIconTextGap(0);
            answerLabel.setIcon(FormulaGenerator.getImageIcon(currentQuestion.getCorrectAnswer().getContent()));
            rowPanel.add(Box.createRigidArea(new Dimension(40, 0)));
            rowPanel.add(answerLabel);
            rowPanel.add(Box.createHorizontalGlue());
            this.mainPanel.add(Box.createRigidArea(new Dimension(0, 20)));
            this.mainPanel.add(rowPanel);
        }
        this.mainPanel.add(Box.createVerticalGlue());
        JPanel closeButtonPanel = new JPanel();
        closeButtonPanel.setPreferredSize(new Dimension(this.getSize().width, 40));
        closeButtonPanel.setLayout(new BoxLayout(closeButtonPanel, 2));
        SpecialButton closeWindowButton = new SpecialButton(BundleUtil.getBundle((String)"close.window.button.label"));
        closeWindowButton.setName("closeWindowButtonDark");
        closeWindowButton.setPreferredSize(new Dimension(160, 39));
        closeWindowButton.setMaximumSize(new Dimension(160, 39));
        closeWindowButton.setActionCommand("closeWindowButtonAction");
        closeWindowButton.addMouseListener(this);
        closeWindowButton.addActionListener(this);
        closeButtonPanel.add(closeWindowButton);
        this.mainPanel.add(closeButtonPanel);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 30)));
        this.getContentPane().add(this.mainPanel);
        this.setDefaultCloseOperation(0);
        this.setUndecorated(true);
        this.setModal(true);
        this.setAlwaysOnTop(true);
    }
}

