/*
 * Decompiled with CFR 0.152.
 */
package com.matura.forms.actions;

import com.matura.api.form.model.IAnswer;
import com.matura.api.form.model.IData;
import com.matura.api.form.model.IElement;
import com.matura.api.form.model.IFormModel;
import com.matura.api.form.model.IQuestion;
import com.matura.api.xml.model.ValueXml;
import com.matura.forms.dialogs.CorrectAnswerDialog;
import com.matura.forms.dialogs.MainFrame;
import com.matura.forms.dialogs.SummaryDialog;
import com.matura.forms.dialogs.YesNoDialog;
import com.matura.forms.utils.BackgroundImagePanel;
import com.matura.forms.utils.FormulaGenerator;
import com.matura.forms.utils.IconListRenderer;
import com.matura.forms.utils.SpecialButton;
import com.matura.forms.utils.SpecialLabel;
import com.matura.forms.utils.SpecialToggleButton;
import com.matura.forms.utils.YesNoWindow;
import com.matura.impl.form.model.FormModel;
import com.matura.impl.utils.BundleUtil;
import com.matura.impl.utils.QuestionUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowEvents
extends JFrame
implements ActionListener,
MouseListener,
ChangeListener,
WindowListener {
    protected static JPanel centerPanel = null;
    protected SpecialLabel exerciseTitleLabel = null;
    protected SpecialLabel exercisePointsLabel = null;
    protected IFormModel formModel = new FormModel();
    protected SpecialButton finishExamButton = null;
    protected SpecialButton finishProgramButton = null;
    protected SpecialButton summaryButton = null;
    protected MainFrame mainFrame;
    protected SpecialLabel instructionLabel = null;
    protected SpecialButton correctAnswerButton = null;
    protected SpecialButton previousButton = null;
    protected SpecialButton nextButton = null;
    protected SpecialLabel exerciseContentLabel = null;
    protected JPanel contentCenterCenterExerciseAnswersPanel = null;
    protected SummaryDialog summaryDialog;
    protected CorrectAnswerDialog[] correctAnswerDialog = new CorrectAnswerDialog[34];
    protected YesNoDialog yesNoDialogExam;
    protected YesNoDialog yesNoDialogProgram1;
    protected YesNoDialog yesNoDialogProgram2;

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getComponent() instanceof SpecialToggleButton || e.getComponent() instanceof SpecialButton || this.formModel.getSummary() == null && e.getComponent() instanceof JRadioButton) {
            e.getComponent().setCursor(new Cursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getComponent() instanceof SpecialToggleButton || e.getComponent() instanceof SpecialButton || this.formModel.getSummary() == null && e.getComponent() instanceof JRadioButton) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IQuestion currentQuestion;
        if (e.getSource() instanceof SpecialToggleButton) {
            SpecialToggleButton currentButton = (SpecialToggleButton)e.getSource();
            String currentQuestionId = currentButton.getName().replace("exerciseButtonNumber", "");
            IQuestion currentQuestion2 = (IQuestion)this.formModel.getAllQuestionsMap().get(currentQuestionId);
            IQuestion previousQuestion = this.formModel.getCurrentQuestion();
            if (previousQuestion.getQuestionId() != currentQuestion2.getQuestionId()) {
                ((SpecialToggleButton)previousQuestion.getComponent()).getModel().setSelected(false);
                ((SpecialToggleButton)previousQuestion.getComponent()).getModel().setEnabled(true);
            }
            if (currentQuestion2.hasPrevious()) {
                this.previousButton.setVisible(true);
            } else {
                this.previousButton.setVisible(false);
            }
            if (currentQuestion2.hasNext()) {
                this.nextButton.setVisible(true);
            } else {
                this.nextButton.setVisible(false);
            }
            ((SpecialToggleButton)currentQuestion2.getComponent()).setEnabled(false);
            if (currentQuestion2 != null) {
                boolean examFinished;
                ArrayList<String> params;
                this.formModel.setCurrentQuestion(currentQuestion2);
                this.exerciseTitleLabel.setText(currentQuestion2.getTitle());
                String pointsLabel = "";
                if (this.formModel.getSummary() != null) {
                    params = new ArrayList<String>();
                    params.add(String.valueOf(currentQuestion2.getYourScore()));
                    params.add(String.valueOf(currentQuestion2.getScore()));
                    pointsLabel = BundleUtil.getBundle((String)"main.window.exercise.your.score", params);
                } else {
                    params = new ArrayList();
                    params.add(String.valueOf(currentQuestion2.getScore()));
                    pointsLabel = BundleUtil.getBundle((String)"main.window.exercise.score", params);
                }
                this.exercisePointsLabel.setText(pointsLabel);
                this.instructionLabel.setText(currentQuestion2.getManual());
                this.exerciseContentLabel.setIcon(FormulaGenerator.getImageIcon(currentQuestion2.getContent()));
                this.contentCenterCenterExerciseAnswersPanel.setLayout(new BoxLayout(this.contentCenterCenterExerciseAnswersPanel, 3));
                this.contentCenterCenterExerciseAnswersPanel.removeAll();
                ButtonGroup bg = new ButtonGroup();
                IAnswer selectedAnswer = this.formModel.getCurrentQuestion().getSelectedAnswer();
                boolean bl = examFinished = this.formModel.getSummary() != null;
                if (examFinished) {
                    this.correctAnswerButton.setVisible(true);
                }
                this.contentCenterCenterExerciseAnswersPanel.setName(null);
                if (!currentQuestion2.isOpen()) {
                    for (IAnswer answer : this.formModel.getCurrentQuestion().getAnswers()) {
                        JPanel rowPanel = new JPanel();
                        rowPanel.setLayout(new BoxLayout(rowPanel, 2));
                        JPanel leftPanel = new JPanel();
                        leftPanel.setPreferredSize(new Dimension(150, 40));
                        leftPanel.setMaximumSize(new Dimension(150, 40));
                        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
                        JPanel rightPanel = new JPanel();
                        rightPanel.setLayout(new BorderLayout());
                        JRadioButton radio = new JRadioButton();
                        radio.addChangeListener(this);
                        radio.addMouseListener(this);
                        if (examFinished) {
                            if (answer.isCorrect()) {
                                radio.setName("radio_" + answer.getId() + "_green");
                            } else if (!answer.isCorrect() && answer.isSelected()) {
                                radio.setName("radio_" + answer.getId() + "_red");
                            } else {
                                radio.setName("radio_" + answer.getId());
                            }
                        } else {
                            radio.setName("radio_" + answer.getId());
                        }
                        if (selectedAnswer != null && selectedAnswer.getId().equals(answer.getId())) {
                            radio.setSelected(true);
                        }
                        radio.setEnabled(!examFinished);
                        bg.add(radio);
                        SpecialLabel answerLabel = new SpecialLabel();
                        answerLabel.setIconTextGap(0);
                        answerLabel.setIcon(FormulaGenerator.getImageIcon(answer.getContent()));
                        leftPanel.add(Box.createRigidArea(new Dimension(100, 9)));
                        leftPanel.add(radio);
                        rightPanel.add((Component)answerLabel, "Center");
                        rowPanel.add(leftPanel);
                        rowPanel.add(rightPanel);
                        this.contentCenterCenterExerciseAnswersPanel.add(Box.createRigidArea(new Dimension(50, 10)));
                        this.contentCenterCenterExerciseAnswersPanel.add(rowPanel);
                    }
                } else {
                    Font font = new Font("Times New Roman", 0, 19);
                    String imagePath = null;
                    JPanel innerPanel = null;
                    JPanel leftPanel = null;
                    Container rightPanel = null;
                    if (currentQuestion2.isTwoColumns()) {
                        innerPanel = new JPanel();
                        innerPanel.setLayout(new BoxLayout(innerPanel, 2));
                        leftPanel = new JPanel();
                        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
                        rightPanel = new JPanel();
                        rightPanel.setLayout(new BoxLayout(rightPanel, 3));
                    }
                    for (IData oneData : currentQuestion2.getDataList()) {
                        BackgroundImagePanel imagePanel = null;
                        JPanel rowPanel = new JPanel();
                        rowPanel.setLayout(new BoxLayout(rowPanel, 2));
                        rowPanel.add(Box.createRigidArea(new Dimension(oneData.getLeft(), 0)));
                        ArrayList<String> correctValues = new ArrayList<String>();
                        if (oneData.isAlternate() && examFinished) {
                            for (final IElement element : oneData.getDataElements()) {
                                if (!"select".equals(element.getType())) continue;
                                correctValues.add(String.valueOf(element.getCorrectValueIndex()));
                            }
                        }
                        for (final IElement element : oneData.getDataElements()) {
                            if ("text".equals(element.getType()) && element.getValue() != null) {
                                SpecialLabel label = new SpecialLabel();
                                label.setIconTextGap(0);
                                label.setIcon(FormulaGenerator.getImageIcon(element.getValue()));
                                rowPanel.add(label);
                                continue;
                            }
                            if ("select".equals(element.getType())) {
                                if (element.getCombobox() == null) {
                                    Component c;
                                    HashMap<Object, ImageIcon> formulaIcons = new HashMap<Object, ImageIcon>();
                                    JComboBox<Object> combo = new JComboBox<Object>();
                                    combo.setBorder(null);
                                    DefaultListCellRenderer renderer = new DefaultListCellRenderer();
                                    ((JLabel)renderer).setHorizontalAlignment(0);
                                    combo.setRenderer(renderer);
                                    combo.setFont(font);
                                    int comboWidth = element.getWidth() > 0 ? element.getWidth() : 60;
                                    int comboHeight = element.getHeight() > 0 ? element.getHeight() : 25;
                                    combo.setPreferredSize(new Dimension(comboWidth, comboHeight));
                                    combo.setMaximumSize(new Dimension(comboWidth, comboHeight));
                                    combo.setName("combobox");
                                    combo.setMaximumRowCount(5);
                                    combo.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            int index = ((JComboBox)e.getSource()).getSelectedIndex();
                                            element.setSelectedValueIndex(index);
                                        }
                                    });
                                    Accessible popup = combo.getUI().getAccessibleChild(combo, 0);
                                    if (popup != null && (c = ((Container)((Object)popup)).getComponent(0)) != null && c instanceof JScrollPane) {
                                        JScrollPane scrollpane = (JScrollPane)c;
                                        JScrollBar scrollBar = scrollpane.getVerticalScrollBar();
                                        Border emptyBorder = BorderFactory.createEmptyBorder();
                                        scrollpane.setBorder(emptyBorder);
                                        if (scrollpane != null && scrollBar.getPreferredSize() != null) {
                                            Dimension scrollBarDim = new Dimension(25, scrollBar.getPreferredSize().height);
                                            scrollBar.setPreferredSize(scrollBarDim);
                                            scrollBar.setMaximumSize(scrollBarDim);
                                        }
                                    }
                                    for (ValueXml value : element.getValues()) {
                                        if (value.getValue() == null) continue;
                                        if (value.isFormula()) {
                                            formulaIcons.put(value.getValue(), FormulaGenerator.getImageIcon(value.getValue()));
                                        }
                                        combo.addItem(value.getValue());
                                    }
                                    combo.setSelectedIndex(element.getSelectedValueIndex());
                                    if (!formulaIcons.isEmpty()) {
                                        combo.setRenderer(new IconListRenderer(formulaIcons));
                                    }
                                    element.setCombobox(combo);
                                }
                                if (examFinished) {
                                    element.getCombobox().setEnabled(false);
                                    if (oneData.isAlternate()) {
                                        if (QuestionUtils.isAnswerCorrect((IElement)element, correctValues)) {
                                            element.getCombobox().setBorder(BorderFactory.createLineBorder(Color.decode("#00ff00"), 2));
                                        } else {
                                            element.getCombobox().setBorder(BorderFactory.createLineBorder(Color.decode("#ff0000"), 2));
                                        }
                                    } else if (element.getCorrectValueIndex() == element.getSelectedValueIndex()) {
                                        element.getCombobox().setBorder(BorderFactory.createLineBorder(Color.decode("#00ff00"), 2));
                                    } else {
                                        element.getCombobox().setBorder(BorderFactory.createLineBorder(Color.decode("#ff0000"), 2));
                                    }
                                }
                                rowPanel.add(element.getCombobox());
                                continue;
                            }
                            if (!"image".equals(element.getType())) continue;
                            imagePath = element.getValue();
                            imagePanel = new BackgroundImagePanel(imagePath);
                            imagePanel.setPreferredSize(new Dimension(oneData.getWidth(), oneData.getHeight()));
                        }
                        if (!oneData.isCenter()) {
                            rowPanel.add(Box.createHorizontalGlue());
                        }
                        if (currentQuestion2.isTwoColumns()) {
                            if ("left".equals(oneData.getSide())) {
                                leftPanel.add(Box.createHorizontalGlue());
                                leftPanel.add(Box.createRigidArea(new Dimension(0, 20)));
                                if (imagePanel != null) {
                                    rowPanel.add(imagePanel);
                                }
                                leftPanel.add(rowPanel);
                                continue;
                            }
                            rightPanel.add(Box.createHorizontalGlue());
                            rightPanel.add(Box.createRigidArea(new Dimension(0, 20)));
                            if (imagePanel != null) {
                                rowPanel.add(imagePanel);
                            }
                            rightPanel.add(rowPanel);
                            continue;
                        }
                        this.contentCenterCenterExerciseAnswersPanel.add(Box.createHorizontalGlue());
                        this.contentCenterCenterExerciseAnswersPanel.add(Box.createRigidArea(new Dimension(0, 20)));
                        this.contentCenterCenterExerciseAnswersPanel.add(rowPanel);
                    }
                    if (innerPanel != null && leftPanel != null && rightPanel != null) {
                        rightPanel.add(Box.createVerticalGlue());
                        leftPanel.add(Box.createVerticalGlue());
                        innerPanel.add(leftPanel);
                        innerPanel.add(Box.createHorizontalGlue());
                        innerPanel.add(rightPanel);
                        this.contentCenterCenterExerciseAnswersPanel.add(innerPanel);
                    }
                }
            }
        }
        if ("finishProgramButtonAction".equals(e.getActionCommand())) {
            if (this.mainFrame.isStartScreen()) {
                if (this.yesNoDialogProgram1 == null) {
                    this.yesNoDialogProgram1 = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_PROGRAM);
                }
                this.yesNoDialogProgram1.setVisible(true);
            } else {
                if (this.yesNoDialogProgram2 == null) {
                    this.yesNoDialogProgram2 = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_PROGRAM);
                }
                this.yesNoDialogProgram2.setVisible(true);
            }
        } else if ("finishExamButtonAction".equals(e.getActionCommand())) {
            if (this.yesNoDialogExam == null) {
                this.yesNoDialogExam = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_EXAM);
            }
            this.yesNoDialogExam.setVisible(true);
        } else if ("nextButtonAction".equals(e.getActionCommand())) {
            currentQuestion = this.formModel.getCurrentQuestion();
            if (currentQuestion.hasNext()) {
                if (!currentQuestion.getNext().hasNext()) {
                    this.nextButton.setVisible(false);
                } else {
                    this.nextButton.setVisible(true);
                }
                this.previousButton.setVisible(true);
                ((SpecialToggleButton)currentQuestion.getNext().getComponent()).doClick();
            }
        } else if ("previousButtonAction".equals(e.getActionCommand())) {
            currentQuestion = this.formModel.getCurrentQuestion();
            if (currentQuestion.hasPrevious()) {
                if (!currentQuestion.getPrevious().hasPrevious()) {
                    this.previousButton.setVisible(false);
                } else {
                    this.previousButton.setVisible(true);
                }
                this.nextButton.setVisible(true);
                ((SpecialToggleButton)currentQuestion.getPrevious().getComponent()).doClick();
            }
        } else if ("summaryButtonAction".equals(e.getActionCommand())) {
            if (this.summaryDialog == null) {
                this.summaryDialog = new SummaryDialog(this.mainFrame);
            }
            this.summaryDialog.setVisible(true);
        } else if ("correctAnswerButtonAction".equals(e.getActionCommand())) {
            int dialogIndex = this.formModel.getCurrentQuestion().getQuestionId() - 1;
            if (this.correctAnswerDialog[dialogIndex] == null) {
                this.correctAnswerDialog[dialogIndex] = new CorrectAnswerDialog(this.mainFrame);
            }
            this.correctAnswerDialog[dialogIndex].setVisible(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JRadioButton currentRadio;
        if (e.getSource() instanceof JRadioButton && (currentRadio = (JRadioButton)e.getSource()).isSelected()) {
            String radioId = currentRadio.getName().split("_")[1];
            this.formModel.getCurrentQuestion().selectAnswer(radioId);
        }
    }

    public SpecialButton getFinishExamButton() {
        return this.finishExamButton;
    }

    public void setFinishExamButton(SpecialButton finishExamButton) {
        this.finishExamButton = finishExamButton;
    }

    public SpecialButton getSummaryButton() {
        return this.summaryButton;
    }

    public void setSummaryButton(SpecialButton summaryButton) {
        this.summaryButton = summaryButton;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.requestFocus();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.mainFrame.isStartScreen()) {
            if (this.yesNoDialogProgram1 == null) {
                this.yesNoDialogProgram1 = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_PROGRAM);
            }
            this.yesNoDialogProgram1.setVisible(true);
        } else {
            if (this.yesNoDialogProgram2 == null) {
                this.yesNoDialogProgram2 = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_PROGRAM);
            }
            this.yesNoDialogProgram2.setVisible(true);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public SpecialButton getCorrectAnswerButton() {
        return this.correctAnswerButton;
    }

    public void setCorrectAnswerButton(SpecialButton correctAnswerButton) {
        this.correctAnswerButton = correctAnswerButton;
    }

    public YesNoDialog getYesNoDialogExam() {
        return this.yesNoDialogExam;
    }

    public void setYesNoDialogExam(YesNoDialog yesNoDialogExam) {
        this.yesNoDialogExam = yesNoDialogExam;
    }

    public SummaryDialog getSummaryDialog() {
        return this.summaryDialog;
    }

    public void setSummaryDialog(SummaryDialog summaryDialog) {
        this.summaryDialog = summaryDialog;
    }

    public CorrectAnswerDialog[] getCorrectAnswerDialog() {
        return this.correctAnswerDialog;
    }

    public void setCorrectAnswerDialog(CorrectAnswerDialog[] correctAnswerDialog) {
        this.correctAnswerDialog = correctAnswerDialog;
    }

    public YesNoDialog getYesNoDialogProgram1() {
        return this.yesNoDialogProgram1;
    }

    public void setYesNoDialogProgram1(YesNoDialog yesNoDialogProgram1) {
        this.yesNoDialogProgram1 = yesNoDialogProgram1;
    }

    public YesNoDialog getYesNoDialogProgram2() {
        return this.yesNoDialogProgram2;
    }

    public void setYesNoDialogProgram2(YesNoDialog yesNoDialogProgram2) {
        this.yesNoDialogProgram2 = yesNoDialogProgram2;
    }
}

