/*
 * Decompiled with CFR 0.152.
 */
package com.matura.forms.timer;

import com.matura.forms.dialogs.MainFrame;
import com.matura.forms.utils.QuestionFormUtils;
import com.matura.impl.utils.TimeCalculator;

public class Timer
extends Thread {
    private long time;
    private boolean active = true;
    private MainFrame mainFrame;

    public Timer(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public Timer(MainFrame mainFrame, long time) {
        this.mainFrame = mainFrame;
        this.time = time;
    }

    @Override
    public void run() {
        while (this.active) {
            this.calculateTime();
        }
    }

    private void calculateTime() {
        String stringTime = TimeCalculator.timeCalculate((long)this.time);
        try {
            this.mainFrame.getTimerLabel().setText(stringTime);
            if (this.time == 0L) {
                this.stopTimer();
                QuestionFormUtils.finishExam(this.mainFrame, null);
                return;
            }
            Timer.sleep(1000L);
            this.time -= 1000L;
        }
        catch (InterruptedException e) {
            System.err.println("error");
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void stopTimer() {
        this.active = false;
    }

    public void resetTimer() {
        this.time = 0L;
    }

    public void incrementTime(int inc) {
        this.time += (long)inc;
    }

    public void startTimer() {
        this.active = true;
    }
}

