/*
 * Decompiled with CFR 0.152.
 */
package com.matura.impl.data;

import com.matura.api.data.ISummaryPreparation;
import com.matura.api.form.model.IAnswer;
import com.matura.api.form.model.IData;
import com.matura.api.form.model.IElement;
import com.matura.api.form.model.IQuestion;
import com.matura.api.form.model.ISummary;
import com.matura.impl.form.model.Summary;
import com.matura.impl.utils.QuestionUtils;
import java.util.List;
import java.util.Map;

public class SummaryPreparation
implements ISummaryPreparation {
    public ISummary prepareSummary(List<IQuestion> questions, long time) {
        int yourScore = 0;
        int maxScore = 0;
        if (questions != null) {
            for (IQuestion question : questions) {
                if (question.isOpen()) {
                    int questionScore = 0;
                    for (IData data : question.getDataList()) {
                        if (question.isHybrid() && question.getSelectedDataAnswer() != null && question.getSelectedDataAnswer().isCorrect()) {
                            questionScore += data.getScore();
                        }
                        Map<String, List<IElement>> groups = QuestionUtils.prepareGrouppedElementsMap(data.getDataElements());
                        for (IElement element : data.getDataElements()) {
                            if (!"select".equals(element.getType()) || element.getGroup() != null && groups.get(element.getGroup()) != null || element.isAlternate() && (!element.isAlternate() || groups.get("alternate") == null || !QuestionUtils.isInGroupAlternateAnswerCorrect(element, groups.get("alternate"))) || element.getCorrectValueIndex() != element.getSelectedValueIndex()) continue;
                            if (groups.get("alternate") != null && groups.get("alternate").isEmpty()) {
                                groups.remove("alternate");
                            }
                            questionScore += element.getScore();
                        }
                        if ((!question.isHybrid() || question.getSelectedDataAnswer() == null || !question.getSelectedDataAnswer().isCorrect()) && question.isHybrid()) continue;
                        questionScore += QuestionUtils.calculatePointsFoGroups(groups);
                    }
                    question.setYourScore(questionScore);
                    yourScore += questionScore;
                } else {
                    IAnswer correctAnswer = question.getCorrectAnswer();
                    if (question != null && correctAnswer != null && correctAnswer.isSelected()) {
                        question.setYourScore(question.getScore());
                        yourScore += question.getScore();
                    }
                }
                maxScore += question.getScore();
            }
        }
        Summary summary = new Summary();
        summary.setYourScore(yourScore);
        summary.setMaxScore(maxScore);
        summary.setTimeLeft(time);
        return summary;
    }
}

