/*
 * Decompiled with CFR 0.152.
 */
package com.matura.impl.form.model;

import com.matura.api.form.model.IAnswer;
import com.matura.api.form.model.IData;
import com.matura.api.form.model.IQuestion;
import com.matura.api.form.model.ISpecialComponent;
import com.matura.api.xml.model.QuestionXml;
import java.util.ArrayList;
import java.util.List;

public class Question
extends QuestionXml
implements IQuestion {
    private String title;
    private String content;
    private int score;
    private int yourScore;
    private String version;
    private String manual;
    private IQuestion next;
    private IQuestion previous;
    private ISpecialComponent component;
    private boolean twoColumns;
    private List<IAnswer> answers = new ArrayList<IAnswer>();
    private List<IData> dataList = new ArrayList<IData>();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public List<IAnswer> getAnswers() {
        return this.answers;
    }

    public void setAnswers(List<IAnswer> answers) {
        this.answers = answers;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public IAnswer getCorrectAnswer() {
        if (this.answers != null) {
            for (IAnswer answer : this.answers) {
                if (answer == null || !answer.isCorrect()) continue;
                return answer;
            }
        }
        return null;
    }

    public IAnswer getSelectedAnswer() {
        if (this.answers != null) {
            for (IAnswer answer : this.answers) {
                if (answer == null || !answer.isSelected()) continue;
                return answer;
            }
        }
        return null;
    }

    public IData getSelectedDataAnswer() {
        if (this.dataList != null) {
            for (IData data : this.dataList) {
                if (data == null || !data.isSelected()) continue;
                return data;
            }
        }
        return null;
    }

    public void selectAnswer(String selected) {
        if (selected != null) {
            for (IAnswer answer : this.answers) {
                if (selected.equals(answer.getId())) {
                    answer.setSelected(true);
                    continue;
                }
                answer.setSelected(false);
            }
        }
    }

    public void selectDataAnswer(String selected) {
        if (selected != null) {
            for (IData data : this.dataList) {
                if (selected.equals(data.getId())) {
                    data.setSelected(true);
                    continue;
                }
                data.setSelected(false);
            }
        }
    }

    public String getManual() {
        return this.manual != null ? this.manual : "";
    }

    public void setManual(String manual) {
        this.manual = manual;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public void setNext(IQuestion question) {
        this.next = question;
    }

    public IQuestion getNext() {
        return this.next;
    }

    public void setPrevious(IQuestion question) {
        this.previous = question;
    }

    public IQuestion getPrevious() {
        return this.previous;
    }

    public int getQuestionId() {
        return Integer.parseInt(this.getId());
    }

    public void setComponent(ISpecialComponent component) {
        this.component = component;
    }

    public ISpecialComponent getComponent() {
        return this.component;
    }

    public int getYourScore() {
        return this.yourScore;
    }

    public void setYourScore(int score) {
        this.yourScore = score;
    }

    public void setDataList(List<IData> data) {
        this.dataList = data;
    }

    public List<IData> getDataList() {
        return this.dataList;
    }

    public boolean isTwoColumns() {
        return this.twoColumns;
    }

    public void setTwoColumns(boolean twoColumns) {
        this.twoColumns = twoColumns;
    }
}

