/*
 * Decompiled with CFR 0.152.
 */
package com.matura.forms.utils;

import com.matura.forms.utils.SpecialLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.jlatexmath.cyrillic.CyrillicRegistration;
import org.scilab.forge.jlatexmath.greek.GreekRegistration;

public class FormulaGenerator {
    public static BufferedImage generateFormula(String content) {
        TeXFormula formule = new TeXFormula(content);
        TeXIcon ti = formule.createTeXIcon(0, 20.0f, 0, Color.BLACK);
        ti.setInsets(new Insets(0, 0, 0, 0), true);
        BufferedImage b = new BufferedImage(ti.getIconWidth(), ti.getIconHeight(), 6);
        ti.paintIcon((Component)new SpecialLabel(), b.getGraphics(), 0, 0);
        return b;
    }

    public static ImageIcon getImageIcon(String content) {
        BufferedImage bi = FormulaGenerator.generateFormula(content);
        return new ImageIcon(bi);
    }

    public static void prepareFormulaEnvironment() {
        DefaultTeXFont.registerAlphabet((AlphabetRegistration)new CyrillicRegistration());
        DefaultTeXFont.registerAlphabet((AlphabetRegistration)new GreekRegistration());
        TeXFormula.registerExternalFont((Character.UnicodeBlock)Character.UnicodeBlock.BASIC_LATIN, (String)"Times New Roman");
        TeXFormula.registerExternalFont((Character.UnicodeBlock)Character.UnicodeBlock.of('\u0142'), (String)"Times New Roman");
        TeXFormula.registerExternalFont((Character.UnicodeBlock)Character.UnicodeBlock.of('\u0141'), (String)"Times New Roman");
    }
}

