/*
 * Decompiled with CFR 0.152.
 */
package com.matura.forms.utils;

import com.matura.api.form.model.IAnswer;
import com.matura.api.form.model.IData;
import com.matura.api.form.model.IElement;
import com.matura.api.form.model.IQuestion;
import com.matura.api.form.model.ISummary;
import com.matura.api.xml.model.ValueXml;
import com.matura.forms.actions.WindowEvents;
import com.matura.forms.actions.YesNoDialogEvents;
import com.matura.forms.dialogs.MainFrame;
import com.matura.forms.utils.BackgroundImagePanel;
import com.matura.forms.utils.FormulaGenerator;
import com.matura.forms.utils.IconListRenderer;
import com.matura.forms.utils.SpecialLabel;
import com.matura.forms.utils.SpecialToggleButton;
import com.matura.impl.data.SummaryPreparation;
import com.matura.impl.utils.QuestionUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class QuestionFormUtils
extends WindowEvents {
    private static final long serialVersionUID = 1L;

    public static void finishExam(MainFrame mainFrame, YesNoDialogEvents child) {
        mainFrame.getTimer().stopTimer();
        SummaryPreparation sp = new SummaryPreparation();
        ISummary summary = sp.prepareSummary(mainFrame.getFormModel().getAllQuestions(), mainFrame.getTimer().getTime());
        mainFrame.getFormModel().setSummary(summary);
        ((SpecialToggleButton)mainFrame.getFormModel().getCurrentQuestion().getComponent()).setEnabled(true);
        ((SpecialToggleButton)mainFrame.getFormModel().getCurrentQuestion().getComponent()).doClick();
        ((SpecialToggleButton)mainFrame.getFormModel().getCurrentQuestion().getComponent()).setEnabled(false);
        ((SpecialToggleButton)mainFrame.getFormModel().getCurrentQuestion().getComponent()).setSelected(true);
        mainFrame.getFinishExamButton().setVisible(false);
        if (child != null) {
            child.dispose();
        }
        mainFrame.getSummaryButton().setVisible(true);
        mainFrame.getSummaryButton().getModel().setRollover(true);
        mainFrame.getSummaryButton().doClick();
    }

    public static void preparePanelForOpenQuestion(final IQuestion currentQuestion, IData selectedAnswer, boolean examFinished, WindowEvents frame, JPanel preparedPanel) {
        Font font = new Font("Times New Roman", 0, 19);
        String imagePath = null;
        JPanel innerPanel = null;
        JPanel leftPanel = null;
        Container rightPanel = null;
        ButtonGroup bg = null;
        JPanel leftInnerPanel = null;
        JPanel rightInnerPanel = null;
        if (currentQuestion.isTwoColumns()) {
            innerPanel = new JPanel();
            innerPanel.setLayout(new BoxLayout(innerPanel, 2));
            leftPanel = new JPanel();
            leftPanel.setLayout(new BoxLayout(leftPanel, 3));
            rightPanel = new JPanel();
            rightPanel.setLayout(new BoxLayout(rightPanel, 3));
        }
        if (currentQuestion.isHybrid()) {
            bg = new ButtonGroup();
        }
        for (final IData oneData : currentQuestion.getDataList()) {
            BackgroundImagePanel imagePanel = null;
            JPanel rowPanel = new JPanel();
            rowPanel.setLayout(new BoxLayout(rowPanel, 2));
            rowPanel.add(Box.createRigidArea(new Dimension(oneData.getLeft(), 0)));
            if (currentQuestion.isHybrid()) {
                leftInnerPanel = new JPanel();
                leftInnerPanel.setPreferredSize(new Dimension(150, 40));
                leftInnerPanel.setMaximumSize(new Dimension(150, 40));
                leftInnerPanel.setLayout(new BoxLayout(leftInnerPanel, 2));
                rightInnerPanel = new JPanel();
                rightInnerPanel.setLayout(new BoxLayout(rightInnerPanel, 2));
                if (oneData.getRadio() == null) {
                    JRadioButton radio = new JRadioButton();
                    radio.addChangeListener(frame);
                    radio.addMouseListener(frame);
                    oneData.setRadio(radio);
                }
                if (examFinished) {
                    if (oneData.isCorrect()) {
                        oneData.getRadio().setName("radio_" + oneData.getId() + "_green");
                    } else if (!oneData.isCorrect() && oneData.isSelected()) {
                        oneData.getRadio().setName("radio_" + oneData.getId() + "_red");
                    } else {
                        oneData.getRadio().setName("radio_" + oneData.getId());
                    }
                } else {
                    oneData.getRadio().setName("radio_" + oneData.getId());
                }
                if (selectedAnswer != null && selectedAnswer.getId().equals(oneData.getId())) {
                    oneData.getRadio().setSelected(true);
                }
                oneData.getRadio().setEnabled(!examFinished);
                bg.add(oneData.getRadio());
                leftInnerPanel.add(Box.createRigidArea(new Dimension(100, 9)));
                leftInnerPanel.add(oneData.getRadio());
                rowPanel.add(leftInnerPanel);
            }
            Map groups = examFinished ? QuestionUtils.prepareGrouppedElementsMap((List)oneData.getDataElements()) : null;
            for (final IElement element : oneData.getDataElements()) {
                if ("text".equals(element.getType()) && element.getValue() != null) {
                    SpecialLabel label = new SpecialLabel();
                    label.setIconTextGap(0);
                    label.setIcon(FormulaGenerator.getImageIcon(element.getValue()));
                    if (currentQuestion.isHybrid()) {
                        rightInnerPanel.add(label);
                        rowPanel.add(rightInnerPanel);
                        continue;
                    }
                    rowPanel.add(label);
                    continue;
                }
                if ("select".equals(element.getType())) {
                    if (element.getCombobox() == null) {
                        Component c;
                        HashMap<Object, ImageIcon> formulaIcons = new HashMap<Object, ImageIcon>();
                        JComboBox<Object> combo = new JComboBox<Object>();
                        combo.setBorder(null);
                        DefaultListCellRenderer renderer = new DefaultListCellRenderer();
                        ((JLabel)renderer).setHorizontalAlignment(0);
                        combo.setRenderer(renderer);
                        combo.setFont(font);
                        int comboWidth = element.getWidth() > 0 ? element.getWidth() : 60;
                        int comboHeight = element.getHeight() > 0 ? element.getHeight() : 25;
                        combo.setPreferredSize(new Dimension(comboWidth, comboHeight));
                        combo.setMaximumSize(new Dimension(comboWidth, comboHeight));
                        combo.setName("combobox");
                        combo.setMaximumRowCount(5);
                        Accessible popup = combo.getUI().getAccessibleChild(combo, 0);
                        if (popup != null && (c = ((Container)((Object)popup)).getComponent(0)) != null && c instanceof JScrollPane) {
                            JScrollPane scrollpane = (JScrollPane)c;
                            JScrollBar scrollBar = scrollpane.getVerticalScrollBar();
                            Border emptyBorder = BorderFactory.createEmptyBorder();
                            scrollpane.setBorder(emptyBorder);
                            if (scrollpane != null && scrollBar.getPreferredSize() != null) {
                                Dimension scrollBarDim = new Dimension(25, scrollBar.getPreferredSize().height);
                                scrollBar.setPreferredSize(scrollBarDim);
                                scrollBar.setMaximumSize(scrollBarDim);
                            }
                        }
                        for (ValueXml value : element.getValues()) {
                            if (value.getValue() == null) continue;
                            if (value.isFormula()) {
                                formulaIcons.put(value.getValue(), FormulaGenerator.getImageIcon(value.getValue()));
                            }
                            combo.addItem(value.getValue());
                        }
                        combo.setSelectedIndex(element.getSelectedValueIndex());
                        if (!formulaIcons.isEmpty()) {
                            combo.setRenderer(new IconListRenderer(formulaIcons));
                        }
                        combo.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                int index = ((JComboBox)e.getSource()).getSelectedIndex();
                                element.setSelectedValueIndex(index);
                                if (currentQuestion.isHybrid()) {
                                    oneData.getRadio().setSelected(true);
                                }
                            }
                        });
                        element.setCombobox(combo);
                    }
                    if (examFinished) {
                        element.getCombobox().setEnabled(false);
                        if (!currentQuestion.isHybrid() || currentQuestion.isHybrid() && selectedAnswer != null && selectedAnswer.getId().equals(oneData.getId())) {
                            if (!element.isAlternate() && element.getCorrectValueIndex() == element.getSelectedValueIndex() || element.isAlternate() && QuestionUtils.isInGroupAlternateAnswerCorrect((IElement)element, (List)((List)groups.get(element.getGroup())))) {
                                element.getCombobox().setBorder(BorderFactory.createLineBorder(Color.decode("#00ff00"), 2));
                            } else {
                                element.getCombobox().setBorder(BorderFactory.createLineBorder(Color.decode("#ff0000"), 2));
                            }
                        }
                    }
                    if (currentQuestion.isHybrid()) {
                        if (element.getLeft() > 0) {
                            rightInnerPanel.add(Box.createRigidArea(new Dimension(element.getLeft(), 0)));
                        }
                        rightInnerPanel.add(element.getCombobox());
                        rowPanel.add(rightInnerPanel);
                        continue;
                    }
                    if (element.getLeft() > 0) {
                        rowPanel.add(Box.createRigidArea(new Dimension(element.getLeft(), 0)));
                    }
                    if (element.getTop() > 0) {
                        rowPanel.add(Box.createRigidArea(new Dimension(0, element.getTop())));
                    }
                    if (element.getBottom() > 0 || element.getTop() > 0) {
                        JPanel comboPanel = new JPanel();
                        comboPanel.setLayout(new BoxLayout(comboPanel, 3));
                        comboPanel.setMaximumSize(new Dimension((int)element.getCombobox().getPreferredSize().getWidth(), (int)rowPanel.getPreferredSize().getHeight() + (element.getTop() > 0 ? element.getTop() : element.getBottom())));
                        if (element.getTop() > 0) {
                            comboPanel.add(Box.createRigidArea(new Dimension(0, element.getTop())));
                            comboPanel.add(element.getCombobox());
                            comboPanel.add(Box.createVerticalGlue());
                        } else if (element.getBottom() > 0) {
                            comboPanel.add(Box.createVerticalGlue());
                            comboPanel.add(element.getCombobox());
                            comboPanel.add(Box.createRigidArea(new Dimension(0, element.getBottom())));
                        }
                        rowPanel.add(comboPanel);
                        continue;
                    }
                    rowPanel.add(element.getCombobox());
                    continue;
                }
                if (!"image".equals(element.getType())) continue;
                imagePath = element.getValue();
                imagePanel = new BackgroundImagePanel(imagePath);
                imagePanel.setPreferredSize(new Dimension(oneData.getWidth(), oneData.getHeight()));
                if (currentQuestion.isTwoColumns()) continue;
                if (oneData.isCenter()) {
                    rowPanel.add(Box.createHorizontalGlue());
                }
                rowPanel.add(imagePanel);
            }
            if (!oneData.isCenter()) {
                rowPanel.add(Box.createHorizontalGlue());
            }
            if (currentQuestion.isTwoColumns()) {
                if ("left".equals(oneData.getSide())) {
                    leftPanel.add(Box.createHorizontalGlue());
                    leftPanel.add(Box.createRigidArea(new Dimension(0, 20)));
                    if (imagePanel != null) {
                        rowPanel.add(imagePanel);
                    }
                    leftPanel.add(rowPanel);
                    if (oneData.getBottom() <= 0) continue;
                    leftPanel.add(Box.createRigidArea(new Dimension(0, oneData.getBottom())));
                    continue;
                }
                rightPanel.add(Box.createHorizontalGlue());
                rightPanel.add(Box.createRigidArea(new Dimension(0, 20)));
                if (imagePanel != null) {
                    rowPanel.add(imagePanel);
                }
                rightPanel.add(rowPanel);
                if (oneData.getBottom() <= 0) continue;
                rightPanel.add(Box.createRigidArea(new Dimension(0, oneData.getBottom())));
                continue;
            }
            preparedPanel.add(Box.createHorizontalGlue());
            preparedPanel.add(Box.createRigidArea(new Dimension(0, 20)));
            preparedPanel.add(rowPanel);
            if (oneData.getBottom() <= 0) continue;
            preparedPanel.add(Box.createRigidArea(new Dimension(0, oneData.getBottom())));
        }
        if (innerPanel != null && leftPanel != null && rightPanel != null) {
            rightPanel.add(Box.createVerticalGlue());
            leftPanel.add(Box.createVerticalGlue());
            innerPanel.add(leftPanel);
            innerPanel.add(Box.createHorizontalGlue());
            innerPanel.add(rightPanel);
            preparedPanel.add(innerPanel);
        }
    }

    public static void preparePanelForCloseQuestion(IQuestion currentQuestion, IAnswer selectedAnswer, boolean examFinished, WindowEvents frame, JPanel preparedPanel) {
        ButtonGroup bg = new ButtonGroup();
        for (IAnswer answer : currentQuestion.getAnswers()) {
            JPanel rowPanel = new JPanel();
            rowPanel.setLayout(new BoxLayout(rowPanel, 2));
            JPanel leftPanel = new JPanel();
            leftPanel.setPreferredSize(new Dimension(150, 40));
            leftPanel.setMaximumSize(new Dimension(150, 40));
            leftPanel.setLayout(new BoxLayout(leftPanel, 3));
            JPanel rightPanel = new JPanel();
            rightPanel.setLayout(new BorderLayout());
            JRadioButton radio = new JRadioButton();
            radio.addChangeListener(frame);
            radio.addMouseListener(frame);
            if (examFinished) {
                if (answer.isCorrect()) {
                    radio.setName("radio_" + answer.getId() + "_green");
                } else if (!answer.isCorrect() && answer.isSelected()) {
                    radio.setName("radio_" + answer.getId() + "_red");
                } else {
                    radio.setName("radio_" + answer.getId());
                }
            } else {
                radio.setName("radio_" + answer.getId());
            }
            if (selectedAnswer != null && selectedAnswer.getId().equals(answer.getId())) {
                radio.setSelected(true);
            }
            radio.setEnabled(!examFinished);
            bg.add(radio);
            SpecialLabel answerLabel = new SpecialLabel();
            answerLabel.setIconTextGap(0);
            answerLabel.setIcon(FormulaGenerator.getImageIcon(answer.getContent()));
            leftPanel.add(Box.createRigidArea(new Dimension(100, 9)));
            leftPanel.add(radio);
            rightPanel.add((Component)answerLabel, "Center");
            rowPanel.add(leftPanel);
            rowPanel.add(rightPanel);
            preparedPanel.add(Box.createRigidArea(new Dimension(50, 10)));
            preparedPanel.add(rowPanel);
        }
    }
}

