/*
 * Decompiled with CFR 0.152.
 */
package com.matura.forms.dialogs;

import com.matura.api.form.model.IQuestion;
import com.matura.forms.actions.SummaryDialogEvents;
import com.matura.forms.dialogs.MainFrame;
import com.matura.forms.utils.SpecialButton;
import com.matura.forms.utils.SpecialLabel;
import com.matura.impl.utils.BundleUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class SummaryDialog
extends SummaryDialogEvents {
    private static final long serialVersionUID = 1L;

    public SummaryDialog(MainFrame mainFrame) {
        super(mainFrame);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(screenSize.width / 2 - 320, screenSize.height / 2 - 240, 640, 480);
        JPanel mainPanel = new JPanel();
        mainPanel.setName("summaryMainPanel");
        mainPanel.setSize(this.getSize());
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        JPanel headPanel = new JPanel();
        headPanel.setLayout(new BorderLayout());
        headPanel.setPreferredSize(new Dimension(this.getSize().width, 80));
        headPanel.setMinimumSize(new Dimension(this.getSize().width, 80));
        headPanel.setMaximumSize(new Dimension(this.getSize().width, 80));
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(mainFrame.getFormModel().getSummary().getYourScore());
        params.add(mainFrame.getFormModel().getSummary().getYourScoreInPercentagesFormat());
        SpecialLabel score = new SpecialLabel(BundleUtil.getBundle((String)"summary.window.score", params));
        score.setPreferredSize(new Dimension(this.getSize().width, 50));
        score.setName("summaryScoreLabel");
        score.setHorizontalAlignment(0);
        headPanel.add((Component)score, "South");
        mainPanel.add(headPanel);
        JPanel centerPanel = new JPanel();
        centerPanel.setPreferredSize(new Dimension(this.getSize().width - 140, this.getSize().height - 120));
        centerPanel.setMaximumSize(new Dimension(this.getSize().width - 140, this.getSize().height - 120));
        centerPanel.setLayout(new GridLayout(1, 4));
        Font resultFont = new Font("Sans Serif", 0, 16);
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            JPanel colGridPanel = new JPanel();
            colGridPanel.setLayout(new GridLayout(5, 1));
            do {
                IQuestion currentQuestion;
                if ((currentQuestion = (IQuestion)mainFrame.getFormModel().getAllQuestionsMap().get(String.valueOf(index + 1))) == null) {
                    ++index;
                    continue;
                }
                JPanel labelPanel = new JPanel();
                labelPanel.setLayout(new BoxLayout(labelPanel, 2));
                SpecialLabel numberLabel = new SpecialLabel(String.valueOf(index + 1) + ".");
                numberLabel.setName("summaryScoreList");
                numberLabel.setPreferredSize(new Dimension(25, 20));
                numberLabel.setMinimumSize(new Dimension(25, 20));
                numberLabel.setMaximumSize(new Dimension(25, 20));
                ArrayList<Integer> param = new ArrayList<Integer>();
                param.add(currentQuestion.getYourScore());
                SpecialLabel scoreLabel = new SpecialLabel(BundleUtil.getBundle((String)"summary.window.score.points", param));
                scoreLabel.setName("summaryScoreList");
                scoreLabel.setPreferredSize(new Dimension(50, 20));
                scoreLabel.setMinimumSize(new Dimension(50, 20));
                scoreLabel.setMaximumSize(new Dimension(50, 20));
                SpecialLabel resultLabel = new SpecialLabel();
                resultLabel.setFont(resultFont);
                Color resultColor = null;
                String resultChar = null;
                if (currentQuestion.getYourScore() == 0) {
                    resultChar = "\u2716";
                    resultColor = Color.RED;
                } else if (currentQuestion.getYourScore() == currentQuestion.getScore()) {
                    resultChar = "\u2714";
                    resultColor = Color.GREEN;
                } else {
                    resultChar = "<html><font color=\"#00ff00>\">\u2714</font>/<font color=\"#ff0000>\">\u2716</font>";
                    resultColor = Color.WHITE;
                }
                resultLabel.setText(resultChar);
                resultLabel.setForeground(resultColor);
                resultLabel.setName("summaryResultList");
                labelPanel.add(numberLabel);
                labelPanel.add(scoreLabel);
                labelPanel.add(resultLabel);
                colGridPanel.add(labelPanel);
                ++index;
            } while ((index + 1) % 5 != 1 && index != 15);
            centerPanel.add(colGridPanel);
        }
        mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        mainPanel.add(centerPanel);
        JPanel footerPanel = new JPanel();
        footerPanel.setPreferredSize(new Dimension(this.getSize().width, 80));
        footerPanel.setMinimumSize(new Dimension(this.getSize().width, 80));
        footerPanel.setMaximumSize(new Dimension(this.getSize().width, 80));
        SpecialButton closeButton = new SpecialButton(BundleUtil.getBundle((String)"close.window.button.label"));
        closeButton.setName("closeWindowButton");
        closeButton.setPreferredSize(new Dimension(157, 37));
        closeButton.setMaximumSize(new Dimension(157, 37));
        closeButton.setActionCommand("closeWindowButtonAction");
        closeButton.addMouseListener(this);
        closeButton.addActionListener(this);
        footerPanel.add(closeButton);
        mainPanel.add(footerPanel);
        this.getContentPane().add(mainPanel);
        this.addWindowListener(this);
        this.addMouseListener(this);
        this.setDefaultCloseOperation(0);
        this.setUndecorated(true);
        this.setModal(true);
        this.setAlwaysOnTop(true);
    }
}

