/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.jaxp;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xalan.internal.utils.FactoryImpl;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.jaxp.JAXPExtensionsProvider;
import com.sun.org.apache.xpath.internal.jaxp.JAXPPrefixResolver;
import com.sun.org.apache.xpath.internal.jaxp.JAXPVariableStack;
import com.sun.org.apache.xpath.internal.jaxp.XPathExpressionImpl;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathImpl
implements javax.xml.xpath.XPath {
    private XPathVariableResolver variableResolver;
    private XPathFunctionResolver functionResolver;
    private XPathVariableResolver origVariableResolver;
    private XPathFunctionResolver origFunctionResolver;
    private NamespaceContext namespaceContext = null;
    private JAXPPrefixResolver prefixResolver;
    private boolean featureSecureProcessing = false;
    private boolean useServiceMechanism = true;
    private static Document d = null;

    XPathImpl(XPathVariableResolver xPathVariableResolver, XPathFunctionResolver xPathFunctionResolver) {
        this.origVariableResolver = this.variableResolver = xPathVariableResolver;
        this.origFunctionResolver = this.functionResolver = xPathFunctionResolver;
    }

    XPathImpl(XPathVariableResolver xPathVariableResolver, XPathFunctionResolver xPathFunctionResolver, boolean bl, boolean bl2) {
        this.origVariableResolver = this.variableResolver = xPathVariableResolver;
        this.origFunctionResolver = this.functionResolver = xPathFunctionResolver;
        this.featureSecureProcessing = bl;
        this.useServiceMechanism = bl2;
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        if (xPathVariableResolver == null) {
            String string = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPathVariableResolver"});
            throw new NullPointerException(string);
        }
        this.variableResolver = xPathVariableResolver;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.variableResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (xPathFunctionResolver == null) {
            String string = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPathFunctionResolver"});
            throw new NullPointerException(string);
        }
        this.functionResolver = xPathFunctionResolver;
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.functionResolver;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        if (namespaceContext == null) {
            String string = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"NamespaceContext"});
            throw new NullPointerException(string);
        }
        this.namespaceContext = namespaceContext;
        this.prefixResolver = new JAXPPrefixResolver(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    private DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = FactoryImpl.getDOMFactory(this.useServiceMechanism);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Error(parserConfigurationException);
        }
    }

    private XObject eval(String string, Object object) throws TransformerException {
        Object object2;
        XPath xPath = new XPath(string, null, this.prefixResolver, 0);
        XPathContext xPathContext = null;
        if (this.functionResolver != null) {
            object2 = new JAXPExtensionsProvider(this.functionResolver, this.featureSecureProcessing);
            xPathContext = new XPathContext(object2);
        } else {
            xPathContext = new XPathContext();
        }
        object2 = null;
        xPathContext.setVarStack(new JAXPVariableStack(this.variableResolver));
        object2 = object instanceof Node ? xPath.execute(xPathContext, (Node)object, (PrefixResolver)this.prefixResolver) : xPath.execute(xPathContext, -1, (PrefixResolver)this.prefixResolver);
        return object2;
    }

    public Object evaluate(String string, Object object, QName qName) throws XPathExpressionException {
        if (string == null) {
            String string2 = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPath expression"});
            throw new NullPointerException(string2);
        }
        if (qName == null) {
            String string3 = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"returnType"});
            throw new NullPointerException(string3);
        }
        if (!this.isSupported(qName)) {
            String string4 = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{qName.toString()});
            throw new IllegalArgumentException(string4);
        }
        try {
            XObject xObject = this.eval(string, object);
            return this.getResultAsType(xObject, qName);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPathExpressionException(nullPointerException);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof XPathFunctionException) {
                throw (XPathFunctionException)throwable;
            }
            throw new XPathExpressionException(transformerException);
        }
    }

    private boolean isSupported(QName qName) {
        return qName.equals(XPathConstants.STRING) || qName.equals(XPathConstants.NUMBER) || qName.equals(XPathConstants.BOOLEAN) || qName.equals(XPathConstants.NODE) || qName.equals(XPathConstants.NODESET);
    }

    private Object getResultAsType(XObject xObject, QName qName) throws TransformerException {
        if (qName.equals(XPathConstants.STRING)) {
            return xObject.str();
        }
        if (qName.equals(XPathConstants.NUMBER)) {
            return new Double(xObject.num());
        }
        if (qName.equals(XPathConstants.BOOLEAN)) {
            return new Boolean(xObject.bool());
        }
        if (qName.equals(XPathConstants.NODESET)) {
            return xObject.nodelist();
        }
        if (qName.equals(XPathConstants.NODE)) {
            NodeIterator nodeIterator = xObject.nodeset();
            return nodeIterator.nextNode();
        }
        String string = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{qName.toString()});
        throw new IllegalArgumentException(string);
    }

    public String evaluate(String string, Object object) throws XPathExpressionException {
        return (String)this.evaluate(string, object, XPathConstants.STRING);
    }

    public XPathExpression compile(String string) throws XPathExpressionException {
        if (string == null) {
            String string2 = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPath expression"});
            throw new NullPointerException(string2);
        }
        try {
            XPath xPath = new XPath(string, null, this.prefixResolver, 0);
            XPathExpressionImpl xPathExpressionImpl = new XPathExpressionImpl(xPath, this.prefixResolver, this.functionResolver, this.variableResolver, this.featureSecureProcessing, this.useServiceMechanism);
            return xPathExpressionImpl;
        }
        catch (TransformerException transformerException) {
            throw new XPathExpressionException(transformerException);
        }
    }

    public Object evaluate(String string, InputSource inputSource, QName qName) throws XPathExpressionException {
        if (inputSource == null) {
            String string2 = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"source"});
            throw new NullPointerException(string2);
        }
        if (string == null) {
            String string3 = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPath expression"});
            throw new NullPointerException(string3);
        }
        if (qName == null) {
            String string4 = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"returnType"});
            throw new NullPointerException(string4);
        }
        if (!this.isSupported(qName)) {
            String string5 = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{qName.toString()});
            throw new IllegalArgumentException(string5);
        }
        try {
            Document document = this.getParser().parse(inputSource);
            XObject xObject = this.eval(string, document);
            return this.getResultAsType(xObject, qName);
        }
        catch (SAXException sAXException) {
            throw new XPathExpressionException(sAXException);
        }
        catch (IOException iOException) {
            throw new XPathExpressionException(iOException);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof XPathFunctionException) {
                throw (XPathFunctionException)throwable;
            }
            throw new XPathExpressionException(transformerException);
        }
    }

    public String evaluate(String string, InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(string, inputSource, XPathConstants.STRING);
    }

    public void reset() {
        this.variableResolver = this.origVariableResolver;
        this.functionResolver = this.origFunctionResolver;
        this.namespaceContext = null;
    }
}

