/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class IPAddressName
implements GeneralNameInterface {
    private byte[] address;
    private boolean isIPv4;
    private String name;
    private static final int MASKSIZE = 16;

    public IPAddressName(DerValue derValue) throws IOException {
        this(derValue.getOctetString());
    }

    public IPAddressName(byte[] byArray) throws IOException {
        if (byArray.length == 4 || byArray.length == 8) {
            this.isIPv4 = true;
        } else if (byArray.length == 16 || byArray.length == 32) {
            this.isIPv4 = false;
        } else {
            throw new IOException("Invalid IPAddressName");
        }
        this.address = byArray;
    }

    public IPAddressName(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("IPAddress cannot be null or empty");
        }
        if (string.charAt(string.length() - 1) == '/') {
            throw new IOException("Invalid IPAddress: " + string);
        }
        if (string.indexOf(58) >= 0) {
            this.parseIPv6(string);
            this.isIPv4 = false;
        } else if (string.indexOf(46) >= 0) {
            this.parseIPv4(string);
            this.isIPv4 = true;
        } else {
            throw new IOException("Invalid IPAddress: " + string);
        }
    }

    private void parseIPv4(String string) throws IOException {
        int n = string.indexOf(47);
        if (n == -1) {
            this.address = InetAddress.getByName(string).getAddress();
        } else {
            this.address = new byte[8];
            byte[] byArray = InetAddress.getByName(string.substring(n + 1)).getAddress();
            byte[] byArray2 = InetAddress.getByName(string.substring(0, n)).getAddress();
            System.arraycopy(byArray2, 0, this.address, 0, 4);
            System.arraycopy(byArray, 0, this.address, 4, 4);
        }
    }

    private void parseIPv6(String string) throws IOException {
        int n = string.indexOf(47);
        if (n == -1) {
            this.address = InetAddress.getByName(string).getAddress();
        } else {
            this.address = new byte[32];
            byte[] byArray = InetAddress.getByName(string.substring(0, n)).getAddress();
            System.arraycopy(byArray, 0, this.address, 0, 16);
            int n2 = Integer.parseInt(string.substring(n + 1));
            if (n2 > 128) {
                throw new IOException("IPv6Address prefix is longer than 128");
            }
            BitArray bitArray = new BitArray(128);
            for (int i = 0; i < n2; ++i) {
                bitArray.set(i, true);
            }
            byte[] byArray2 = bitArray.toByteArray();
            for (int i = 0; i < 16; ++i) {
                this.address[16 + i] = byArray2[i];
            }
        }
    }

    public int getType() {
        return 7;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOctetString(this.address);
    }

    public String toString() {
        try {
            return "IPAddress: " + this.getName();
        }
        catch (IOException iOException) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            return "IPAddress: " + hexDumpEncoder.encodeBuffer(this.address);
        }
    }

    public String getName() throws IOException {
        if (this.name != null) {
            return this.name;
        }
        if (this.isIPv4) {
            byte[] byArray = new byte[4];
            System.arraycopy(this.address, 0, byArray, 0, 4);
            this.name = InetAddress.getByAddress(byArray).getHostAddress();
            if (this.address.length == 8) {
                byte[] byArray2 = new byte[4];
                System.arraycopy(this.address, 4, byArray2, 0, 4);
                this.name = this.name + "/" + InetAddress.getByAddress(byArray2).getHostAddress();
            }
        } else {
            byte[] byArray = new byte[16];
            System.arraycopy(this.address, 0, byArray, 0, 16);
            this.name = InetAddress.getByAddress(byArray).getHostAddress();
            if (this.address.length == 32) {
                int n;
                byte[] byArray3 = new byte[16];
                for (int i = 16; i < 32; ++i) {
                    byArray3[i - 16] = this.address[i];
                }
                BitArray bitArray = new BitArray(128, byArray3);
                for (n = 0; n < 128 && bitArray.get(n); ++n) {
                }
                this.name = this.name + "/" + n;
                while (n < 128) {
                    if (bitArray.get(n)) {
                        throw new IOException("Invalid IPv6 subdomain - set bit " + n + " not contiguous");
                    }
                    ++n;
                }
            }
        }
        return this.name;
    }

    public byte[] getBytes() {
        return (byte[])this.address.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IPAddressName)) {
            return false;
        }
        byte[] byArray = ((IPAddressName)object).getBytes();
        if (byArray.length != this.address.length) {
            return false;
        }
        if (this.address.length == 8 || this.address.length == 32) {
            int n;
            int n2 = this.address.length / 2;
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[n2];
            for (n = 0; n < n2; ++n) {
                byArray2[n] = (byte)(this.address[n] & this.address[n + n2]);
                byArray3[n] = (byte)(byArray[n] & byArray[n + n2]);
                if (byArray2[n] == byArray3[n]) continue;
                return false;
            }
            for (n = n2; n < this.address.length; ++n) {
                if (this.address[n] == byArray[n]) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(byArray, this.address);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.address.length; ++i) {
            n += this.address[i] * i;
        }
        return n;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        if (generalNameInterface == null) {
            n = -1;
        } else if (generalNameInterface.getType() != 7) {
            n = -1;
        } else if (((IPAddressName)generalNameInterface).equals(this)) {
            n = 0;
        } else {
            byte[] byArray = ((IPAddressName)generalNameInterface).getBytes();
            if (byArray.length == 4 && this.address.length == 4) {
                n = 3;
            } else if (byArray.length == 8 && this.address.length == 8 || byArray.length == 32 && this.address.length == 32) {
                boolean bl = true;
                boolean bl2 = true;
                boolean bl3 = false;
                boolean bl4 = false;
                int n2 = this.address.length / 2;
                for (int i = 0; i < n2; ++i) {
                    if ((byte)(this.address[i] & this.address[i + n2]) != this.address[i]) {
                        bl3 = true;
                    }
                    if ((byte)(byArray[i] & byArray[i + n2]) != byArray[i]) {
                        bl4 = true;
                    }
                    if ((byte)(this.address[i + n2] & byArray[i + n2]) != this.address[i + n2] || (byte)(this.address[i] & this.address[i + n2]) != (byte)(byArray[i] & this.address[i + n2])) {
                        bl = false;
                    }
                    if ((byte)(byArray[i + n2] & this.address[i + n2]) == byArray[i + n2] && (byte)(byArray[i] & byArray[i + n2]) == (byte)(this.address[i] & byArray[i + n2])) continue;
                    bl2 = false;
                }
                n = bl3 || bl4 ? (bl3 && bl4 ? 0 : (bl3 ? 2 : 1)) : (bl ? 1 : (bl2 ? 2 : 3));
            } else if (byArray.length == 8 || byArray.length == 32) {
                int n3;
                int n4 = byArray.length / 2;
                for (n3 = 0; n3 < n4 && (this.address[n3] & byArray[n3 + n4]) == byArray[n3]; ++n3) {
                }
                n = n3 == n4 ? 2 : 3;
            } else if (this.address.length == 8 || this.address.length == 32) {
                int n5;
                int n6 = this.address.length / 2;
                for (n5 = 0; n5 < n6 && (byArray[n5] & this.address[n5 + n6]) == this.address[n5]; ++n5) {
                }
                n = n5 == n6 ? 1 : 3;
            } else {
                n = 3;
            }
        }
        return n;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for IPAddressName");
    }
}

