/*
 * Decompiled with CFR 0.152.
 */
package com.matura.impl.data;

import com.matura.api.data.IQuestionGet;
import com.matura.api.form.model.IQuestion;
import com.matura.api.xml.model.AnswerXml;
import com.matura.api.xml.model.DataXml;
import com.matura.api.xml.model.ElementXml;
import com.matura.api.xml.model.QuestionXml;
import com.matura.api.xml.model.VersionXml;
import com.matura.impl.data.DataRead;
import com.matura.impl.form.model.Answer;
import com.matura.impl.form.model.Data;
import com.matura.impl.form.model.Element;
import com.matura.impl.form.model.Question;
import com.matura.impl.utils.QuestionComparator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuestionGet
implements IQuestionGet {
    private static final String[] LETTERS = new String[]{"a", "b", "c", "d"};

    public IQuestion getQuestion(QuestionXml question, boolean random) {
        List versions;
        if (question != null && (versions = question.getVersions()).size() > 0) {
            ArrayList dataList;
            if (random && versions.size() > 1) {
                Collections.shuffle(versions);
            }
            Question currentQuestion = new Question();
            currentQuestion.setId(question.getId());
            currentQuestion.setOpen(question.isOpen());
            currentQuestion.setHybrid(question.isHybrid());
            currentQuestion.setVersion(((VersionXml)versions.get(0)).getId());
            currentQuestion.setTitle(((VersionXml)versions.get(0)).getTitle());
            currentQuestion.setScore(((VersionXml)versions.get(0)).getScore());
            currentQuestion.setContent(((VersionXml)versions.get(0)).getContent());
            currentQuestion.setManual(((VersionXml)versions.get(0)).getManual());
            currentQuestion.setTwoColumns(((VersionXml)versions.get(0)).isTwoColumns());
            ArrayList answers = ((VersionXml)versions.get(0)).getAnswers();
            if (answers == null) {
                answers = new ArrayList();
            }
            if ((dataList = ((VersionXml)versions.get(0)).getAdditionalData()) == null) {
                dataList = new ArrayList();
            }
            if (random && answers.size() > 1) {
                Collections.shuffle(answers);
            }
            int index = 0;
            for (AnswerXml answer : answers) {
                Answer ans = new Answer();
                ans.setId(answer.getId());
                ans.setCorrect(answer.isCorrect());
                ans.setContent("\\text{" + LETTERS[index++] + ") }" + answer.getContent());
                currentQuestion.getAnswers().add(ans);
            }
            for (DataXml data : dataList) {
                Data myData = new Data();
                myData.setId(data.getId());
                myData.setLeft(data.getLeft());
                myData.setCenter(data.isCenter());
                myData.setSide(data.getSide());
                myData.setWidth(data.getWidth());
                myData.setHeight(data.getHeight());
                myData.setCorrect(data.isCorrect());
                myData.setAnswer(data.getAnswer());
                myData.setScore(data.getScore());
                myData.setBottom(data.getBottom());
                List elementsXml = data.getElements();
                if (elementsXml != null) {
                    for (ElementXml element : elementsXml) {
                        Element myElement = new Element();
                        myElement.setType(element.getType());
                        myElement.setValue(element.getValue());
                        myElement.setValues(element.getValues());
                        myElement.setScore(element.getScore());
                        myElement.setWidth(element.getWidth());
                        myElement.setHeight(element.getHeight());
                        myElement.setGroup(element.getGroup());
                        myElement.setAlternate(element.isAlternate());
                        myElement.setLeft(element.getLeft());
                        myElement.setTop(element.getTop());
                        myElement.setBottom(element.getBottom());
                        if (element.getCriteria() != null) {
                            String[] cr;
                            ArrayList<Integer> criteria = new ArrayList<Integer>();
                            for (String s : cr = element.getCriteria().split(";")) {
                                criteria.add(Integer.parseInt(s));
                            }
                            myElement.setListCriteria(criteria);
                        }
                        myData.getDataElements().add(myElement);
                    }
                }
                currentQuestion.getDataList().add(myData);
            }
            return currentQuestion;
        }
        return null;
    }

    public Map<String, IQuestion> getQuestionsList(List<QuestionXml> staticList, boolean random) {
        HashMap<String, IQuestion> questionList = new HashMap<String, IQuestion>();
        QuestionGet qg = new QuestionGet();
        int index = 0;
        for (QuestionXml qXml : staticList) {
            IQuestion currentCuestion = qg.getQuestion(qXml, random);
            if (currentCuestion == null) continue;
            questionList.put(String.valueOf(++index), currentCuestion);
        }
        for (int i = 1; i <= questionList.size(); ++i) {
            IQuestion next;
            IQuestion current = (IQuestion)questionList.get(String.valueOf(i));
            IQuestion previous = i > 1 ? (IQuestion)questionList.get(String.valueOf(i - 1)) : null;
            IQuestion iQuestion = next = i < questionList.size() ? (IQuestion)questionList.get(String.valueOf(i + 1)) : null;
            if (previous != null) {
                current.setPrevious(previous);
            }
            if (next == null) continue;
            current.setNext(next);
        }
        return questionList;
    }

    public List<QuestionXml> getQuestionsListFromResource() {
        ArrayList<QuestionXml> questionList = new ArrayList<QuestionXml>();
        DataRead exercise = new DataRead();
        for (int i = 0; i < 15; ++i) {
            String exerciseFilePath = "com/matura/exercises/exercise_${number}.xml".replace("${number}", String.valueOf(i + 1));
            InputStream isXml = this.getClass().getClassLoader().getResourceAsStream(exerciseFilePath);
            if (isXml == null) continue;
            QuestionXml q = exercise.readFromStorage(isXml);
            questionList.add(q);
            try {
                isXml.close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return questionList;
    }

    public List<IQuestion> getSortedQuestionsList(Map<String, IQuestion> questions) {
        ArrayList<IQuestion> sortedList = new ArrayList<IQuestion>();
        for (Map.Entry<String, IQuestion> question : questions.entrySet()) {
            sortedList.add(question.getValue());
        }
        Collections.sort(sortedList, new QuestionComparator());
        return sortedList;
    }
}

