/*
 * Decompiled with CFR 0.152.
 */
package com.matura.impl.utils;

import com.matura.api.form.model.IElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuestionUtils {
    public static boolean isInGroupAlternateAnswerCorrect(IElement currentElement, List<IElement> correctValues) {
        for (IElement element : correctValues) {
            if (element.getCorrectValueIndex() != currentElement.getSelectedValueIndex()) continue;
            correctValues.remove(element);
            return true;
        }
        return false;
    }

    public static boolean isInGroupAnswerCorrect(IElement currentElement, List<IElement> correctValues) {
        for (IElement element : correctValues) {
            if (element.getCorrectValueIndex() != currentElement.getSelectedValueIndex()) continue;
            correctValues.remove(element);
            return true;
        }
        return false;
    }

    public static int calculatePointsFoGroups(Map<String, List<IElement>> groups) {
        int points = 0;
        for (Map.Entry<String, List<IElement>> element : groups.entrySet()) {
            List criteria = null;
            int correct = 0;
            ArrayList<IElement> tempList = new ArrayList<IElement>((Collection)element.getValue());
            for (IElement el : element.getValue()) {
                criteria = el.getListCriteria();
                if (!el.isAlternate() && el.getCorrectValueIndex() == el.getSelectedValueIndex()) {
                    ++correct;
                    continue;
                }
                if (!el.isAlternate() || !QuestionUtils.isInGroupAlternateAnswerCorrect(el, tempList)) continue;
                ++correct;
            }
            if (correct <= 0) continue;
            points += ((Integer)criteria.get(correct - 1)).intValue();
        }
        return points;
    }

    public static Map<String, List<IElement>> prepareGrouppedElementsMap(List<IElement> elements) {
        HashMap<String, List<IElement>> groups = new HashMap<String, List<IElement>>();
        String group = null;
        for (IElement element : elements) {
            if (!"select".equals(element.getType())) continue;
            if (element.getGroup() != null) {
                group = element.getGroup();
            } else if (element.isAlternate()) {
                group = "alternate";
            }
            if (group == null) continue;
            if (groups.get(group) != null) {
                ((List)groups.get(group)).add(element);
            } else {
                ArrayList<IElement> gr = new ArrayList<IElement>();
                gr.add(element);
                groups.put(group, gr);
            }
            group = null;
        }
        return groups;
    }
}

