/*
 * Decompiled with CFR 0.152.
 */
package com.matura.forms.actions;

import com.matura.api.form.model.IAnswer;
import com.matura.api.form.model.IData;
import com.matura.api.form.model.IFormModel;
import com.matura.api.form.model.IQuestion;
import com.matura.forms.dialogs.CorrectAnswerDialog;
import com.matura.forms.dialogs.MainFrame;
import com.matura.forms.dialogs.SummaryDialog;
import com.matura.forms.dialogs.YesNoDialog;
import com.matura.forms.utils.FormulaGenerator;
import com.matura.forms.utils.QuestionFormUtils;
import com.matura.forms.utils.SpecialButton;
import com.matura.forms.utils.SpecialLabel;
import com.matura.forms.utils.SpecialToggleButton;
import com.matura.forms.utils.YesNoWindow;
import com.matura.impl.form.model.FormModel;
import com.matura.impl.utils.BundleUtil;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowEvents
extends JFrame
implements ActionListener,
MouseListener,
ChangeListener,
WindowListener {
    protected static JPanel centerPanel = null;
    protected SpecialLabel exerciseTitleLabel = null;
    protected SpecialLabel exercisePointsLabel = null;
    protected IFormModel formModel = new FormModel();
    protected SpecialButton finishExamButton = null;
    protected SpecialButton finishProgramButton = null;
    protected SpecialButton summaryButton = null;
    protected MainFrame mainFrame;
    protected SpecialLabel instructionLabel = null;
    protected SpecialButton correctAnswerButton = null;
    protected SpecialButton previousButton = null;
    protected SpecialButton nextButton = null;
    protected SpecialLabel exerciseContentLabel = null;
    protected JPanel contentCenterCenterExerciseAnswersPanel = null;
    protected SummaryDialog summaryDialog;
    protected CorrectAnswerDialog[] correctAnswerDialog = new CorrectAnswerDialog[15];
    protected YesNoDialog yesNoDialogExam;
    protected YesNoDialog yesNoDialogProgram1;
    protected YesNoDialog yesNoDialogProgram2;

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getComponent() instanceof SpecialToggleButton || e.getComponent() instanceof SpecialButton || this.formModel.getSummary() == null && e.getComponent() instanceof JRadioButton) {
            e.getComponent().setCursor(new Cursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getComponent() instanceof SpecialToggleButton || e.getComponent() instanceof SpecialButton || this.formModel.getSummary() == null && e.getComponent() instanceof JRadioButton) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IQuestion currentQuestion;
        if (e.getSource() instanceof SpecialToggleButton) {
            SpecialToggleButton currentButton = (SpecialToggleButton)e.getSource();
            String currentQuestionId = currentButton.getName().replace("exerciseButtonNumber", "");
            IQuestion currentQuestion2 = (IQuestion)this.formModel.getAllQuestionsMap().get(currentQuestionId);
            IQuestion previousQuestion = this.formModel.getCurrentQuestion();
            if (previousQuestion.getQuestionId() != currentQuestion2.getQuestionId()) {
                ((SpecialToggleButton)previousQuestion.getComponent()).getModel().setSelected(false);
                ((SpecialToggleButton)previousQuestion.getComponent()).getModel().setEnabled(true);
            }
            if (currentQuestion2.hasPrevious()) {
                this.previousButton.setVisible(true);
            } else {
                this.previousButton.setVisible(false);
            }
            if (currentQuestion2.hasNext()) {
                this.nextButton.setVisible(true);
            } else {
                this.nextButton.setVisible(false);
            }
            ((SpecialToggleButton)currentQuestion2.getComponent()).setEnabled(false);
            if (currentQuestion2 != null) {
                boolean examFinished;
                ArrayList<String> params;
                this.formModel.setCurrentQuestion(currentQuestion2);
                this.exerciseTitleLabel.setText(currentQuestion2.getTitle());
                String pointsLabel = "";
                if (this.formModel.getSummary() != null) {
                    params = new ArrayList<String>();
                    params.add(String.valueOf(currentQuestion2.getYourScore()));
                    params.add(String.valueOf(currentQuestion2.getScore()));
                    pointsLabel = BundleUtil.getBundle((String)"main.window.exercise.your.score", params);
                } else {
                    params = new ArrayList();
                    params.add(String.valueOf(currentQuestion2.getScore()));
                    pointsLabel = BundleUtil.getBundle((String)"main.window.exercise.score", params);
                }
                this.exercisePointsLabel.setText(pointsLabel);
                this.instructionLabel.setText(currentQuestion2.getManual());
                this.exerciseContentLabel.setIcon(FormulaGenerator.getImageIcon(currentQuestion2.getContent()));
                this.contentCenterCenterExerciseAnswersPanel.setLayout(new BoxLayout(this.contentCenterCenterExerciseAnswersPanel, 3));
                this.contentCenterCenterExerciseAnswersPanel.removeAll();
                IAnswer selectedAnswer = this.formModel.getCurrentQuestion().getSelectedAnswer();
                IData selectedDataAnswer = this.formModel.getCurrentQuestion().getSelectedDataAnswer();
                boolean bl = examFinished = this.formModel.getSummary() != null;
                if (examFinished) {
                    this.correctAnswerButton.setVisible(true);
                }
                this.contentCenterCenterExerciseAnswersPanel.setName(null);
                if (currentQuestion2.isOpen()) {
                    QuestionFormUtils.preparePanelForOpenQuestion(currentQuestion2, selectedDataAnswer, examFinished, this, this.contentCenterCenterExerciseAnswersPanel);
                } else {
                    QuestionFormUtils.preparePanelForCloseQuestion(currentQuestion2, selectedAnswer, examFinished, this, this.contentCenterCenterExerciseAnswersPanel);
                }
            }
        }
        if ("finishProgramButtonAction".equals(e.getActionCommand())) {
            if (this.mainFrame.isStartScreen()) {
                if (this.yesNoDialogProgram1 == null) {
                    this.yesNoDialogProgram1 = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_PROGRAM);
                }
                this.yesNoDialogProgram1.setVisible(true);
            } else {
                if (this.yesNoDialogProgram2 == null) {
                    this.yesNoDialogProgram2 = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_PROGRAM);
                }
                this.yesNoDialogProgram2.setVisible(true);
            }
        } else if ("finishExamButtonAction".equals(e.getActionCommand())) {
            if (this.yesNoDialogExam == null) {
                this.yesNoDialogExam = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_EXAM);
            }
            this.yesNoDialogExam.setVisible(true);
        } else if ("nextButtonAction".equals(e.getActionCommand())) {
            currentQuestion = this.formModel.getCurrentQuestion();
            if (currentQuestion.hasNext()) {
                if (!currentQuestion.getNext().hasNext()) {
                    this.nextButton.setVisible(false);
                } else {
                    this.nextButton.setVisible(true);
                }
                this.previousButton.setVisible(true);
                ((SpecialToggleButton)currentQuestion.getNext().getComponent()).doClick();
            }
        } else if ("previousButtonAction".equals(e.getActionCommand())) {
            currentQuestion = this.formModel.getCurrentQuestion();
            if (currentQuestion.hasPrevious()) {
                if (!currentQuestion.getPrevious().hasPrevious()) {
                    this.previousButton.setVisible(false);
                } else {
                    this.previousButton.setVisible(true);
                }
                this.nextButton.setVisible(true);
                ((SpecialToggleButton)currentQuestion.getPrevious().getComponent()).doClick();
            }
        } else if ("summaryButtonAction".equals(e.getActionCommand())) {
            if (this.summaryDialog == null) {
                this.summaryDialog = new SummaryDialog(this.mainFrame);
            }
            this.summaryDialog.setVisible(true);
        } else if ("correctAnswerButtonAction".equals(e.getActionCommand())) {
            int dialogIndex = this.formModel.getCurrentQuestion().getQuestionId() - 1;
            if (this.correctAnswerDialog[dialogIndex] == null) {
                this.correctAnswerDialog[dialogIndex] = new CorrectAnswerDialog(this.mainFrame);
            }
            this.correctAnswerDialog[dialogIndex].setVisible(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JRadioButton currentRadio;
        if (e.getSource() instanceof JRadioButton && (currentRadio = (JRadioButton)e.getSource()).isSelected()) {
            String radioId = currentRadio.getName().split("_")[1];
            if (this.formModel.getCurrentQuestion().isOpen() && this.formModel.getCurrentQuestion().isHybrid()) {
                this.formModel.getCurrentQuestion().selectDataAnswer(radioId);
            } else {
                this.formModel.getCurrentQuestion().selectAnswer(radioId);
            }
        }
    }

    public SpecialButton getFinishExamButton() {
        return this.finishExamButton;
    }

    public void setFinishExamButton(SpecialButton finishExamButton) {
        this.finishExamButton = finishExamButton;
    }

    public SpecialButton getSummaryButton() {
        return this.summaryButton;
    }

    public void setSummaryButton(SpecialButton summaryButton) {
        this.summaryButton = summaryButton;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.requestFocus();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.mainFrame.isStartScreen()) {
            if (this.yesNoDialogProgram1 == null) {
                this.yesNoDialogProgram1 = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_PROGRAM);
            }
            this.yesNoDialogProgram1.setVisible(true);
        } else {
            if (this.yesNoDialogProgram2 == null) {
                this.yesNoDialogProgram2 = new YesNoDialog(this.mainFrame, YesNoWindow.FINISH_PROGRAM);
            }
            this.yesNoDialogProgram2.setVisible(true);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public SpecialButton getCorrectAnswerButton() {
        return this.correctAnswerButton;
    }

    public void setCorrectAnswerButton(SpecialButton correctAnswerButton) {
        this.correctAnswerButton = correctAnswerButton;
    }

    public SummaryDialog getSummaryDialog() {
        return this.summaryDialog;
    }

    public void setSummaryDialog(SummaryDialog summaryDialog) {
        this.summaryDialog = summaryDialog;
    }

    public CorrectAnswerDialog[] getCorrectAnswerDialog() {
        return this.correctAnswerDialog;
    }

    public void setCorrectAnswerDialog(CorrectAnswerDialog[] correctAnswerDialog) {
        this.correctAnswerDialog = correctAnswerDialog;
    }

    public YesNoDialog getYesNoDialogExam() {
        return this.yesNoDialogExam;
    }

    public void setYesNoDialogExam(YesNoDialog yesNoDialogExam) {
        this.yesNoDialogExam = yesNoDialogExam;
    }

    public YesNoDialog getYesNoDialogProgram1() {
        return this.yesNoDialogProgram1;
    }

    public void setYesNoDialogProgram1(YesNoDialog yesNoDialogProgram1) {
        this.yesNoDialogProgram1 = yesNoDialogProgram1;
    }

    public YesNoDialog getYesNoDialogProgram2() {
        return this.yesNoDialogProgram2;
    }

    public void setYesNoDialogProgram2(YesNoDialog yesNoDialogProgram2) {
        this.yesNoDialogProgram2 = yesNoDialogProgram2;
    }
}

