/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.resolver;

import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import com.sun.org.apache.xml.internal.resolver.Catalog;
import com.sun.org.apache.xml.internal.resolver.CatalogEntry;
import com.sun.org.apache.xml.internal.resolver.CatalogException;
import com.sun.org.apache.xml.internal.resolver.readers.SAXCatalogReader;
import com.sun.org.apache.xml.internal.resolver.readers.TR9401CatalogReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;

public class Resolver
extends Catalog {
    public static final int URISUFFIX = CatalogEntry.addEntryType("URISUFFIX", 2);
    public static final int SYSTEMSUFFIX = CatalogEntry.addEntryType("SYSTEMSUFFIX", 2);
    public static final int RESOLVER = CatalogEntry.addEntryType("RESOLVER", 1);
    public static final int SYSTEMREVERSE = CatalogEntry.addEntryType("SYSTEMREVERSE", 1);

    public void setupReaders() {
        SAXParserFactory sAXParserFactory = this.catalogManager.useServicesMechanism() ? SAXParserFactory.newInstance() : new SAXParserFactoryImpl();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        SAXCatalogReader sAXCatalogReader = new SAXCatalogReader(sAXParserFactory);
        sAXCatalogReader.setCatalogParser(null, "XMLCatalog", "com.sun.org.apache.xml.internal.resolver.readers.XCatalogReader");
        sAXCatalogReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "com.sun.org.apache.xml.internal.resolver.readers.ExtendedXMLCatalogReader");
        this.addReader("application/xml", sAXCatalogReader);
        TR9401CatalogReader tR9401CatalogReader = new TR9401CatalogReader();
        this.addReader("text/plain", tR9401CatalogReader);
    }

    public void addEntry(CatalogEntry catalogEntry) {
        int n = catalogEntry.getEntryType();
        if (n == URISUFFIX) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string2 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string2);
            this.catalogManager.debug.message(4, "URISUFFIX", string, string2);
        } else if (n == SYSTEMSUFFIX) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string3 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string3);
            this.catalogManager.debug.message(4, "SYSTEMSUFFIX", string, string3);
        }
        super.addEntry(catalogEntry);
    }

    public String resolveURI(String string) throws MalformedURLException, IOException {
        String string2 = super.resolveURI(string);
        if (string2 != null) {
            return string2;
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == RESOLVER) {
                string2 = this.resolveExternalSystem(string, catalogEntry.getEntryArg(0));
                if (string2 == null) continue;
                return string2;
            }
            if (catalogEntry.getEntryType() != URISUFFIX) continue;
            String string3 = catalogEntry.getEntryArg(0);
            String string4 = catalogEntry.getEntryArg(1);
            if (string3.length() > string.length() || !string.substring(string.length() - string3.length()).equals(string3)) continue;
            return string4;
        }
        return this.resolveSubordinateCatalogs(Catalog.URI, null, null, string);
    }

    public String resolveSystem(String string) throws MalformedURLException, IOException {
        String string2 = super.resolveSystem(string);
        if (string2 != null) {
            return string2;
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == RESOLVER) {
                string2 = this.resolveExternalSystem(string, catalogEntry.getEntryArg(0));
                if (string2 == null) continue;
                return string2;
            }
            if (catalogEntry.getEntryType() != SYSTEMSUFFIX) continue;
            String string3 = catalogEntry.getEntryArg(0);
            String string4 = catalogEntry.getEntryArg(1);
            if (string3.length() > string.length() || !string.substring(string.length() - string3.length()).equals(string3)) continue;
            return string4;
        }
        return this.resolveSubordinateCatalogs(Catalog.SYSTEM, null, null, string);
    }

    public String resolvePublic(String string, String string2) throws MalformedURLException, IOException {
        String string3 = super.resolvePublic(string, string2);
        if (string3 != null) {
            return string3;
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() != RESOLVER) continue;
            if (string2 != null && (string3 = this.resolveExternalSystem(string2, catalogEntry.getEntryArg(0))) != null) {
                return string3;
            }
            string3 = this.resolveExternalPublic(string, catalogEntry.getEntryArg(0));
            if (string3 == null) continue;
            return string3;
        }
        return this.resolveSubordinateCatalogs(Catalog.PUBLIC, null, string, string2);
    }

    protected String resolveExternalSystem(String string, String string2) throws MalformedURLException, IOException {
        Resolver resolver = this.queryResolver(string2, "i2l", string, null);
        if (resolver != null) {
            return resolver.resolveSystem(string);
        }
        return null;
    }

    protected String resolveExternalPublic(String string, String string2) throws MalformedURLException, IOException {
        Resolver resolver = this.queryResolver(string2, "fpi2l", string, null);
        if (resolver != null) {
            return resolver.resolvePublic(string, null);
        }
        return null;
    }

    protected Resolver queryResolver(String string, String string2, String string3, String string4) {
        Object var5_5 = null;
        String string5 = string + "?command=" + string2 + "&format=tr9401&uri=" + string3 + "&uri2=" + string4;
        Object var7_7 = null;
        try {
            URL uRL = new URL(string5);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            Resolver resolver = (Resolver)this.newCatalog();
            String string6 = uRLConnection.getContentType();
            if (string6.indexOf(";") > 0) {
                string6 = string6.substring(0, string6.indexOf(";"));
            }
            resolver.parseCatalog(string6, uRLConnection.getInputStream());
            return resolver;
        }
        catch (CatalogException catalogException) {
            if (catalogException.getExceptionType() == 6) {
                this.catalogManager.debug.message(1, "Unparseable catalog: " + string5);
            } else if (catalogException.getExceptionType() == 5) {
                this.catalogManager.debug.message(1, "Unknown catalog format: " + string5);
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            this.catalogManager.debug.message(1, "Malformed resolver URL: " + string5);
            return null;
        }
        catch (IOException iOException) {
            this.catalogManager.debug.message(1, "I/O Exception opening resolver: " + string5);
            return null;
        }
    }

    private Vector appendVector(Vector vector, Vector vector2) {
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement(vector2.elementAt(i));
            }
        }
        return vector;
    }

    public Vector resolveAllSystemReverse(String string) throws MalformedURLException, IOException {
        Vector vector;
        Vector vector2 = new Vector();
        if (string != null) {
            vector = this.resolveLocalSystemReverse(string);
            vector2 = this.appendVector(vector2, vector);
        }
        vector = this.resolveAllSubordinateCatalogs(SYSTEMREVERSE, null, null, string);
        return this.appendVector(vector2, vector);
    }

    public String resolveSystemReverse(String string) throws MalformedURLException, IOException {
        Vector vector = this.resolveAllSystemReverse(string);
        if (vector != null && vector.size() > 0) {
            return (String)vector.elementAt(0);
        }
        return null;
    }

    public Vector resolveAllSystem(String string) throws MalformedURLException, IOException {
        Vector vector;
        Vector vector2 = new Vector();
        if (string != null) {
            vector = this.resolveAllLocalSystem(string);
            vector2 = this.appendVector(vector2, vector);
        }
        if ((vector2 = this.appendVector(vector2, vector = this.resolveAllSubordinateCatalogs(SYSTEM, null, null, string))).size() > 0) {
            return vector2;
        }
        return null;
    }

    private Vector resolveAllLocalSystem(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = System.getProperty("os.name");
        boolean bl = string2.indexOf("Windows") >= 0;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() != SYSTEM || !catalogEntry.getEntryArg(0).equals(string) && (!bl || !catalogEntry.getEntryArg(0).equalsIgnoreCase(string))) continue;
            vector.addElement(catalogEntry.getEntryArg(1));
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    private Vector resolveLocalSystemReverse(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = System.getProperty("os.name");
        boolean bl = string2.indexOf("Windows") >= 0;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() != SYSTEM || !catalogEntry.getEntryArg(1).equals(string) && (!bl || !catalogEntry.getEntryArg(1).equalsIgnoreCase(string))) continue;
            vector.addElement(catalogEntry.getEntryArg(0));
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    private synchronized Vector resolveAllSubordinateCatalogs(int n, String string, String string2, String string3) throws MalformedURLException, IOException {
        Vector vector = new Vector();
        for (int i = 0; i < this.catalogs.size(); ++i) {
            Object object;
            Resolver resolver = null;
            try {
                resolver = (Resolver)this.catalogs.elementAt(i);
            }
            catch (ClassCastException classCastException) {
                object = (String)this.catalogs.elementAt(i);
                resolver = (Resolver)this.newCatalog();
                try {
                    resolver.parseCatalog((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    this.catalogManager.debug.message(1, "Malformed Catalog URL", (String)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, file not found", (String)object);
                }
                catch (IOException iOException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, I/O error", (String)object);
                }
                this.catalogs.setElementAt(resolver, i);
            }
            String string4 = null;
            if (n == DOCTYPE) {
                string4 = resolver.resolveDoctype(string, string2, string3);
                if (string4 == null) continue;
                vector.addElement(string4);
                return vector;
            }
            if (n == DOCUMENT) {
                string4 = resolver.resolveDocument();
                if (string4 == null) continue;
                vector.addElement(string4);
                return vector;
            }
            if (n == ENTITY) {
                string4 = resolver.resolveEntity(string, string2, string3);
                if (string4 == null) continue;
                vector.addElement(string4);
                return vector;
            }
            if (n == NOTATION) {
                string4 = resolver.resolveNotation(string, string2, string3);
                if (string4 == null) continue;
                vector.addElement(string4);
                return vector;
            }
            if (n == PUBLIC) {
                string4 = resolver.resolvePublic(string2, string3);
                if (string4 == null) continue;
                vector.addElement(string4);
                return vector;
            }
            if (n == SYSTEM) {
                object = resolver.resolveAllSystem(string3);
                vector = this.appendVector(vector, (Vector)object);
                break;
            }
            if (n != SYSTEMREVERSE) continue;
            object = resolver.resolveAllSystemReverse(string3);
            vector = this.appendVector(vector, (Vector)object);
        }
        if (vector != null) {
            return vector;
        }
        return null;
    }
}

