$(document).ready(function(){
	
	var score = 0;
	var dir = 'files/img/';
	var colorStandard = '#5a9feb';
	var colorHover    = '#457CB9';
	var colorActive   = '#457CB9';
	var colorBad      = '#EB5A5A';
	var ans = [
		{a:'smutek',b:'smutek.png'},
		{a:'złość',b:'zlosc.png'},
		{a:'radość',b:'radosc.png'},
		{a:'ból',b:'bol.png'},
	];
	ans.sort(function(){return 0.5 - Math.random()});
	function loadGame(){
		for(var i = 0; i < ans.length; i++){
			var newTask = document.createElement("div");
			newTask.className = "task task-hover";
			var taskContent = document.createElement("div");
			taskContent.className = "task-content";
			taskContent.innerHTML = "<img src='"+dir+ans[i]['b']+"' /><input type='text' placeholder='...........' /><input type='button' value='ROZWIĄŻ' /><div class='smile'><div class='smile-content'>DOBRZE :)</div></div>";
			newTask.appendChild(taskContent);
			document.getElementById("page").appendChild(newTask);
			$(newTask).data('answer',ans[i]['a']);
		}
		$('<div id="text"></div>').appendTo('#page');
		var suggestions = [];
		for(var i = 0; i < ans.length; i++){
			suggestions.push(ans[i]['a']);
		}
		suggestions.sort(function(){return 0.5 - Math.random()});
		for(var i = 0; i < ans.length; i++){
			$('.task:eq('+i+')').data('active',0).data('used',0).data('complete',0);
			$('<div class="text">'+suggestions[i]+'</div>').appendTo('#text');
		}
	}
	loadGame();
	$(document).click(function(){
		if(document.activeElement.tagName === 'BODY'){
			$('.task').data('active',0);
			for(var i = 0; i < ans.length; i++){
				var element = $('.task').eq(i);
				if(element.data('used') != 1){
					element.css('background',colorStandard);
				}
			}
		}
	});
	$(document).keypress(function(e){
		if(e.which == 13) {
			var activeElement = document.activeElement;
			if(activeElement.tagName === 'INPUT'){
				var parent = activeElement.parentNode.parentNode;
				$(parent).data('used',1);
				var inputValue = activeElement.value.trim().toLowerCase();
				var answer = $(parent).data('answer');
				if(inputValue === answer){
					$(activeElement).prop('disabled', true);
					$(activeElement).nextAll('input').hide();
					$(activeElement).val(inputValue);
					$(parent).css('background', colorHover);
					$(parent).data('complete',1);
					$(parent).css('cursor','auto');
					$(activeElement).parent().find('.smile').css('display','block');
					score++;
				}
				else{
					var button = $(activeElement).parent().find(':button');
					button.css('color',colorBad);
				}
				if(score == ans.length){
					endGame();
				}
			}
		}
	});
	$('.task').hover(function(){
		if($(this).data('active') != 1 && $(this).data('used') != 1){
			$(this).css('background',colorHover);
		}
	},function(){
		if($(this).data('active') == 1 && $(this).data('used') != 1 ){
			$(this).css('background',colorActive);
		}
		if($(this).data('active') == 0 && $(this).data('used') != 1){
			$(this).css('background',colorStandard);
		}
	});
	$('#reset').click(function(){
		location.reload();
	});
	$('input[type="button"]').click(function(){
		var inputText = $(this).prevAll('input');
		var inputValue = inputText.val().trim().toLowerCase();
		var answer = $(this).parent().parent().data('answer');
		var thisParent = $(this).parent().parent();
		thisParent.data('used',1);
		if(inputValue === answer){
			$(this).hide();
			inputText.prop('disabled', true);
			inputText.val(inputValue);
			thisParent.css('background', colorHover);
			thisParent.data('complete',1);
			thisParent.css('cursor','auto');
			$(this).parent().find('.smile').css('display','block');
			score++;
		}
		else{
			$(this).css('color',colorBad);
		}
		if(score == ans.length){
			$("#cover").fadeIn("slow");
			$("#message").fadeIn("slow");
		}
	});
	$('.task').click(function(){
		$('.task').data('active',0);
		for(var i = 0; i < ans.length; i++){
			var element = $('.task').eq(i);
			if(element.data('used') != 1){
				element.css('background',colorStandard);	
			}
		}
		$(this).data('active',1);
		if($(this).data('complete') != 1){
			if($(this).data('used') != 1){
				$(this).css('background',colorActive);
			}
			$(this).find('input[type=text]').focus();
		}
	});
	function endGame(){
		$("#cover").fadeIn("slow");
		$("#message").fadeIn("slow");
	}
});