$(document).ready(function(){
	
	//
	//global variables
	//
	
	var numberOfShelf;
	var lastNumberOfShelf;
	var usedCorrect;
	var usedIncorrect;
	var score = 0;
	
	function init(){
		
		numberOfShelf = Math.floor(Math.random()*5);
		
		if(numberOfShelf == lastNumberOfShelf){
			if(numberOfShelf == 4){
				numberOfShelf--;
			}
			else if(numberOfShelf == 0){
				numberOfShelf++;
			}
			else{
				if(numberOfShelf > 0 && numberOfShelf < 4){
					numberOfShelf++;
				}
				else{
					numberOfShelf--;
				}
			}
		}
		
		lastNumberOfShelf = numberOfShelf;
		
		usedCorrect = 0;
		usedIncorrect = 0;
		$('#draggable').empty();
		$('.shelfDroppable').remove();
		addToys();
		addDroppableShelf();
		addDroppableFloor();
		showNumberOfShelf();
	}
	
	function newGame(){
		
		usedCorrect = 0;
		usedIncorrect = 0;
		
		numberOfShelf = Math.floor(Math.random()*5);
		
		if(numberOfShelf == lastNumberOfShelf){
			if(numberOfShelf == 4){
				numberOfShelf--;
			}
			else if(numberOfShelf == 0){
				numberOfShelf++;
			}
			else{
				if(numberOfShelf > 0 && numberOfShelf < 4){
					numberOfShelf++;
				}
				else{
					numberOfShelf--;
				}
			}
		}
		
		lastNumberOfShelf = numberOfShelf;
		showNumberOfShelf();
		
		$('#draggable').animate({opacity:0.0},500,function(){
			$('#draggable').empty();
			addToys();
			$('#draggable').animate({opacity:1.0},500);
		});
		
	}
	
	function calculateScore(){
		
		usedCorrect = 0;
		usedIncorrect = 0;
		
		for(var i = 0; i < 5; i++){
			if( $('.toy:eq('+i+')').data('thisShelf') == $('.toy:eq('+i+')').data('destination') ){
				usedCorrect++;
			}
			else if( $('.toy:eq('+i+')').data('thisShelf') != -1 && $('.toy:eq('+i+')').data('destination') != -1 ){
				usedIncorrect++;
			}
		}
		
		if(usedCorrect == numberOfShelf+1 && usedIncorrect == 0){
			newGame();
			score++;
			$('#scoreContent').html(score);
		}
		
	}
	
	function showNumberOfShelf(){
		
		$('.shelf').animate({
			backgroundColor: 'rgba(0, 0, 0, 0)'
		},100);
		
		$('.shelf:eq('+numberOfShelf+')').animate({
			backgroundColor: 'rgba(206, 156, 82, 0.44)'
		},100);
		
	}
	
	function addToys(){
		var arr = [0,1,2,3,4]
		arr.sort(function(){return Math.random()-0.5;});
		for(var i = 0; i < 5; i++){
			$('<div class="toy"><img src="files/img/'+arr[i]+'.png"></div>').appendTo('#draggable').data({'thisShelf':-1,'thisParent':-1,'destination':numberOfShelf}).draggable({
				containment: '#page',
				stack: '#draggable div',
				revert: false
			}).css({'top':'11px','left':5});
		}
	}
	
	function addDroppableShelf(){
		var k = 0;
		for(var i = 0; i < 5; i++){
			
			$('.shelf:eq('+i+')').droppable({
				accept: '#draggable div',
				drop: function(event, ui){ui.draggable.draggable('option', 'revert', true);}
			});
			
			for(var j = 0; j < 5; j++){
				$('<div class="shelfDroppable"></div>').appendTo('.shelf:eq('+i+')').data({'numberOfShelf':i,'numberOfField':j,'number':k}).droppable({
					accept: '#draggable div',
					hoverClass: 'hovered',
					drop: dropFunctionShelf
				});
				k++;
			}
		}
	}
	
	function addDroppableFloor(){
		$('#floor #droppableFloor').droppable({
			accept: '#draggable div',
			hoverClass: 'floorHovered',
			drop: dropFunctionFloor
		});
	}
	
	function dropFunctionFloor(event, ui){
		ui.draggable.draggable('option', 'revert', false);
		ui.draggable.data('thisParent',-1);
		ui.draggable.data('thisShelf',-1);
		calculateScore();
	}
	
	function dropFunctionShelf(event, ui){
		
		var draggableDestination = ui.draggable.data('destination');
		var draggableThisParent = ui.draggable.data('thisParent');
		var thisNumber = $(this).data('number');
		var thisNumberOfShelf = $(this).data('numberOfShelf');
		
		ui.draggable.data('thisParent',thisNumber);
		ui.draggable.data('thisShelf',thisNumberOfShelf);
		
		var k = 0;
		
		for(var i = 0; i < 5; i++){
			if( $('.toy:eq('+i+')').data('thisParent') == thisNumber ){
				k++;
			}
		}
		
		if(k > 1){
			ui.draggable.data('thisParent',draggableThisParent);
			ui.draggable.data('thisShelf',thisNumberOfShelf);
			ui.draggable.draggable('option', 'revert', true);
		}
		else{
			ui.draggable.position({of: $(this), my: 'left+3 top+3', at: 'left top'});
			ui.draggable.draggable('option', 'revert', false);
			calculateScore();
		}
		
	}
	
	init();
	
});