$(document).ready(function(){
	
	//
	//global variables
	//
	
	var numberOfShelf;
	var lastNumberOfShelf;
	var usedCorrect;
	var usedIncorrect;
	var randomUsed;
	var score = 0;
	
	function init(){
		
		numberOfShelf = Math.floor(Math.random()*10);
		
		if(numberOfShelf == lastNumberOfShelf){
			if(numberOfShelf == 9){
				numberOfShelf--;
			}
			else if(numberOfShelf == 0){
				numberOfShelf++;
			}
			else{
				if(numberOfShelf > 0 && numberOfShelf < 9){
					numberOfShelf++;
				}
				else{
					numberOfShelf--;
				}
			}
		}
		
		lastNumberOfShelf = numberOfShelf;
		
		calculateElementsOnShelf();
		
		usedCorrect = 0;
		usedIncorrect = 0;
		$('#draggable').empty();
		$('.shelfDroppable').remove();
		
		addDroppableShelf();
		addDroppableFloor();
		
		addToys();
		
		showNumberOfShelf();
		
	}
	
	function calculateElementsOnShelf(){
		
		array_0 = [0,2,3,4,5,6,7,8,9,10];
		array_1 = [0,1,3,4,5,6,7,8,9,10];
		array_2 = [0,1,2,4,5,6,7,8,9,10];
		array_3 = [0,1,2,3,5,6,7,8,9,10];
		array_4 = [0,1,2,3,4,6,7,8,9,10];
		array_5 = [0,1,2,3,4,5,7,8,9,10];
		array_6 = [0,1,2,3,4,5,6,8,9,10];
		array_7 = [0,1,2,3,4,5,6,7,9,10];
		array_8 = [0,1,2,3,4,5,6,7,8,10];
		array_9 = [0,1,2,3,4,5,6,7,8,9];
		
		switch(lastNumberOfShelf){
			case 0: randomUsed = array_0[Math.floor(Math.random()*array_0.length)];break;
			case 1: randomUsed = array_1[Math.floor(Math.random()*array_1.length)];break;
			case 2: randomUsed = array_2[Math.floor(Math.random()*array_2.length)];break;
			case 3: randomUsed = array_3[Math.floor(Math.random()*array_3.length)];break;
			case 4: randomUsed = array_4[Math.floor(Math.random()*array_4.length)];break;
			case 5: randomUsed = array_5[Math.floor(Math.random()*array_5.length)];break;
			case 6: randomUsed = array_6[Math.floor(Math.random()*array_6.length)];break;
			case 7: randomUsed = array_7[Math.floor(Math.random()*array_7.length)];break;
			case 8: randomUsed = array_8[Math.floor(Math.random()*array_8.length)];break;
			case 9: randomUsed = array_9[Math.floor(Math.random()*array_9.length)];break;
		}
		
	}
	
	function newGame(){
		
		usedCorrect = 0;
		usedIncorrect = 0;
		
		numberOfShelf = Math.floor(Math.random()*5);
		
		if(numberOfShelf == lastNumberOfShelf){
			if(numberOfShelf == 4){
				numberOfShelf--;
			}
			else if(numberOfShelf == 0){
				numberOfShelf++;
			}
			else{
				if(numberOfShelf > 0 && numberOfShelf < 4){
					numberOfShelf++;
				}
				else{
					numberOfShelf--;
				}
			}
		}
		
		lastNumberOfShelf = numberOfShelf;
		calculateElementsOnShelf();
		showNumberOfShelf();
		
		$('#draggable').animate({opacity:0.0},500,function(){
			$('#draggable').empty();
			addToys();
			$('#draggable').animate({opacity:1.0},500);
		});
		
	}
	
	function calculateScore(){
		
		usedCorrect = 0;
		usedIncorrect = 0;
		
		for(var i = 0; i < 10; i++){
			if( $('.toy:eq('+i+')').data('thisShelf') == $('.toy:eq('+i+')').data('destination') ){
				usedCorrect++;
			}
			else if( $('.toy:eq('+i+')').data('thisShelf') != -1 && $('.toy:eq('+i+')').data('destination') != -1 ){
				usedIncorrect++;
			}
		}
		
		if(usedCorrect == numberOfShelf+1 && usedIncorrect == 0){
			newGame();
			score++;
			$('#scoreContent').html(score);
		}
		
	}
	
	function showNumberOfShelf(){
		
		$('.shelf').animate({
			backgroundColor: 'rgba(0, 0, 0, 0)'
		},100);
		
		$('.shelf:eq('+numberOfShelf+')').animate({
			backgroundColor: 'rgba(206, 156, 82, 0.44)'
		},100);
		
	}
	
	function addToys(){
		
		var arr = [0,1,2,3,4,5,6,7,8,9];
		arr.sort(function(){return Math.random()-0.5;});
		
		for(var i = 0; i < randomUsed; i++){
			$('<div class="toy"><img src="files/img/'+arr[i]+'.png"></div>').appendTo('#draggable').data({'thisShelf':lastNumberOfShelf,'thisParent':(lastNumberOfShelf*10)+i,'destination':lastNumberOfShelf}).draggable({
				containment: '#page',
				stack: '#draggable div',
				revert: false
			}).position({
				of: $( '.shelf:eq('+lastNumberOfShelf+') .shelfDroppable:eq('+i+')' ), my: 'left+3 top+3', at: 'left top'
			}).css({'position':'absolute'});
		}
		
		for(var i = 0; i < 10-randomUsed; i++){
			var left = (45+(i*50));
			$('<div class="toy"><img src="files/img/'+arr[i+randomUsed]+'.png"></div>').appendTo('#draggable').data({'thisShelf':-1,'thisParent':-1,'destination':numberOfShelf}).draggable({
				containment: '#page',
				stack: '#draggable div',
				revert: false
			}).css({'top':'11px','left':left,'position':'absolute'});
		}
		
	}
	
	function addDroppableShelf(){
		var k = 0;
		for(var i = 0; i < 10; i++){
			
			$('.shelf:eq('+i+')').droppable({
				accept: '#draggable div',
				drop: function(event, ui){ui.draggable.draggable('option', 'revert', true);}
			});
			
			for(var j = 0; j < 10; j++){
				$('<div class="shelfDroppable"></div>').appendTo('.shelf:eq('+i+')').data({'numberOfShelf':i,'numberOfField':j,'number':k}).droppable({
					accept: '#draggable div',
					hoverClass: 'hovered',
					drop: dropFunctionShelf
				});
				k++;
			}
			
		}
	}
	
	function addDroppableFloor(){
		$('#floor #droppableFloor').droppable({
			accept: '#draggable div',
			hoverClass: 'floorHovered',
			drop: dropFunctionFloor
		});
	}
	
	function dropFunctionFloor(event, ui){
		ui.draggable.draggable('option', 'revert', false);
		ui.draggable.data('thisParent',-1);
		ui.draggable.data('thisShelf',-1);
		calculateScore();
	}
	
	function dropFunctionShelf(event, ui){
		
		var draggableDestination = ui.draggable.data('destination');
		var draggableThisParent = ui.draggable.data('thisParent');
		var thisNumber = $(this).data('number');
		var thisNumberOfShelf = $(this).data('numberOfShelf');
		
		ui.draggable.data('thisParent',thisNumber);
		ui.draggable.data('thisShelf',thisNumberOfShelf);
		
		var k = 0;
		
		for(var i = 0; i < 10; i++){
			if( $('.toy:eq('+i+')').data('thisParent') == thisNumber ){
				k++;
			}
		}
		
		if(k > 1){
			ui.draggable.data('thisParent',draggableThisParent);
			ui.draggable.data('thisShelf',thisNumberOfShelf);
			ui.draggable.draggable('option', 'revert', true);
		}
		else{
			ui.draggable.position({of: $(this), my: 'left+3 top+3', at: 'left top'});
			ui.draggable.draggable('option', 'revert', false);
			calculateScore();
		}
		
	}
	
	init();
	
});