var app = {
    configuration: {
        game: {
            buildings: [
                {
                    id: 1,
                    name: "Obora"
                },
                {
                    id: 2,
                    name: "Stajnia"
                },
                {
                    id: 3,
                    name: "Chlew"
                },
                {
                    id: 4,
                    name: "Kurnik"
                }
            ],
            animals: [
                {
                    id: 1,
                    animalImg: 'img/cow.png',
                    buildingId: 1
                },
                {
                    id: 2,
                    animalImg: 'img/duck.png',
                    buildingId: 4
                },
                {
                    id: 3,
                    animalImg: 'img/piggy.png',
                    buildingId: 3
                },
                {
                    id: 4,
                    animalImg: 'img/goose.png',
                    buildingId: 4
                },
                {
                    id: 5,
                    animalImg: 'img/hen.png',
                    buildingId: 4
                },
                {
                    id: 6,
                    animalImg: 'img/horse.png',
                    buildingId: 2
                }
            ]
        }
    },
    init: function () {
        $('#success, #wrongAnswer').hide();
        $.each(this.configuration.game.animals, function (index, item) {
            $('div#animals').append('<img class="img-responsive draggable" src="' + item.animalImg + '" draggable="true" data-building-id=' + item.buildingId + ' data-id=' + item.id + '>');
        });

        var ul = document.querySelector('div#animals');
        for (var i = ul.children.length; i >= 0; i--) {
            ul.appendChild(ul.children[Math.random() * i | 0]);
        }

        ul = document.querySelector('div#buildings');
        for (var i = ul.children.length; i >= 0; i--) {
            ul.appendChild(ul.children[Math.random() * i | 0]);
        }

        $('div#animals, div.building').append('<div class="clearfix"></div>');
    },
    checkGame: function () {
        var _valid = true;
        if ($('div#animals img').length > 0) {
            _valid = false;
        }

        $('div.building').each(function (index, item) {
            $('img', item).each(function (_index, _item) {
                if ($(_item).data('building-id') !== $(item).data('building-id')) {
                    _valid = false;
                }
            });
        });

        if (_valid === true) {
            $('.row').hide();
            $('body').css('background-image', 'url(img/bg.jpg)').css('background-size', '100%');
            $('#success').slideToggle();
        }

        return _valid;
    }
};

$(document).ready(function () {
    app.init();

    $('img').draggable({
        revert: 'invalid'
    });
    $('.building').droppable({
        accept: '.draggable',
        drop: function (evt, ui) {
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).insertBefore($('.clearfix', this));

            $(this).removeClass('activeDrop');

            app.checkGame();
        },
        over: function (event, ui) {
            $(this).addClass('activeDrop');
        },
        out: function (event, ui) {
            $(this).removeClass('activeDrop');
        }
    });

    $(document).on('click', 'a#check, a#check img', function () {
        if (app.checkGame() === false) {
            $('#wrongAnswer').show();
        }
        return false;
    });

    $(document).on('click', '#wrongAnswer', function () {
        $(this).hide();
    });

    $(document).on('click', '#reload', function () {
        location.reload();
    });
});