var app = {
    configuration: {
        game: {
            words: [
                {
                    id: 1,
                    text: "krowa",
                    group: 2
                },
                {
                    id: 2,
                    text: "łoś",
                    group: 1
                },
                {
                    id: 3,
                    text: "ryś",
                    group: 1
                },
                {
                    id: 4,
                    text: "wilk",
                    group: 1
                },
                {
                    id: 5,
                    text: "sarna",
                    group: 2
                },
                {
                    id: 6,
                    text: "mysz",
                    group: 1
                },
                {
                    id: 7,
                    text: "jeż",
                    group: 1
                },
                {
                    id: 8,
                    text: "bocian",
                    group: 2
                },
                {
                    id: 9,
                    text: "łabędź",
                    group: 2
                },
                {
                    id: 10,
                    text: "kaczka",
                    group: 2
                },
                {
                    id: 11,
                    text: "motyl",
                    group: 2
                },
                {
                    id: 12,
                    text: "kogut",
                    group: 2
                },
                {
                    id: 13,
                    text: "wróbel",
                    group: 2
                },
                {
                    id: 14,
                    text: "lis",
                    group: 1
                },
                {
                    id: 15,
                    text: "gawron",
                    group: 2
                },
            ]
        }
    },
    init: function () {
        $('#success, #wrongAnswer').hide();
        var id = 0;
        $.each(this.configuration.game.words, function (index, item) {
            $('#words').append('<span draggable="true" data-group-id=' + item.group + ' data-id=' + item.id + ' class="draggable">' + item.text + '</span>');
        });

        //Shuffle coins
        var ul = document.querySelector('div#words');
        for (var i = ul.children.length; i >= 0; i--) {
            ul.appendChild(ul.children[Math.random() * i | 0]);
        }


        $("#words").append('<div class="clearfix" ></div>');
    },
    checkGame: function () {
        var _valid = true;

        if ($('div#words span').length > 0) {
            _valid = false;
        }

        $("div.wordgroup").each(function (index, item) {
            $('span', item).each(function (_index, _item) {
                if ($(_item).data('group-id') !== $(item).data('group-id')) {
                    _valid = false;
                }
            });
        });

        if (_valid === true) {
            $('.row').hide();
            $('body').css('background-image', 'url(img/bg.jpg)').css('background-size', '100%');
            $('#success').slideToggle();
        }

        return _valid;
    }
};

$(document).ready(function () {
    app.init();

    $('span').draggable({
        revert: 'invalid'
    });
    $('#words, .wordgroup').droppable({
        accept: '.draggable',
        drop: function (evt, ui) {
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).insertBefore($('div.clearfix', this));
            $(this).removeClass('activeDrop');

            app.checkGame();
        },
        over: function (event, ui) {
            $(this).addClass('activeDrop');
        },
        out: function (event, ui) {
            $(this).removeClass('activeDrop');
        }
    });

    $(document).on('click', 'div.wordgroup, div#words', function () {
        if ($('.selected').length === 1) {
            $('span.selected').insertBefore($('div.clearfix', this));

            $('.selected').removeClass('selected');
        }
    });

    $(document).on('click', 'a#check, a#check img', function () {
        if (app.checkGame() === false) {
            $('#wrongAnswer').show();
        }
        return false;
    });

    $(document).on('click', '#wrongAnswer', function () {
        $(this).hide();
    });

    $(document).on('click', '#reload', function () {
        location.reload();
    });
});