$(document).ready(function(){
	
	//
	//global variables
	//
	
	var direction;
	var path;
	var directions = ['<','>'];
	var animateShowDecsription = 0;
	var animateEndGame = 0;
	var options = ['_0','_1','_2','_3','_4','_5','_6','_7'];
	var viewsReset = 1;
	var optionClick = 0;
	
	insertSelect();
	$(init);
	
	function createField(){
		
		$('#droppableReset').css('display','block');
		$('#droppable').css('display','block');
		$('#draggable').css('display','block');
		viewsReset = 0;
		
		//create draggable
		var numbers = [0,1,2,3,4,5,6,7,8,9];
		numbers.sort(function(){return 0.5 - Math.random()});
		
		for(var i = 0; i < 10; i++){
			
			//random top
			var top = Math.floor(Math.random()*150);
			
			//set variable to an images
			var img ='<div><img src="files/img/'+path+'/'+numbers[i]+'.png" /></div>'
			
			$(img).data('parent',-1).data('child',numbers[i]).appendTo('#draggable').draggable({
				containment: '#page',
				stack: '#draggable div',
				revert: false
			}).addClass('draggable').css('top',top);
			
		}
		
		//create droppable
		if(direction == 0){
		
			for(var i = 0; i < 10; i++){
				$('<div></div>').data('number',i).appendTo('#droppable').droppable({
					accept: '#draggable div',
					hoverClass: 'hovered',
					drop: dropDraggable
				}).addClass('droppable');
			}
			
		}
		else{
		
			for(var i = 9; i >= 0; i--){
				$('<div></div>').data('number',i).appendTo('#droppable').droppable({
					accept: '#draggable div',
					hoverClass: 'hovered',
					drop: dropDraggable
				}).addClass('droppable');
			}
			
		}
		
		//droppable reset
		$('#droppableReset').droppable({
			accept: '#draggable div',
			hoverClass: 'hovered',
			drop: dropDraggableReset
		});
		
	}
	
	function showDescription(){
		if(animateShowDecsription == 0){
			$('#description').html(directions[direction]).fadeIn(1000);
			$('#description').fadeOut(1000,function(){
				if(animateEndGame == 0){
					$('#currentDirection').animate({
						backgroundColor: "rgb(255, 0, 0)"
					},200,function(){
						$(this).animate({
							backgroundColor: "rgb(0, 170, 62)",
						},200,function(){
							animateShowDecsription = 0;
						});
					});
				}
			});
			animateShowDecsription = 1;
		}
	}
	
	function dropDraggable(event, ui){
		
		var scoreGood = 0;
		var scoreBad = 0;
		
		var numberThisField = $(this).data('number');
		
		//ui-draggable
		var childNumber = ui.draggable.data('child');
		var parentNumber = ui.draggable.data('parent');
		
		//force
		ui.draggable.data('parent', numberThisField);
		
		var repeat = 0;
		
		//0,1,2,3
		for(var i = 0; i < 10; i++){
			
			if( numberThisField == $('.ui-draggable:eq('+i+')').data('parent') ){
				repeat++;
			}
			
		}
		
		if(repeat > 1){
			//force
			ui.draggable.data('parent', parentNumber);
			ui.draggable.draggable('option', 'revert', true);
		}
		else{
			ui.draggable.position({of: $(this), my: 'left+2 top+4', at: 'left top'});
			ui.draggable.draggable('option', 'revert', false);
		}
		
		
		//0,1,2,3
		for(var i = 0; i < 10; i++){
		
			var parent = $('.ui-draggable:eq('+i+')').data('parent');
			var child = $('.ui-draggable:eq('+i+')').data('child');
			
			if(parent == child){
				scoreGood++;
			}
			else{
				if(parent != -1){
					scoreBad++;
				}
			}
			
		}
		
		//maximum score
		if(scoreGood == 10){
			showAnimateEndGame();
		}
		else{
			if(scoreGood + scoreBad == 10){
				showDescription();
			}
		}
		
	}
	
	function showAnimateEndGame(){
		if(animateEndGame == 0){
			$('#currentDirection').css('background','rgb(0, 170, 62)');
			$('#cover').css('display','block');
			$('#smile').fadeIn(1000);
			$('#smile').fadeOut(1000,function(){
				$('#cover').css('display','none');
				animateEndGame = 0;
				showSelectStyle();
			});
			animateEndGame = 1;
		}
	}
	
	function dropDraggableReset(event, ui){
		ui.draggable.data('parent',-1);
		ui.draggable.draggable('option', 'revert', false);
	}
	
	function showSelectStyle(){
		
		$('#description').css('display','none');
		$('#droppableReset').empty().css('display','none');
		$('#droppable').empty().css('display','none');
		$('#draggable').empty().css('display','none');
		$('#select').css({'display':'block','opacity':'1'});
		
	}
	
	function insertSelect(){
		
		for(var i = 0; i < options.length; i++){
			$('<div class="option"><div><img src="files/img/'+options[i]+'/5.png"></div></div>').data('option',options[i]).appendTo('#selectContent');
		}
		
		$('<div id="directions"></div>').appendTo('#selectContent');
		
		for(var i = 0; i < 2; i++){
			$('<div class="direction">'+directions[i]+'</div>').data('direction',i).appendTo('#directions');
		}
		
	}
	
	function init(){
		
		direction = 0;
		$('.direction:eq(0)').css({'border':'solid 2px rgb(0, 0, 0)'});
		$('#currentDirection').html(directions[direction]);
		
		showSelectStyle();
		
		$('#reset').click(function(){
			if(viewsReset == 0){
				showSelectStyle();
				viewsReset = 1;
			}
			else{
				location.reload();
			}
		});
		
		$('.direction').click(function(){
			if(optionClick == 0){
				$('.direction').css({'border':'dashed 2px rgb(255, 255, 255)'});
				$(this).css({'border':'solid 2px rgb(0, 0, 0)'});
				direction = $(this).data('direction');
				$('#currentDirection').html(directions[direction]);
			}
		});
		
		$('.option').click(function(){
			if(optionClick == 0){
				optionClick = 1;
				animateShowDecsription = 0;
				path = $(this).data('option');
				$('#select').fadeOut(500,function(){
					optionClick = 0;
					createField();
				});
			}
		});
			
	}
	
});