$(document).ready(function(){
	
	var showQuestion = 0;
	var numberOfImages = 4;
	$(init);

	function init(){
		var possible = [
			{a:{a:1,b:0,c:3,d:2}},
			{a:{a:1,b:2,c:3,d:0}},
			{a:{a:1,b:3,c:0,d:2}},
			{a:{a:2,b:0,c:3,d:1}},
			{a:{a:2,b:3,c:0,d:1}},
			{a:{a:2,b:3,c:1,d:0}},
			{a:{a:3,b:0,c:1,d:2}},
			{a:{a:3,b:2,c:0,d:1}},
			{a:{a:3,b:2,c:1,d:0}}
		];
		var possibleRandom = possible[Math.floor(Math.random()*possible.length)];
		var a = possibleRandom['a']['a'];
		var b = possibleRandom['a']['b'];
		var c = possibleRandom['a']['c'];
		var d = possibleRandom['a']['d'];
		var possible = [a,b,c,d];
		for(var i = 0; i < possible.length; i++){
			var top = Math.floor((Math.random()*220)+200);
			var img = '<div>'+'<img src="files/img/'+possible[i]+'.png">'+'</div>';
			$(img).data({'child':possible[i],'parent':-1}).appendTo('#draggable').draggable({
				containment: '#page-touch',
				stack: '#draggable div',
				revert: false
			}).css({'top':top,'left':10});
		}
		for(var i = 0; i < possible.length; i++){
			$('<div></div>').data('number',i).appendTo('#droppable0').droppable({
				accept: '#draggable div',
				hoverClass: 'hovered',
				drop: drop0
			});
		}
		$('#droppable1').droppable({
			accept: '#draggable div',
			hoverClass: 'hovered',
			drop: drop1
		});
	}
	function drop0(event, ui){
		var result = 0;
		var parentNotIsNULL = 0;
		var numberThisField = $(this).data('number');
		var childNumber = ui.draggable.data('child');
		var parentNumber = ui.draggable.data('parent');
		ui.draggable.data('parent', numberThisField);
		var repeat = 0;
		for(var i = 0; i < numberOfImages; i++){
			if( numberThisField == $('.ui-draggable:eq('+i+')').data('parent') ){
				repeat++;
			}
		}
		if(repeat > 1){
			ui.draggable.data('parent', parentNumber);
			ui.draggable.draggable('option', 'revert', true);
		}
		else{
			ui.draggable.position({of: $(this), my: 'left top', at: 'left top'});
			ui.draggable.draggable('option', 'revert', false);
		}
		for(var i = 0; i < numberOfImages; i++){
			var parent = $('.ui-draggable:eq('+i+')').data('parent');
			var child = $('.ui-draggable:eq('+i+')').data('child');
			if(parent != -1){
				parentNotIsNULL++;
			}
			if(parent == child){
				$('.ui-droppable:eq('+child+')').css('border', 'solid 2px #14FF00');
				result++;
			}
			else{
				$('.ui-droppable:eq('+child+')').css('border', 'dashed 2px #C4C4C4');
			}
		}
		if(result == numberOfImages && parentNotIsNULL == numberOfImages){
			$("#question").css('display','none');
			$("#cover").fadeIn("slow");
			$("#message").fadeIn("slow");
		}
		if(result != numberOfImages && parentNotIsNULL == numberOfImages && showQuestion == 0){
			showQuestion = 1;
			$("#question").fadeIn(1500);
			$("#question").fadeOut(3000,function(){
				showQuestion = 0;
			});
		}
	}
	function drop1(event, ui){
		ui.draggable.draggable('option', 'revert', false);
		ui.draggable.data('parent', '-1');
		for(var i = 0; i < numberOfImages; i++){
			var parent = $('.ui-draggable:eq('+i+')').data('parent');
			var child = $('.ui-draggable:eq('+i+')').data('child');
			if(parent == child){
				$('.ui-droppable:eq('+child+')').css('border', 'solid 2px #14FF00');
			}
			else{
				$('.ui-droppable:eq('+child+')').css('border', 'dashed 2px #C4C4C4');
			}
		}
	}
	
	$('#reset').click(function(){
		$('#draggable').empty();
		$('#droppable0').empty();
		$('#message').css({'display':'none'});
		$('#cover').css({'display':'none'});
		$(init);
	});
	
});