$(document).ready(function(){
	
	var words = [
		{destination:2,word:'sarna'},
		{destination:1,word:'jeż'},
		{destination:1,word:'mysz'},
		{destination:5,word:'wiewiórka'},
		{destination:3,word:'bocian'},
		{destination:2,word:'żaba'},
		{destination:3,word:'sikorka'},
		{destination:1,word:'wilk'},
		{destination:1,word:'lis'},
		{destination:1,word:'szpak'},
		{destination:1,word:'bóbr'},
		{destination:2,word:'królik'},
		{destination:2,word:'kaczka'},
		{destination:2,word:'zając'},
	];
	var fields = [
		{title:'1 samogłoska',name:1},
		{title:'2 samogłoski',name:2},
		{title:'3 samogłoski',name:3},
		{title:'5 samogłosek',name:5},
	];
	function loadWords(){
		var top = 5;
		$('<div id="draggable"></div>').appendTo('#page');
		for(var i = 0; i < words.length; i++){
			$('<div class="text">'+words[i]['word']+'</div>').data({'parent':-1,'destination':words[i]['destination']}).appendTo('#draggable').draggable({
				containment: '#page',
				stack: '#draggable div',
				revert: false,
			}).css({'top':top,'left':(10+(i*2))});
		}
		$('<div id="droppableReset"></div>').appendTo('#page').droppable({
			accept: '#draggable div',
			hoverClass: 'hovered',
			drop: drop1
		});
		$('<div id="smile"></div>').html(':)').appendTo('#droppableReset');
	}
	function drop1(event,ui){
		ui.draggable.data('parent',-1);
		checkEnd();
	}
	function loadFields(){
		for(var i = 0; i < fields.length; i++){
			$('<div class="field"><div id="title"><div id="titleContent">'+fields[i]['title']+'</div></div></div>').appendTo('#page');
			$('<div class="droppable"></div><div class="pseudo"></div>').data({'name':fields[i]['name']}).appendTo('.field:eq('+i+')').droppable({
				accept: '#draggable div',
				hoverClass: 'hovered',
				drop: drop0
			});
		}
	}
	function drop0(event,ui){
		var thisName = $(this).data('name');
		ui.draggable.data('parent',thisName);
		checkEnd();
	}
	function checkEnd(){
		var score = 0;
		for(var i = 0; i < words.length; i++){
			if($('.text:eq('+i+')').data('parent') == $('.text:eq('+i+')').data('destination')){
				score++;
			}
		}
		if(score == words.length){
			$('#smile').css({'display':'block'});
		}
		else{
			$('#smile').css({'display':'none'});
		}
	}
	function init(){
		words.sort(function(){return 0.5 - Math.random()});
		loadFields();
		loadWords();
		$('<div id="reset"><img src="files/img/reset.png" style="width: 28px;"></div>').appendTo('#droppableReset').click(function(){
			reset();
		});
	}
	$(init);
	function reset(){
		$('#reset').remove();
		$('.field').remove();
		$('#draggable').remove();
		$('#droppableReset').remove();
		$(init);
	}
});