$(document).ready(function(){
	
	var colorStandard = '#fff';
	var colorHover    = '#ABEBFF';
	var colorActive   = 'rgb(81, 213, 255)';
	var calculate = function (a) {
		return new Function('return ' + a)();
	};
	var options = [
		{dir:'0',name:'ołówek'},
		{dir:'1',name:'linijka'},
		{dir:'2',name:'długopis'},
		{dir:'3',name:'gumka'},
		{dir:'4',name:'nożyczki'},
		{dir:'5',name:'flamastry'},
		{dir:'6',name:'piórnik'},
		{dir:'7',name:'temperówka'},
		{dir:'8',name:'cyrkiel'},
		{dir:'9',name:'klej'},
		{dir:'10',name:'kredki'},
	];
	var usedValues = [];
	function loadCash(){
		var values = [];
		usedValues = [];
		var notUsed = 0;
		for(var i = 0; i < options.length; i++){
			if( $('.task:eq('+i+')').data('used') == 1 ){
				values.push({number:i,val:$('.task:eq('+i+')').find('input').val()});
				if($('.task:eq('+i+')').find('input').val() === ''){
					notUsed++;
				}
			}
		}
		if(notUsed > 0){
			$('#sumContent').html('Podaj ceny');
			$('#sum').css({'background':colorStandard}).data('used',0);
			return false;
		}
		if(values.length > 0){
			$('#sumContent').html('');
			for(var i = 0; i < values.length; i++){
				$('<div class="pseudoInput">'+values[i]['val']+'</div>').appendTo('#sumContent');
				if(i < values.length-1){
					$('<div class="textNextInput">+</div>').appendTo('#sumContent');
				}
				else{
					$('<div class="textNextInput">=</div>').appendTo('#sumContent');
					$('<input id="checkSum" type="text" />').keypress(function(e){
						if(e.value === '0'){
							return false;
						}
						var key = (e.which) ? e.which : event.keyCode;
						if(key == 13){
							return true;
						}
						if(key > 31 && (key < 48 || key > 57)){
							return false;
						}
						if($(this).val() === '0'){
							return false;
						}
						if($(this).val().length > 1){
							return false;
						}
						return true;
					}).appendTo('#sumContent');
				}
			}
			$('<input type="button" value="Sprawdź" />').click(function(){
				$('#smile').css({'display':'none'});
				var values = '';
				for(var i = 0; i < options.length; i++){
					if( $('.task:eq('+i+')').data('used') == 1 ){
						values = values + '+' + $('.task:eq('+i+')').find('input').val();
					}
				}
				console.log(calculate(values) +','+ parseInt($('#checkSum').val()));
				if(calculate(values) != parseInt($('#checkSum').val())){
					$("#cover").fadeIn("slow");
					$("#question").fadeIn("slow",function(){
						$("#question").fadeOut("slow");
						$("#cover").fadeOut("slow");
					});
				}
				else{
					$('#smile').css({'display':'block'});
				}
			}).appendTo('#sumContent');
		}
		else{
			$('#sumContent').html('Wybierz produkty');
		}
	}
	
	function hideCash(){
		$('#sumContent').html('Wybierz produkty');
		$('#sum').css({'background':colorStandard}).data('used',0);
		$('#smile').css({'display':'none'});
	}
	
	function init(){
		$('#page').empty();
		options.sort(function(){return 0.5 - Math.random()});
		$('<div class="pseudo"></div>').appendTo('#page');
		for(var i = 0; i < options.length; i++){
			var img = '<div class="img"><img src="files/img/'+options[i]['dir']+'.png"></div>';
			var text = '<div class="text">'+options[i]['name']+'</div>';
			var inputText = '<input type="text" />';
			$('<div class="task task-hover"></div>').appendTo('#page');
			$(img+text).appendTo('.task:eq('+i+')');
			$(inputText).keydown(function(e){
				var key = e.which;
				if ($.inArray(e.keyCode, [46, 8, 27, 13]) !== -1 || (e.keyCode == 65 && e.ctrlKey === true) ||	(e.keyCode >= 35 && e.keyCode <= 39)) {
					return true;
				}
				if((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)){
					return false;
				}
				if($(this).val() === '0'){
					return false;
				}
				if($(this).val().length > 1){
					return false;
				}
				return true;
			}).css({'display':'none'}).appendTo('.task:eq('+i+')');
			$('.task:eq('+i+')').data({'used':0,'price':-1});
		}
		$('<div id="smile"></div>').html(':)').appendTo('#page');
		$('<div id="reset"><img src="files/img/reset.png"></div>').appendTo('#page');
		$('<div class="pseudo"></div>').appendTo('#page');
		$('<div id="sum"><div id="sumContent">Wybierz produkty</div></div>').appendTo('#page');
		$('<div class="pseudo"></div>').appendTo('#page');
		$('.task').hover(function(){
			if( $(this).data('used') != 1 ){
				$(this).css('background', colorHover);
			}
		},function(){
			if( $(this).data('used') != 1 ){
				$(this).css('background', colorStandard);
			}
			else{
				$(this).css('background', colorActive);
			}
		});
		$('.task').click(function(){
			if(document.activeElement.nodeName === 'INPUT'){
				return false;
			}
			for(var i = 0; i < options.length; i++){
				var element = $('.task').eq(i);
				if(element.data('used') != 1){
					element.css('background', colorStandard);	
					element.find('input').css({'display':'none'});
				}
			}
			if($(this).data('used') != 1){
				$(this).css('background', colorActive);
				$(this).data('used',1);
				$(this).find('input').css({'display':'block'});
			}
			else{
				$(this).css('background', colorHover);
				$(this).data('used',0);
				$(this).find('input').css({'display':'none'});
			}
			hideCash();
		});
		$('#sum').hover(function(){
			if( $(this).data('used') != 1 ){
				$(this).css('background', colorHover);
			}
			},function(){
			if( $(this).data('used') != 1 ){
				$(this).css('background', colorStandard);
			}
			else{
				$(this).css('background', colorActive);
			}
		}).click(function(){
			var used = $(this).data('used');
			if(used == 0){
				$(this).css({'background':colorActive}).data('used',1);
				loadCash();
			}
		});
		$('<div id="question"></div>').appendTo('body');
		$('<div id="cover"></div>').appendTo('body');
		$('#reset').click(function(){
			reset();
		});
	}
	
	function reset(){
		$('#question').remove();
		$('#cover').remove();
		$(init);
	}
	
	$(init);
	
});