$(document).ready(function(){
	
	var colorStandard = '#fff';
	var colorHover    = '#ABEBFF';
	var colorActive   = 'rgb(81, 213, 255)';
	var calculate = function (a) {
		return new Function('return ' + a)();
	};
	var options = [
		{price:3,dir:'files/img/0.jpg',name:'plecak'},
		{price:1,dir:'files/img/1.jpg',name:'muzyka'},
		{price:2,dir:'files/img/2.jpg',name:'przewodnik'},
		{price:1,dir:'files/img/3.jpg',name:'ramka na zdjęcia'},
		{price:4,dir:'files/img/4.jpg',name:'rolki'},
		{price:2,dir:'files/img/5.jpg',name:'rozmówki angielko polskie'},
		{price:2,dir:'files/img/6.jpg',name:'słownik polsko angielski'},
		{price:3,dir:'files/img/7.jpg',name:'sprzęt muzyczny'},
		{price:7,dir:'files/img/8.jpg',name:'sukienka'},
		{price:8,dir:'files/img/9.jpg',name:'zegarek'},
		{price:9,dir:'files/img/10.jpg',name:'zjeżdżalnia'},
	];
	function loadCash(){
		var values = [];
		for(var i = 0; i < options.length; i++){
			if( $('.task:eq('+i+')').data('used') == 1 ){
				values.push({number:i,val:$('.task:eq('+i+')').data('price')});
			}
		}
		if(values.length > 1){
			$('#sumContent').html('');
			for(var i = 0; i < values.length; i++){
				$('<div class="pseudoInput">'+values[i]['val']+'</div>').appendTo('#sumContent');
				if(i < values.length-1){
					$('<div class="textNextInput">+</div>').appendTo('#sumContent');
				}
				else{
					$('<div class="textNextInput">=</div>').appendTo('#sumContent');
					$('<input id="checkSum" type="text" />').keypress(function(e){
						if(e.value === '0'){
							return false;
						}
						var key = (e.which) ? e.which : event.keyCode;
						if(key == 13){
							return true;
						}
						if(key > 31 && (key < 48 || key > 57)){
							return false;
						}
						if($(this).val() === '0'){
							return false;
						}
						if($(this).val().length > 1){
							return false;
						}
						return true;
					}).appendTo('#sumContent');
				}
			}
			$('<input type="button" value="Sprawdź" />').click(function(){
				$('#smile').css({'display':'none'});
				var values = '';
				for(var i = 0; i < options.length; i++){
					if( $('.task:eq('+i+')').data('used') == 1 ){
						values = values + '+' + $('.task:eq('+i+')').data('price');
					}
				}
				if(calculate(values) != parseInt($('#checkSum').val())){
					$("#cover").fadeIn("slow");
					$("#question").fadeIn("slow",function(){
						$("#question").fadeOut("slow");
						$("#cover").fadeOut("slow");
					});
				}
				else{
					$('#smile').css({'display':'block'});
				}
			}).appendTo('#sumContent');
		}
		else{
			$('#sumContent').html('Wybierz miniumum 2 produkty');
		}
	}
	
	function hideCash(){
		$('#sumContent').html('Wybierz miniumum 2 produkty');
		$('#sum').css({'background':colorStandard}).data('used',0);
		$('#smile').css({'display':'none'});
	}
	
	function init(){
		$('#page').empty();
		options.sort(function(){return 0.5 - Math.random()});
		$('<div class="pseudo"></div>').appendTo('#page');
		for(var i = 0; i < options.length; i++){
			var img = '<div class="img"><img src="'+options[i]['dir']+'"></div>';
			var text = '<div class="text">'+options[i]['name']+'</div>';
			var pseudoInput = '<div class="pseudoInput">'+options[i]['price']+'zł</div>';
			$('<div class="task task-hover"></div>').appendTo('#page');
			$(img+text).appendTo('.task:eq('+i+')');
			$(pseudoInput).appendTo('.task:eq('+i+')');
			$('.task:eq('+i+')').data({'used':0,'price':options[i]['price']});
		}
		$('<div id="smile"></div>').html(':)').appendTo('#page');
		$('<div id="reset"><img src="files/img/reset.png"></div>').appendTo('#page');
		$('<div class="pseudo"></div>').appendTo('#page');
		$('<div id="sum"><div id="sumContent">Wybierz miniumum 2 produkty</div></div>').appendTo('#page');
		$('<div class="pseudo"></div>').appendTo('#page');
		$('.task').hover(function(){
			if( $(this).data('used') != 1 ){
				$(this).css('background', colorHover);
			}
		},function(){
			if( $(this).data('used') != 1 ){
				$(this).css('background', colorStandard);
			}
			else{
				$(this).css('background', colorActive);
			}
		});
		$('.task').click(function(){
			for(var i = 0; i < options.length; i++){
				var element = $('.task').eq(i);
				if(element.data('used') != 1){
					element.css('background', colorStandard);	
					element.find('input').css({'display':'none'});
				}
			}
			if($(this).data('used') != 1){
				$(this).css('background', colorActive);
				$(this).data('used',1);
				$(this).find('input').css({'display':'block'});
			}
			else{
				$(this).css('background', colorHover);
				$(this).data('used',0);
				$(this).find('input').css({'display':'none'});
			}
			loadCash();
		});
		$('<div id="question"></div>').appendTo('body');
		$('<div id="cover"></div>').appendTo('body');
		$('#reset').click(function(){
			reset();
		});
	}
	
	function reset(){
		$('#question').remove();
		$('#cover').remove();
		$(init);
	}
	
	$(init);
	
});