$(document).ready(function(){

	function init(){
		var result = 0;
		var standard = '#fff';
		var hover    = '#ABEBFF';
		var active   = 'rgb(81, 213, 255)';
		var bad      = 'rgb(255, 121, 121)';
		var good     = 'rgb(137, 255, 81)';
		var answers = [
			{a:'1',b:'poniedziałek'},
			{a:'2',b:'wtorek'},
			{a:'3',b:'środa'},
			{a:'4',b:'czwartek'},
			{a:'5',b:'piątek'},
			{a:'6',b:'sobota'},
			{a:'7',b:'niedziela'},
		];
		answers.sort(function(){return 0.5 - Math.random()});
		for(var  i = 0; i < answers.length; i++){
			$('<div class="sentence sentence-hover"><div class="sentence-content"><input id="'+answers[i]['a']+'" type="text" placeholder="......." /><div class="text">'+answers[i]['b']+'</div><input type="button" value="Sprawdź" /></div></div>').appendTo('#container');
		}
		for(var  i = 0; i < answers.length; i++){
			$('.sentence:eq('+i+')').data('active',0).data('used',0).data('complete',0);
		}
		$(document).click(function(){
			if(document.activeElement.tagName === 'BODY'){
				$('.sentence').data('active',0);
				for(var i = 0; i < answers.length; i++){
					var element = $('.sentence').eq(i);
					if(element.data('used') != 1){
						element.css('background', standard);	
					}
				}
			}
		});
		$(document).keypress(function(e){
			if(e.which == 13) {
				var activeElement = document.activeElement;
				if(activeElement.tagName === 'INPUT'){
					var parent = activeElement.parentNode.parentNode;
					$(parent).data('used',1);
					var inputValue = activeElement.value.trim();
					var answer = activeElement.id;
					if(inputValue === answer){
						$(activeElement).val(inputValue);
						$(activeElement).prop('disabled', true);
						$(activeElement).nextAll('input').hide();
						$(parent).data('complete',1);
						$(parent).css('cursor','auto');
						$(parent).css('background', good);
						$(parent).find('.suggestions').hide();
						result++;
					}
					else{
						$(parent).css('background', bad);
					}
					if(result == answers.length){
						$("#cover").fadeIn("slow");
						$("#message").fadeIn("slow");
					}
				}
			}
		});
		$('.sentence').hover(function(){
			if($(this).data('active') != 1 && $(this).data('used') != 1){
				$(this).css('background', hover);
			}
		},function(){
			if($(this).data('complete') != 1 && $(this).data('used') == 1){
				$(this).css('background', bad);
			}
			if($(this).data('active') == 1 && $(this).data('used') != 1 ){
				$(this).css('background', active);
			}
			if($(this).data('active') == 0 && $(this).data('used') != 1){
				$(this).css('background', standard);
			}
		});
		$('input[type="button"]').click(function(){
			var text = $(this).prevAll('input');
			var value = text.val().trim();
			var answer = $(this).prevAll('input').attr('id');
			var parent = $(this).parent().parent();
			parent.data('used',1);
			if(value === answer){
				$(this).hide();
				text.prop('disabled', true);
				text.val(value);
				parent.data('complete',1);
				parent.css('cursor','auto');
				parent.css('background', good);
				parent.find('.suggestions').hide();
				result++;
			}
			if(result == answers.length){
				$("#cover").fadeIn("slow");
				$("#message").fadeIn("slow");
			}
		});
		$('.sentence').click(function(){
			$('.sentence').data('active',0);
			for(var i = 0; i < 20; i++){
				var element = $('.sentence').eq(i);
				if(element.data('used') != 1){
					element.css('background', standard);	
				}
			}
			$(this).data('active',1);
			if($(this).data('complete') != 1){
				if($(this).data('used') != 1){
					$(this).css('background', active);
				}
				else{
					$(this).css('background', bad);
				}
				$(this).find('input[type=text]').focus();
			}
		});
	}
	
	$(init);
	
	$('#reset').click(function(){
		$('.sentence').remove();
		$(init);
	});
});