$(document).ready(function(){
	
	var parentsDone = [];
	var childrenDone = [];
	var colors = [
			{color:'red'},
			{color:'green'},
			{color:'blue'},
			{color:'yellow'},
			{color:'orange'},
	];
	
	function loadParents(){
		
		for(var i = 0; i < parentsDone.length; i++){
			var img = '<div class="parentImg"><img src="files/img/parent'+parentsDone[i]['parent']+'" /></div>';
			var colorBox0 = '<div class="colorBox0"></div>';
			$(img).appendTo('.parent:eq('+i+')');
			$(colorBox0).css({'background':parentsDone[i]['color']}).appendTo('.parent:eq('+i+')');
		}
		
	}
	
	function loadChildren(){
		
		for(var i = 0; i < childrenDone.length; i++){
			var img = '<div class="childImg"><img src="files/img/child'+childrenDone[i]['child']+'" /></div>';
			var colorBox1 = '<div class="colorBox1"></div>';
			$(colorBox1).css({'background':'white'}).click(function(){
				var data = $(this).data('data');
				data++;
				if(data >= colors.length){
					data = 0;
				}
				$(this).data('data',data).css({'background':colors[data]['color']});
				
				var score = 0;
				
				for(var i = 0; i < colors.length; i++){
					if( $('.colorBox1:eq('+i+')').data('data') == $('.colorBox1:eq('+i+')').data('descination')){
						score++;
					}
				}
				if(score >= colors.length){
					showEndGame();
				}
				else{
					showStartGame();
				}
				
			}).appendTo('.child:eq('+i+')').data({data:-1,descination:childrenDone[i]['descination']});
			$(img).appendTo('.child:eq('+i+')');
		}
		
	}
	
	function showEndGame(){
		$('#page').animate({
			backgroundColor:'#0BFF63',
		},250);
	}
	
	function showStartGame(){
		$('#page').animate({
			backgroundColor:'#fff',
		},250);
	}
	
	function createParents(){
	
		var parents = [
			{parent:'0.png'},
			{parent:'1.png'},
			{parent:'2.png'},
			{parent:'3.png'},
			{parent:'4.png'},
		];
		
		parents.sort(function(){return 0.5 - Math.random()});
		colors.sort(function(){return 0.5 - Math.random()});
		
		for(var i = 0; i < parents.length; i++){
			parentsDone.push({parent:parents[i]['parent'],color:colors[i]['color']});
		}
		
	}
	
	function createChilds(){
		
		for(var i = 0; i < parentsDone.length; i++){
			childrenDone.push({descination:i,child:parentsDone[i]['parent'],color:parentsDone[i]['color']});
		}
		
		childrenDone.sort(function(){return 0.5 - Math.random()});
		
	}
	
	function init(){
		parentsDone = [];
		childrenDone = [];
		createParents();
		createChilds();
		loadParents();
		loadChildren();
	}
	
	$(init);
	
	$('#reset').click(function(){
		showStartGame();
		$('#left').empty();
		$('#right').empty();
		for(var i = 0; i < 5; i++){
			$('<div class="parent"></div>').appendTo('#left');
			$('<div class="child"></div>').appendTo('#right');
		}
		$(init);
	});
	
});