var app = 
{
    configuration: {
        game: {
            animals: [
                {id: 1, name: "Kaczki", count: 1},
                {id: 2, name: "Kury", count: 3},
                //{id: 3, name: "Konie", count: 1},
                {id: 4, name: "Krowy", count: 2},
                {id: 5, name: "Owce", count: 2},
                {id: 6, name: "Koguty", count: 1},
                {id: 7, name: "Zając", count: 1},
                {id: 8, name: "Jaskolki", count: 1}
            ]
        }
    },
    init: function() {
        $('div#success').hide();
        $("#animals").append('<table class="table table-responsive"></table>');        
        $.each(this.configuration.game.animals, function(index, item) {
            $('#animals table').append('<tr><td>' + item.name + '</td><td><input data-id=' + item.id + ' size=2></td></tr>');
        });
        
        //Shuffle animals
        var ul = document.querySelector('#animals table tbody');
        for (var i = ul.children.length; i >= 0; i--) {
            ul.appendChild(ul.children[Math.random() * i | 0]);
        }
    }
};

$(document).ready(function() {
    app.init();
                
    $(document).on('keypress', 'input', function(e) {
        var key = e.which || e.keyCode;
        if(key < 48 || key > 57) {
            return false;
        }
    });                
    
    $(document).on('click', 'a#check', function() {
        var _valid = true;
        
        $('input').each(function(index, item) {
            var _obj = $.grep(app.configuration.game.animals, function(e) { return e.id === $(item).data('id')});

            if(parseInt($(this).val()) !== _obj[0].count) {
                _valid = false;
            }
        });
        
        if(_valid === true) {
            $('.row').hide();
            $('body').css('background-image', 'url(img/bg.jpg)').css('background-size', '100%');
            $('#success').slideToggle();
        }
        return false;
    })
});