$(document).ready(function(){
	
	var elements = [
		{destination:3,dir:'files/img/dzbanek.png'},
		{destination:3,dir:'files/img/kieliszek.png'},
		{destination:1,dir:'files/img/konserwy.png'},
		{destination:0,dir:'files/img/kulka-papieru.png'},
		{destination:2,dir:'files/img/liście.png'},
		{destination:2,dir:'files/img/odpady-inne.png'},
		{destination:2,dir:'files/img/ogryzek.png'},
		{destination:3,dir:'files/img/pojemnik-poperfumach.png'},
		{destination:0,dir:'files/img/pudełko-kartonowe.png'},
		{destination:1,dir:'files/img/puszka.png'},
		{destination:1,dir:'files/img/reklamówka-foliowa.png'},
		{destination:2,dir:'files/img/skórka-po-bananie.png'},
		{destination:0,dir:'files/img/torba-papierowa.png'},
	];
	
	var fields = [
		{number:0,name:'papier',titleCss:'#008FFF',contentCss:'#B0DCFF',img:'files/img/śmieci-papier.png'},
		{number:1,name:'tworzywa sztuczne',titleCss:'#FFFF00',contentCss:'#FFFFD2',img:'files/img/śmieci-tworzywa-sztuczne.png'},
		{number:2,name:'pozostałe odpady',titleCss:'#FF0A00',contentCss:'#FFCAC8',img:'files/img/kosz_inne.png'},
		{number:3,name:'szkło',titleCss:'#00FF33',contentCss:'#B8FFC6',img:'files/img/śmieci-szkło.png'},
	];
	
	function loadFields(){
		for(var i = 0; i < fields.length; i++){
			$('<div class="recyclebin"></div>').appendTo('#container');
			$('<div id="title"><div id="titleContent">'+fields[i]['name']+'</div></div>').css({'background':'url('+fields[i]['img']+')','background-repeat':'no-repeat','background-color':fields[i]['titleCss']}).appendTo('.recyclebin:eq('+i+')');
			$('<div class="droppable"></div>').data({'number':fields[i]['number']}).droppable({
				accept: '#draggable div',
				hoverClass: 'hovered',
				drop: drop
			}).css({'background':fields[i]['contentCss']}).appendTo('.recyclebin:eq('+i+')');
		}
	}
	
	function drop(event,ui){
		ui.draggable.data('parent',$(this).data('number'));
		checkEnd();
	}
	
	function checkEnd(){
		var score = 0;
		for(var i = 0; i < elements.length; i++){
			if($('.trash:eq('+i+')').data('parent') == $('.trash:eq('+i+')').data('destination')){
				score++;
			}
		}
		if(score == elements.length){
			console.log('win');
			$('#smile').css({'display':'block'});
		}
		else{
			$('#smile').css({'display':'none'});
		}
	}
	
	function loadElements(){
		var width = 0;
		var top = 5;
		$('<div id="draggable"></div>').appendTo('#page');
		for(var i = 0; i < elements.length; i++){
			$('<div class="trash"><img src="'+elements[i]['dir']+'"/></div>').data({'parent':-1,'destination':elements[i]['destination']}).appendTo('#draggable').draggable({
				containment: '#page',
				stack: '#draggable div',
				revert: false,
			}).css({'top':top,'left':(10+(i*2))});
		}
	}
	
	function init(){
		elements.sort(function(){return 0.5 - Math.random()});
		loadFields();
		loadElements();
		$('<div id="reset"><img src="files/img/reset.png" style="width: 28px;"></div>').appendTo('#page').click(function(){
			reset();
		});
		$('<div id="smile"></div>').html(':)').appendTo('#page');
	}
	
	$(init);
	
	function reset(){
		$('#page').empty();
		$('<div id="container"></div>').appendTo('#page');
		$(init);
	}
	
});